/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.acme.insurance.Driver;
import org.acme.insurance.Policy;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ClassLoaderBuilder;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.guvnor.server.builder.ModuleAssemblerConfiguration;
import org.drools.guvnor.server.builder.PackageAssembler;
import org.drools.guvnor.server.selector.AssetSelector;
import org.drools.guvnor.server.selector.SelectorManager;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.rule.Package;
import org.drools.util.CompositeClassLoader;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mvel2.MVEL;

public class PackageAssemblerIntegrationTest
extends GuvnorIntegrationTest {
    @Test
    public void testPackageConfigWithErrors() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testBuilderPackageConfig", "x");
        DroolsHeader.updateDroolsHeader((String)"import java.util.List", (ModuleItem)pkg);
        AssetItem func = pkg.addAsset("func1", "a function");
        func.updateFormat("function");
        func.updateContent("function void doSomething() { \n System.err.println(List.class.toString()); }");
        func.checkin("yeah");
        func = pkg.addAsset("func2", "q");
        func.updateFormat("function");
        func.updateContent("function void foo() { \nSystem.err.println(42); \n}");
        func.checkin("");
        AssetItem ass = pkg.addAsset("dsl", "m");
        ass.updateFormat("dsl");
        ass.updateContent("[when]Foo bar=String()");
        ass.checkin("");
        this.rulesRepository.save();
        PackageAssembler assembler = new PackageAssembler();
        assembler.init(pkg, null);
        assembler.compile();
        Assert.assertFalse((boolean)assembler.hasErrors());
        Package[] binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])assembler.getCompiledBinary());
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        Package bin = binPkgs[0];
        Assert.assertNotNull((Object)bin);
        Assert.assertEquals((Object)"testBuilderPackageConfig", (Object)bin.getName());
        Assert.assertEquals((long)2L, (long)bin.getFunctions().size());
        Assert.assertTrue((boolean)bin.isValid());
        Assert.assertEquals((long)1L, (long)assembler.getBuilder().getDSLMappingFiles().size());
        DroolsHeader.updateDroolsHeader((String)"koo koo ca choo", (ModuleItem)pkg);
        assembler = new PackageAssembler();
        assembler.init(pkg, null);
        assembler.compile();
        Assert.assertTrue((boolean)assembler.hasErrors());
        Assert.assertTrue((boolean)assembler.isModuleConfigurationInError());
        DroolsHeader.updateDroolsHeader((String)"import java.util.Date", (ModuleItem)pkg);
        assembler = new PackageAssembler();
        assembler.init(pkg, null);
        assembler.compile();
        Assert.assertTrue((boolean)assembler.hasErrors());
        Assert.assertTrue((boolean)((ContentAssemblyError)assembler.getErrors().get(0)).isAssetItem());
        Assert.assertEquals((Object)"func1", (Object)((ContentAssemblyError)assembler.getErrors().get(0)).getName());
        try {
            assembler.getCompiledBinary();
            Assert.fail((String)"should not work as is in error.");
        }
        catch (IllegalStateException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        DroolsHeader.updateDroolsHeader((String)"import java.util.List", (ModuleItem)pkg);
        assembler = new PackageAssembler();
        assembler.init(pkg, null);
        assembler.compile();
        Assert.assertFalse((boolean)assembler.hasErrors());
        ass.updateContent("rubbish");
        ass.checkin("");
        assembler = new PackageAssembler();
        assembler.init(pkg, null);
        assembler.compile();
        ass.updateContent("[when]foo=String()");
        ass.checkin("");
        assembler = new PackageAssembler();
        assembler.init(pkg, null);
        assembler.compile();
        Assert.assertFalse((boolean)assembler.hasErrors());
        func.updateContent("goo");
        func.checkin("");
        assembler = new PackageAssembler();
        assembler.init(pkg, null);
        assembler.compile();
        Assert.assertTrue((boolean)assembler.hasErrors());
        Assert.assertFalse((boolean)assembler.isModuleConfigurationInError());
        Assert.assertTrue((boolean)((ContentAssemblyError)assembler.getErrors().get(0)).getName().equals(func.getName()));
        this.assertNotEmpty(((ContentAssemblyError)assembler.getErrors().get(0)).getErrorReport());
    }

    @Test
    public void testLoadConfProperties() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testLoadConfProperties", "");
        AssetItem model = pkg.addAsset("model", "qed");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/billasurf.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when Board() \n then customer.setAge(42); \n end");
        rule1.checkin("");
        AssetItem props1 = pkg.addAsset("conf1", "");
        props1.updateFormat("properties");
        props1.updateContent("drools.accumulate.function.groupCount = org.drools.base.accumulators.MaxAccumulateFunction");
        props1.checkin("");
        AssetItem props2 = pkg.addAsset("conf2", "");
        props2.updateFormat("conf");
        props2.updateBinaryContentAttachment((InputStream)new ByteArrayInputStream("drools.accumulate.function.groupFun = org.drools.base.accumulators.MinAccumulateFunction".getBytes()));
        props2.checkin("");
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertEquals((Object)"org.drools.base.accumulators.MaxAccumulateFunction", (Object)asm.getBuilder().getPackageBuilderConfiguration().getAccumulateFunction("groupCount").getClass().getName());
        Assert.assertEquals((Object)"org.drools.base.accumulators.MinAccumulateFunction", (Object)asm.getBuilder().getPackageBuilderConfiguration().getAccumulateFunction("groupFun").getClass().getName());
    }

    @Test
    public void testPackageWithRuleflow() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem packageItem = repo.createModule("testPackageWithRuleFlow", "");
        AssetItem model = packageItem.addAsset("model", "qed");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/billasurf.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer", (ModuleItem)packageItem);
        AssetItem rule1 = packageItem.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when Board() \n then customer.setAge(42); \n end");
        rule1.checkin("");
        AssetItem ruleFlow = packageItem.addAsset("ruleFlow", "");
        ruleFlow.updateFormat("rf");
        ruleFlow.updateBinaryContentAttachment(this.getClass().getResourceAsStream("drools/ruleflow.rfm"));
        ruleFlow.checkin("");
        PackageAssembler asm = new PackageAssembler();
        asm.init(packageItem, null);
        asm.compile();
        Assert.assertFalse((boolean)asm.hasErrors());
        Map flows = asm.getBuilder().getPackage().getRuleFlows();
        Assert.assertNotNull((Object)flows);
        Assert.assertEquals((long)1L, (long)flows.size());
        Object flow = flows.values().iterator().next();
        Assert.assertNotNull(flow);
        Assert.assertTrue((boolean)(flow instanceof RuleFlowProcess));
        ClassLoaderBuilder classLoaderBuilder = new ClassLoaderBuilder(packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"jar"}));
        BRMSPackageBuilder builder = new BRMSPackageBuilder(new Properties(), (ClassLoader)classLoaderBuilder.buildClassLoader());
        CompositeClassLoader newCL = builder.getPackageBuilderConfiguration().getClassLoader();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)newCL);
        Object o = MVEL.eval((String)"new com.billasurf.Board()");
        Assert.assertEquals((Object)"com.billasurf.Board", (Object)o.getClass().getName());
        System.err.println(o.toString());
        Thread.currentThread().setContextClassLoader(oldCL);
        builder.addPackageFromDrl((Reader)new StringReader("package foo\n import com.billasurf.Board"));
        Class o2 = builder.getPackageRegistry("foo").getTypeResolver().resolveType("Board");
        Assert.assertNotNull((Object)o2);
        Assert.assertEquals((Object)"com.billasurf.Board", (Object)o2.getName());
    }

    @Test
    public void testWithNoDeclaredTypes() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testSimplePackageWithDeclaredTypes1", "");
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("model.drl");
        rule1.checkin("");
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertFalse((String)asm.getErrors().toString(), (boolean)asm.hasErrors());
    }

    @Test
    public void testSimplePackageWithDeclaredTypes() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testSimplePackageWithDeclaredTypes2", "");
        DroolsHeader.updateDroolsHeader((String)"import java.util.HashMap", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n dialect 'mvel' \n when Album() \n then \nAlbum a = new Album(); \n end");
        rule1.checkin("");
        AssetItem model = pkg.addAsset("model", "qed");
        model.updateFormat("model.drl");
        model.updateContent("declare Album\n genre: String \n end");
        model.checkin("");
        repo.save();
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertFalse((String)asm.getErrors().toString(), (boolean)asm.hasErrors());
        Assert.assertNotNull((Object)asm.getCompiledBinary());
        Package[] binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm.getCompiledBinary());
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        Package bin = binPkgs[0];
        Assert.assertNotNull((Object)bin);
        Assert.assertEquals((Object)pkg.getName(), (Object)bin.getName());
        Assert.assertTrue((boolean)bin.isValid());
    }

    @Test
    public void testSimplePackageAttributes() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testSimplePackageAttributes", "");
        DroolsHeader.updateDroolsHeader((String)"import java.util.HashMap\nno-loop true\nagenda-group \"albums\"\ndialect \"java\"\n", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n dialect \"mvel\" \n when Album() \n then \nAlbum a = new Album(); \n end");
        rule1.checkin("");
        AssetItem model = pkg.addAsset("model", "qed");
        model.updateFormat("model.drl");
        model.updateContent("declare Album\n genre: String \n end");
        model.checkin("");
        repo.save();
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertFalse((boolean)asm.hasErrors());
        Assert.assertNotNull((Object)asm.getCompiledBinary());
        Package[] binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm.getCompiledBinary());
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        Package bin = binPkgs[0];
        Assert.assertNotNull((Object)bin);
        Assert.assertEquals((Object)pkg.getName(), (Object)bin.getName());
        Assert.assertTrue((boolean)bin.isValid());
        Assert.assertEquals((long)1L, (long)bin.getRules().length);
        Assert.assertEquals((Object)"albums", (Object)bin.getRule("rule1").getAgendaGroup());
        Assert.assertEquals((Object)true, (Object)bin.getRule("rule1").isNoLoop());
        Assert.assertEquals((Object)"mvel", (Object)bin.getRule("rule1").getDialect());
    }

    @Test
    public void testSimplePackageWithDeclaredTypesUsingDependency() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testSimplePackageWithDeclaredTypesUsingDependency", "");
        DroolsHeader.updateDroolsHeader((String)"import java.util.HashMap", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n dialect 'mvel' \n when Album() \n then \nAlbum a = new Album(); \n end");
        rule1.checkin("");
        AssetItem model = pkg.addAsset("model", "qed");
        model.updateFormat("model.drl");
        model.updateContent("declare Album\n genre1: String \n end");
        model.checkin("version 0");
        model.updateContent("declare Album\n genre2: String \n end");
        model.checkin("version 1");
        model.updateContent("declare Album\n genre3: String \n end");
        model.checkin("version 2");
        repo.save();
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertFalse((String)asm.getErrors().toString(), (boolean)asm.hasErrors());
        Assert.assertNotNull((Object)asm.getCompiledBinary());
        Package[] binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm.getCompiledBinary());
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        Package bin = binPkgs[0];
        Assert.assertNotNull((Object)bin);
        Assert.assertEquals((Object)pkg.getName(), (Object)bin.getName());
        Assert.assertTrue((boolean)bin.isValid());
        pkg.updateDependency("model?version=2");
        pkg.checkin("Update dependency");
        PackageAssembler asm2 = new PackageAssembler();
        asm2.init(pkg, null);
        asm2.compile();
        Assert.assertFalse((String)asm2.getErrors().toString(), (boolean)asm2.hasErrors());
        Package[] bin2Pkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm2.getCompiledBinary());
        Assert.assertNotNull((Object)bin2Pkgs);
        Assert.assertEquals((long)1L, (long)bin2Pkgs.length);
        Package bin2 = bin2Pkgs[0];
        Assert.assertNotNull((Object)bin2);
        Assert.assertEquals((Object)pkg.getName(), (Object)bin2.getName());
        Assert.assertTrue((boolean)bin2.isValid());
    }

    @Test
    public void testSimplePackageBuildNoErrors() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testSimplePackageBuildNoErrors", "");
        AssetItem model = pkg.addAsset("model", "qed");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/billasurf.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when Board() \n then customer.setAge(42); \n end");
        rule1.checkin("");
        AssetItem rule2 = pkg.addAsset("rule2", "");
        rule2.updateFormat("drl");
        rule2.updateContent("agenda-group 'q' \n when \n Board() \n then \n System.err.println(42);");
        rule2.checkin("");
        AssetItem rule3 = pkg.addAsset("A file", "");
        rule3.updateFormat("drl");
        rule3.updateContent("package testSimplePackageBuildNoErrors\n rule 'rule3' \n when \n then \n customer.setAge(43); \n end \nrule 'rule4' \n when \n then \n System.err.println(44); \n end");
        rule3.checkin("");
        repo.save();
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertFalse((boolean)asm.hasErrors());
        Package bin = asm.getBuilder().getPackage();
        Assert.assertEquals((Object)pkg.getName(), (Object)bin.getName());
        Assert.assertTrue((boolean)bin.isValid());
        Assert.assertEquals((long)4L, (long)bin.getRules().length);
        repo.createModuleSnapshot(pkg.getName(), "SNAP_1");
        DroolsHeader.updateDroolsHeader((String)"koo koo ca choo", (ModuleItem)pkg);
        asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertTrue((boolean)asm.hasErrors());
        pkg = repo.loadModuleSnapshot(pkg.getName(), "SNAP_1");
        asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertFalse((boolean)asm.hasErrors());
    }

    @Test
    public void testIgnoreArchivedItems() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testIgnoreArchivedItems", "");
        AssetItem model = pkg.addAsset("model", "qed");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/billasurf.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when Board() \n then customer.setAge(42); \n end");
        rule1.checkin("");
        AssetItem rule2 = pkg.addAsset("rule2", "");
        rule2.updateFormat("drl");
        rule2.updateContent("agenda-group 'q' \n when \n Boardx() \n then \n System.err.println(42);");
        rule2.checkin("");
        repo.save();
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertTrue((boolean)asm.hasErrors());
        rule2.archiveItem(true);
        rule2.checkin("");
        Assert.assertTrue((boolean)rule2.isArchived());
        asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertFalse((boolean)asm.hasErrors());
    }

    @Test
    public void testErrorsInRuleAsset() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testErrorsInRuleAsset", "");
        AssetItem model = pkg.addAsset("model", "qed");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/billasurf.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer", (ModuleItem)pkg);
        repo.save();
        AssetItem goodRule = pkg.addAsset("goodRule", "");
        goodRule.updateFormat("drl");
        goodRule.updateContent("rule 'yeah' \n when \n Board() \n then \n System.out.println(42); end");
        goodRule.checkin("");
        AssetItem badRule = pkg.addAsset("badRule", "xxx");
        badRule.updateFormat("drl");
        badRule.updateContent("if something then another");
        badRule.checkin("");
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertTrue((boolean)asm.hasErrors());
        Assert.assertFalse((boolean)asm.isModuleConfigurationInError());
        for (ContentAssemblyError err : asm.getErrors()) {
            Assert.assertTrue((boolean)err.getName().equals(badRule.getName()));
            this.assertNotEmpty(err.getErrorReport());
        }
    }

    @Test
    @Ignore(value="Temporally ignored -Rikkola-")
    public void testEventingExample() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testEventingExample", "");
        AssetItem model = pkg.addAsset("model", "qed");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("drools/eventing-example.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.examples.eventing.EventRequest\n", (ModuleItem)pkg);
        AssetItem asset = pkg.addAsset("whee", "");
        asset.updateFormat("drl");
        asset.updateContent("rule 'zaa'\n  when \n  request: EventRequest( status == EventRequest.Status.ACTIVE )\n   then \n request.setStatus(EventRequest.Status.ACTIVE); \n  end");
        asset.checkin("");
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        if (asm.hasErrors()) {
            for (ContentAssemblyError err : asm.getErrors()) {
                System.err.println(err.getErrorReport());
            }
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRuleAndDSLAndFunction() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testRuleAndDSLAndFunction", "");
        AssetItem model = pkg.addAsset("model", "qed");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/billasurf.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer", (ModuleItem)pkg);
        repo.save();
        AssetItem func = pkg.addAsset("func", "");
        func.updateFormat("function");
        func.updateContent("function void foo() { System.out.println(42); }");
        func.checkin("");
        AssetItem dsl = pkg.addAsset("myDSL", "");
        dsl.updateFormat("dsl");
        dsl.updateContent("[then]call a func=foo();");
        dsl.checkin("");
        AssetItem dsl2 = pkg.addAsset("myDSL2", "");
        dsl2.updateFormat("dsl");
        dsl2.updateContent("[when]There is a board=Board()");
        dsl2.checkin("");
        AssetItem rule = pkg.addAsset("myRule", "");
        rule.updateFormat("dslr");
        rule.updateContent("when \n There is a board \n then \n call a func");
        rule.checkin("");
        AssetItem rule2 = pkg.addAsset("myRule2", "");
        rule2.updateFormat("dslr");
        rule2.updateContent("package testRuleAndDSLAndFunction \n rule 'myRule2222' \n when \n There is a board \n then \n call a func \nend");
        rule2.checkin("");
        AssetItem rule3 = pkg.addAsset("myRule3", "");
        rule3.updateFormat("drl");
        rule3.updateContent("package testRuleAndDSLAndFunction\n rule 'rule3' \n when \n Board() \n then \n System.err.println(42); end");
        rule3.checkin("");
        repo.save();
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertFalse((boolean)asm.hasErrors());
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)asm.getBuilder().getRootClassLoader());
            Package[] binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm.getCompiledBinary());
            Assert.assertNotNull((Object)binPkgs);
            Assert.assertEquals((long)1L, (long)binPkgs.length);
            Package bin = binPkgs[0];
            Assert.assertNotNull((Object)bin);
            Assert.assertEquals((long)3L, (long)bin.getRules().length);
            Assert.assertEquals((long)1L, (long)bin.getFunctions().size());
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Test
    public void testSkipDisabledPackageStuff() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testSkipDisabledPackageStuff", "");
        repo.save();
        AssetItem assertRule1 = pkg.addAsset("model1", "");
        assertRule1.updateFormat("model.drl");
        assertRule1.updateContent("garbage");
        assertRule1.updateDisabled(true);
        assertRule1.checkin("");
        assertRule1 = pkg.addAsset("function1", "");
        assertRule1.updateFormat("function");
        assertRule1.updateContent("garbage");
        assertRule1.updateDisabled(true);
        assertRule1.checkin("");
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertFalse((boolean)asm.hasErrors());
    }

    @Test
    public void testXLSDecisionTable() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testXLSDecisionTable", "");
        DroolsHeader.updateDroolsHeader((String)"import org.acme.insurance.Policy\n import org.acme.insurance.Driver", (ModuleItem)pkg);
        repo.save();
        InputStream xls = this.getClass().getResourceAsStream("/SampleDecisionTable.xls");
        Assert.assertNotNull((Object)xls);
        AssetItem asset = pkg.addAsset("MyDT", "");
        asset.updateFormat("xls");
        asset.updateBinaryContentAttachment(xls);
        asset.checkin("");
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        if (asm.hasErrors()) {
            System.err.println(((ContentAssemblyError)asm.getErrors().get(0)).getErrorReport());
        }
        Assert.assertFalse((boolean)asm.hasErrors());
        Package[] binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm.getCompiledBinary());
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        Package bin = binPkgs[0];
        Assert.assertNotNull((Object)bin);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        rb.addPackage(bin);
        StatefulSession wm = rb.newStatefulSession();
        Driver driver = new Driver();
        Policy policy = new Policy();
        wm.insert((Object)driver);
        wm.insert((Object)policy);
        wm.fireAllRules();
        Assert.assertEquals((long)120L, (long)policy.getBasePrice());
        asset.updateBinaryContentAttachment(this.getClass().getResourceAsStream("drools/SampleDecisionTable_WithError.xls"));
        asset.checkin("");
        asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertTrue((boolean)asm.hasErrors());
        Assert.assertEquals((Object)asset.getName(), (Object)((ContentAssemblyError)asm.getErrors().get(0)).getName());
        asm = new PackageAssembler();
        asm.init(pkg, null);
        Assert.assertFalse((boolean)asm.hasErrors());
    }

    @Test
    public void testBRXMLWithDSLMixedIn() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testBRLWithDSLMixedIn", "");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Person", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule2", "");
        rule1.updateFormat("brl");
        AssetItem dsl = pkg.addAsset("MyDSL", "");
        dsl.updateFormat("dsl");
        dsl.updateContent("[when]This is a sentence=Person()\n[then]say {hello}=System.err.println({hello});");
        dsl.checkin("");
        RuleModel model = new RuleModel();
        model.name = "rule2";
        FactPattern pattern = new FactPattern("Person");
        pattern.setBoundName("p");
        ActionSetField action = new ActionSetField("p");
        ActionFieldValue value = new ActionFieldValue("age", "42", "Integer");
        action.addFieldValue(value);
        model.addLhsItem((IPattern)pattern);
        model.addRhsItem((IAction)action);
        DSLSentence dslCondition = new DSLSentence();
        dslCondition.setDefinition("This is a sentence");
        model.addLhsItem((IPattern)dslCondition);
        DSLSentence dslAction = new DSLSentence();
        dslAction.setDefinition("say {42}");
        model.addRhsItem((IAction)dslAction);
        rule1.updateContent(BRXMLPersistence.getInstance().marshal(model));
        rule1.checkin("");
        repo.save();
        model = new RuleModel();
        model.name = "ruleNODSL";
        pattern = new FactPattern("Person");
        pattern.setBoundName("p");
        action = new ActionSetField("p");
        value = new ActionFieldValue("age", "42", "Integer");
        action.addFieldValue(value);
        model.addLhsItem((IPattern)pattern);
        model.addRhsItem((IAction)action);
        AssetItem ruleNODSL = pkg.addAsset("ruleNoDSL", "");
        ruleNODSL.updateFormat("brl");
        ruleNODSL.updateContent(BRXMLPersistence.getInstance().marshal(model));
        ruleNODSL.checkin("");
        pkg = repo.loadModule("testBRLWithDSLMixedIn");
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Assert.assertFalse((boolean)asm.hasErrors());
        Package[] binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm.getCompiledBinary());
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        Package bin = binPkgs[0];
        Assert.assertEquals((long)2L, (long)bin.getRules().length);
    }

    @Test
    public void testCustomSelector() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testCustomSelector", "");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Person", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("when \n Person() \n then \n System.out.println(\"yeah\");\n");
        rule1.checkin("");
        AssetItem rule2 = pkg.addAsset("rule2", "");
        rule2.updateFormat("drl");
        rule2.updateContent("when \n Person() \n then \n System.out.println(\"yeah\");\n");
        rule2.checkin("");
        SelectorManager sm = SelectorManager.getInstance();
        sm.selectors.put("testSelect", new AssetSelector(){

            public boolean isAssetAllowed(AssetItem asset) {
                return asset.getName().equals("rule2");
            }
        });
        ModuleAssemblerConfiguration configuration = new ModuleAssemblerConfiguration();
        configuration.setBuildMode("customSelector");
        configuration.setCustomSelectorConfigName("testSelect");
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, configuration);
        asm.compile();
        Package[] binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm.getCompiledBinary());
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        Package pk = binPkgs[0];
        Assert.assertNotNull((Object)pk);
        Assert.assertEquals((long)1L, (long)pk.getRules().length);
        Assert.assertEquals((Object)"rule2", (Object)pk.getRules()[0].getName());
        asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm.getCompiledBinary());
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        pk = binPkgs[0];
        Assert.assertNotNull((Object)pk);
        Assert.assertEquals((long)2L, (long)pk.getRules().length);
        configuration = new ModuleAssemblerConfiguration();
        configuration.setBuildMode("customSelector");
        configuration.setCustomSelectorConfigName("nothing valid");
        asm = new PackageAssembler();
        asm.init(pkg, configuration);
        asm.compile();
        Assert.assertTrue((boolean)asm.hasErrors());
        Assert.assertEquals((long)1L, (long)asm.getErrors().size());
        Assert.assertEquals((Object)pkg.getName(), (Object)((ContentAssemblyError)asm.getErrors().get(0)).getName());
        Assert.assertTrue((boolean)((ContentAssemblyError)asm.getErrors().get(0)).isModuleItem());
        Assert.assertEquals((Object)pkg.getUUID(), (Object)((ContentAssemblyError)asm.getErrors().get(0)).getUUID());
        configuration = new ModuleAssemblerConfiguration();
        configuration.setBuildMode("customSelector");
        configuration.setCustomSelectorConfigName("");
        asm = new PackageAssembler();
        asm.init(pkg, configuration);
        asm.compile();
        binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm.getCompiledBinary());
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        pk = binPkgs[0];
        Assert.assertNotNull((Object)pk);
        Assert.assertEquals((long)2L, (long)pk.getRules().length);
    }

    @Test
    public void testBuiltInSelector() throws Exception {
        RulesRepository repo = this.rulesRepository;
        CategoryItem rootCat = repo.loadCategory("/");
        CategoryItem testBuiltInSelectorCategory1 = rootCat.addCategory("testBuiltInSelectorCategory1", "yeah");
        testBuiltInSelectorCategory1.addCategory("testBuiltInSelectorCategory1Child", "yeah");
        CategoryItem testBuiltInSelectorCategory2 = rootCat.addCategory("testBuiltInSelectorCategory2", "yeah");
        testBuiltInSelectorCategory2.addCategory("testBuiltInSelectorCategory2Child", "yeah");
        ModuleItem pkg = repo.createModule("testBuiltInSelector", "");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Person", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule1", "");
        rule1.updateFormat("drl");
        rule1.updateCategoryList(new String[]{"testBuiltInSelectorCategory1/testBuiltInSelectorCategory1Child"});
        rule1.updateContent("when \n Person() \n then \n System.out.println(\"yeah\");\n");
        rule1.checkin("");
        AssetItem rule2 = pkg.addAsset("rule2", "");
        rule2.updateFormat("drl");
        rule2.updateCategoryList(new String[]{"testBuiltInSelectorCategory2/testBuiltInSelectorCategory2Child"});
        rule2.updateContent("when \n Person() \n then \n System.out.println(\"yeah\");\n");
        rule2.checkin("");
        SelectorManager sm = SelectorManager.getInstance();
        sm.selectors.put("testSelect", new AssetSelector(){

            public boolean isAssetAllowed(AssetItem asset) {
                return asset.getName().equals("rule2");
            }
        });
        ModuleAssemblerConfiguration packageAssemblerConfiguration = new ModuleAssemblerConfiguration();
        packageAssemblerConfiguration.setBuildMode("BuiltInSelector");
        packageAssemblerConfiguration.setEnableStatusSelector(false);
        packageAssemblerConfiguration.setCategoryOperator("=");
        packageAssemblerConfiguration.setCategoryValue("testBuiltInSelectorCategory1/testBuiltInSelectorCategory1Child");
        packageAssemblerConfiguration.setEnableCategorySelector(true);
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        asm.compile();
        Package[] binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm.getCompiledBinary());
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        Package pk = binPkgs[0];
        Assert.assertNotNull((Object)pk);
        Assert.assertEquals((long)2L, (long)pk.getRules().length);
        asm = new PackageAssembler();
        asm.init(pkg, packageAssemblerConfiguration);
        asm.compile();
        binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm.getCompiledBinary());
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        pk = binPkgs[0];
        Assert.assertNotNull((Object)pk);
        Assert.assertEquals((long)1L, (long)pk.getRules().length);
        Assert.assertEquals((Object)"rule1", (Object)pk.getRules()[0].getName());
        packageAssemblerConfiguration = new ModuleAssemblerConfiguration();
        packageAssemblerConfiguration.setBuildMode("BuiltInSelector");
        packageAssemblerConfiguration.setEnableStatusSelector(false);
        packageAssemblerConfiguration.setCategoryOperator("!=");
        packageAssemblerConfiguration.setCategoryValue("testBuiltInSelectorCategory1/testBuiltInSelectorCategory1Child");
        packageAssemblerConfiguration.setEnableCategorySelector(true);
        asm = new PackageAssembler();
        asm.init(pkg, packageAssemblerConfiguration);
        asm.compile();
        binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])asm.getCompiledBinary());
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        pk = binPkgs[0];
        Assert.assertNotNull((Object)pk);
        Assert.assertEquals((long)1L, (long)pk.getRules().length);
        Assert.assertEquals((Object)"rule2", (Object)pk.getRules()[0].getName());
    }

    private void assertNotEmpty(String s) {
        if (s == null) {
            Assert.fail((String)"should not be null");
        }
        if (s.trim().equals("")) {
            Assert.fail((String)"should not be empty string");
        }
    }
}

