/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import java.io.InputStream;
import org.drools.guvnor.server.contenthandler.ModelContentHandler;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.junit.Assert;
import org.junit.Test;

public class ModelContentHandlerIntegrationTest
extends GuvnorIntegrationTest {
    @Test
    public void testModelAttached() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pacakge = repo.createModule("testModelAttachedPack", "for test");
        AssetItem asset = pacakge.addAsset("testModelAttachedAsset", "description");
        InputStream is = this.getClass().getResourceAsStream("domain.objects-1.1.8.jar");
        asset.updateBinaryContentAttachment(is);
        ModelContentHandler modelContentHandler = new ModelContentHandler();
        modelContentHandler.onAttachmentAdded(asset);
        String header = DroolsHeader.getDroolsHeader((ModuleItem)pacakge);
        Assert.assertTrue((header.indexOf("package-info.class") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testModelRemoved() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testModelRemovedPackage", "for test");
        AssetItem asset = pkg.addAsset("testModelRemovedAsset", "description");
        DroolsHeader.updateDroolsHeader((String)"import something.Else\n", (ModuleItem)pkg);
        InputStream is = this.getClass().getResourceAsStream("domain.objects-1.1.8.jar");
        asset.updateBinaryContentAttachment(is);
        ModelContentHandler modelContentHandler = new ModelContentHandler();
        modelContentHandler.onAttachmentAdded(asset);
        String header = DroolsHeader.getDroolsHeader((ModuleItem)pkg);
        Assert.assertTrue((header.length() > 0 ? 1 : 0) != 0);
        modelContentHandler.onAttachmentRemoved(asset);
        header = DroolsHeader.getDroolsHeader((ModuleItem)pkg);
        Assert.assertEquals((Object)"import something.Else", (Object)header.trim());
    }
}

