/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ProtocolOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKAgentConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKBaseConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKSessionConfig;
import org.drools.guvnor.server.contenthandler.drools.ServiceConfigPersistence;
import org.junit.Test;

public class ServiceConfigPersistenceTest {
    private static final Collection<AssetReference> resources = new ArrayList<AssetReference>(){
        {
            this.add(new AssetReference("myPkg", "a", "drl", "http://localhost/c/source", "uuid1"));
            this.add(new AssetReference("myPkg", "aa", "drl", "http://localhost/cc/source", "uuid2"));
            this.add(new AssetReference("myPkg", "ab", "changeset", "http://localhost/cd/source", "uuid3"));
        }
    };
    private static final Collection<AssetReference> models = new ArrayList<AssetReference>(){
        {
            this.add(new AssetReference("myPkg", "a.jar", "model", "http://localhost/a.jar", "uudi44"));
        }
    };
    private static final ServiceConfig REST_SERVICE_CONFIG = new ServiceConfig(){
        {
            ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
            kbase1.addModels(models);
            kbase1.addResources(resources);
            ServiceKSessionConfig ksession1 = new ServiceKSessionConfig("ksession1");
            ServiceKAgentConfig kagent = new ServiceKAgentConfig("kagent1");
            kagent.setNewInstance(false);
            kbase1.addKsession(ksession1);
            kbase1.addKagent(kagent);
            this.addKBase(kbase1);
            this.setPollingFrequency(70);
        }
    };
    private static final ServiceConfig WS_SERVICE_CONFIG = new ServiceConfig(){
        {
            ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
            kbase1.addModels(models);
            kbase1.addResources(resources);
            ServiceKSessionConfig ksession1 = new ServiceKSessionConfig("ksession1");
            ksession1.setProtocol(ProtocolOption.WEB_SERVICE);
            ServiceKAgentConfig kagent = new ServiceKAgentConfig("kagent1");
            kagent.setNewInstance(false);
            kbase1.addKsession(ksession1);
            kbase1.addKagent(kagent);
            this.addKBase(kbase1);
            this.setPollingFrequency(70);
        }
    };

    @Test
    public void testEmpty() {
        ServiceConfig BASE = new ServiceConfig(){
            {
                ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
                kbase1.addKsession(new ServiceKSessionConfig("ksession1"));
                this.addKBase(kbase1);
            }
        };
        String result = ServiceConfigPersistence.getInstance().marshal(null);
        Assert.assertEquals((String)"", (String)result);
        ServiceConfig config = ServiceConfigPersistence.getInstance().unmarshal(result);
        Assert.assertNotNull((Object)config);
        Assert.assertTrue((boolean)new ServiceConfig(BASE).equals((Object)config));
    }

    @Test
    public void testAssets() {
        String result = ServiceConfigPersistence.getInstance().marshal(REST_SERVICE_CONFIG);
        Assert.assertFalse((boolean)result.equals(""));
        ServiceConfig config = ServiceConfigPersistence.getInstance().unmarshal(result);
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)REST_SERVICE_CONFIG, (Object)config);
    }

    @Test
    public void testComplete() {
        String result = ServiceConfigPersistence.getInstance().marshal(WS_SERVICE_CONFIG);
        Assert.assertFalse((boolean)result.equals(""));
        ServiceConfig config = ServiceConfigPersistence.getInstance().unmarshal(result);
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)WS_SERVICE_CONFIG, (Object)config);
    }
}

