/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.generators;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssertBehaviorOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ClockType;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.EventProcessingOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.MarshallingOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ProtocolOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKAgentConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKBaseConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKSessionConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.SessionType;
import org.drools.guvnor.client.rpc.MavenArtifact;
import org.drools.guvnor.server.generators.ServiceWarGenerator;
import org.drools.guvnor.server.maven.cache.GuvnorArtifactCacheSupport;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultipleKBasesKSessionsGeneratorTest {
    private static final List<AssetReference> resources = new ArrayList<AssetReference>(){
        {
            this.add(new AssetReference("myPkg", "a", "drl", "http://localhost/c/source", "uuid1"));
            this.add(new AssetReference("myPkg", "aa", "drl", "http://localhost/cc/source", "uuid2"));
            this.add(new AssetReference("myPkg", "ab", "changeset", "http://localhost/cd/source", "uuid3"));
        }
    };
    private static final List<AssetReference> models = new ArrayList<AssetReference>(){
        {
            this.add(new AssetReference("myPkg", "a.jar", "model", "http://localhost/a.jar", "uudi44"));
        }
    };

    @Before
    @After
    public void cleanUp() {
        GuvnorArtifactCacheSupport.cleanTempDir();
    }

    @Test
    public void testMultiKBaseKSession() throws IOException, URISyntaxException {
        this.setupLocalCache();
        ServiceConfig config = new ServiceConfig(){
            {
                ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
                kbase1.addModels((Collection)models);
                kbase1.addResources((Collection)resources);
                kbase1.setAssetsUser("admin");
                kbase1.setAssetsPassword("admin");
                kbase1.setAssertBehavior(AssertBehaviorOption.IDENTITY);
                ServiceKSessionConfig ksession1 = new ServiceKSessionConfig("ksession1");
                ksession1.setType(SessionType.STATEFUL);
                ksession1.setUrl("myksession1");
                ksession1.setKeepReference(true);
                ksession1.setClockType(ClockType.PSEUDO);
                ServiceKSessionConfig ksession2 = new ServiceKSessionConfig("ksession2");
                ksession2.setUrl("myksession2");
                ksession2.setKeepReference(false);
                ksession2.setMarshalling(MarshallingOption.JAXB);
                kbase1.addKsession(ksession1);
                kbase1.addKsession(ksession2);
                this.addKBase(kbase1);
                ServiceKBaseConfig kbase2 = new ServiceKBaseConfig("kbase2");
                kbase2.addResource(new AssetReference("myPkg", "ax", "changeset", "http://localhost/cd/source", "uuidx9"));
                kbase2.setAssetsUser("admin");
                kbase2.setAssetsPassword("admin");
                kbase2.setMbeans(true);
                kbase2.setEventProcessingMode(EventProcessingOption.STREAM);
                ServiceKSessionConfig ksession3 = new ServiceKSessionConfig("ksession3");
                ksession3.setUrl("myksession3");
                ksession3.setProtocol(ProtocolOption.WEB_SERVICE);
                ksession3.setClockType(ClockType.REALTIME);
                ServiceKSessionConfig ksession4 = new ServiceKSessionConfig("ksession4");
                ksession4.setProtocol(ProtocolOption.WEB_SERVICE);
                ksession4.setMarshalling(MarshallingOption.JSON);
                kbase2.addKsession(ksession3);
                kbase2.addKsession(ksession4);
                this.addKBase(kbase2);
            }
        };
        File temp = File.createTempFile("drools-service", ".jar");
        temp.deleteOnExit();
        FileOutputStream out = new FileOutputStream(temp);
        ServiceWarGenerator.buildWar((ServiceConfig)config, (Map)null, (OutputStream)out);
        WebArchive archive = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)temp);
        for (Map.Entry entry : archive.getContent().entrySet()) {
            String extension = FilenameUtils.getExtension((String)((ArchivePath)entry.getKey()).get());
            String fileName = FilenameUtils.getName((String)((ArchivePath)entry.getKey()).get());
            if (!extension.equalsIgnoreCase("xml")) continue;
            this.validateGeneratedFiles("multi1", fileName, this.toString(((Node)entry.getValue()).getAsset().openStream()));
        }
    }

    @Test
    public void testMultiKBaseKSessionAndKAgents() throws IOException, URISyntaxException {
        this.setupLocalCache();
        ServiceConfig config = new ServiceConfig(){
            {
                ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
                kbase1.addModels((Collection)models);
                kbase1.addResources((Collection)resources);
                kbase1.setAssetsUser("admin");
                kbase1.setAssetsPassword("admin");
                kbase1.setAssertBehavior(AssertBehaviorOption.IDENTITY);
                ServiceKSessionConfig ksession1 = new ServiceKSessionConfig("ksession1");
                ksession1.setType(SessionType.STATEFUL);
                ksession1.setUrl("myksession1");
                ksession1.setKeepReference(true);
                ksession1.setClockType(ClockType.PSEUDO);
                ServiceKSessionConfig ksession2 = new ServiceKSessionConfig("ksession2");
                ksession2.setUrl("myksession2");
                ksession2.setKeepReference(false);
                ksession2.setMarshalling(MarshallingOption.JAXB);
                kbase1.addKsession(ksession1);
                kbase1.addKsession(ksession2);
                ServiceKAgentConfig kagent1 = new ServiceKAgentConfig("kagent1");
                kagent1.setNewInstance(false);
                kagent1.setUseKBaseClassloader(true);
                kagent1.addResource((AssetReference)resources.get(0));
                kagent1.addResource((AssetReference)resources.get(1));
                ServiceKAgentConfig kagent2 = new ServiceKAgentConfig("kagent2");
                kagent2.setNewInstance(false);
                kbase1.addKagent(kagent1);
                kbase1.addKagent(kagent2);
                this.addKBase(kbase1);
                ServiceKBaseConfig kbase2 = new ServiceKBaseConfig("kbase2");
                kbase2.addResource(new AssetReference("myPkg", "ax", "changeset", "http://localhost/cd/source", "uuidx9"));
                kbase2.setAssetsUser("admin");
                kbase2.setAssetsPassword("admin");
                kbase2.setMbeans(true);
                kbase2.setEventProcessingMode(EventProcessingOption.STREAM);
                ServiceKSessionConfig ksession3 = new ServiceKSessionConfig("ksession3");
                ksession3.setUrl("myksession3");
                ksession3.setProtocol(ProtocolOption.WEB_SERVICE);
                ksession3.setClockType(ClockType.REALTIME);
                ServiceKSessionConfig ksession4 = new ServiceKSessionConfig("ksession4");
                ksession4.setProtocol(ProtocolOption.WEB_SERVICE);
                ksession4.setMarshalling(MarshallingOption.JSON);
                kbase2.addKsession(ksession3);
                kbase2.addKsession(ksession4);
                ServiceKAgentConfig kagent3 = new ServiceKAgentConfig("kagent3");
                kagent3.setUseKBaseClassloader(true);
                ServiceKAgentConfig kagent4 = new ServiceKAgentConfig("kagent4");
                kagent4.setUseKBaseClassloader(true);
                kagent4.setNewInstance(true);
                ServiceKAgentConfig kagent5 = new ServiceKAgentConfig("kagent5");
                kagent5.addResource((AssetReference)resources.get(2));
                kbase2.addKagent(kagent3);
                kbase2.addKagent(kagent4);
                kbase2.addKagent(kagent5);
                this.addKBase(kbase2);
            }
        };
        File temp = File.createTempFile("drools-service", ".jar");
        temp.deleteOnExit();
        FileOutputStream out = new FileOutputStream(temp);
        ServiceWarGenerator.buildWar((ServiceConfig)config, (Map)null, (OutputStream)out);
        WebArchive archive = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)temp);
        for (Map.Entry entry : archive.getContent().entrySet()) {
            String extension = FilenameUtils.getExtension((String)((ArchivePath)entry.getKey()).get());
            String fileName = FilenameUtils.getName((String)((ArchivePath)entry.getKey()).get());
            if (!extension.equalsIgnoreCase("xml")) continue;
            this.validateGeneratedFiles("multi2", fileName, this.toString(((Node)entry.getValue()).getAsset().openStream()));
        }
    }

    private void setupLocalCache() {
        ArrayList<String> repositories = new ArrayList<String>(){
            {
                this.add(GuvnorArtifactCacheSupport.getURLtoLocalUserMavenRepo());
            }
        };
        ArrayList<MavenArtifact> dependencies = new ArrayList<MavenArtifact>(){
            {
                this.add(new MavenArtifact("log4j:log4j:jar:1.2.16:compile"));
                this.add(new MavenArtifact("jdom:jdom:jar:1.0:compile"));
            }
        };
        GuvnorArtifactCacheSupport.buildCache((Collection)repositories, (Collection)dependencies);
    }

    private void validateGeneratedFiles(String folder, String fileName, String generatedContent) {
        String origContent = MultipleKBasesKSessionsGeneratorTest.getResourceContent("org/drools/guvnor/server/generators/" + folder + "/" + fileName);
        Assert.assertEquals((String)("Following file content doesn't match - " + fileName), (Object)origContent, (Object)generatedContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    private static String getResourceContent(String fileName) {
        try {
            ByteArrayOutputStream outContent = new ByteArrayOutputStream();
            BufferedInputStream inContent = new BufferedInputStream(MultipleKBasesKSessionsGeneratorTest.class.getClassLoader().getResourceAsStream(fileName));
            IOUtils.copy((InputStream)inContent, (OutputStream)outContent);
            return outContent.toString();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error " + fileName, ex);
        }
    }
}

