/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.generators;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ProtocolOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKAgentConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKBaseConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKSessionConfig;
import org.drools.guvnor.client.rpc.MavenArtifact;
import org.drools.guvnor.server.generators.ServiceWarGenerator;
import org.drools.guvnor.server.maven.cache.GuvnorArtifactCacheSupport;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServiceWarGeneratorTest {
    private static final Collection<AssetReference> resources = new ArrayList<AssetReference>(){
        {
            this.add(new AssetReference("myPkg", "a", "drl", "http://localhost/c/source", "uuid1"));
            this.add(new AssetReference("myPkg", "aa", "drl", "http://localhost/cc/source", "uuid2"));
            this.add(new AssetReference("myPkg", "ab", "changeset", "http://localhost/cd/source", "uuid3"));
        }
    };
    private static final Collection<AssetReference> models = new ArrayList<AssetReference>(){
        {
            this.add(new AssetReference("myPkg", "a.jar", "model", "http://localhost/a.jar", "uudi44"));
        }
    };
    private static final ServiceConfig REST_SERVICE_CONFIG = new ServiceConfig(){
        {
            ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
            kbase1.addModels(models);
            kbase1.addResources(resources);
            ServiceKSessionConfig ksession1 = new ServiceKSessionConfig("ksession1");
            ServiceKAgentConfig kagent = new ServiceKAgentConfig("kagent1");
            kagent.setNewInstance(false);
            kbase1.addKsession(ksession1);
            kbase1.addKagent(kagent);
            this.addKBase(kbase1);
            this.setPollingFrequency(70);
        }
    };
    private static final ServiceConfig WS_SERVICE_CONFIG = new ServiceConfig(){
        {
            ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
            kbase1.addModels(models);
            kbase1.addResources(resources);
            ServiceKSessionConfig ksession1 = new ServiceKSessionConfig("ksession1");
            ksession1.setProtocol(ProtocolOption.WEB_SERVICE);
            ServiceKAgentConfig kagent = new ServiceKAgentConfig("kagent1");
            kagent.setNewInstance(false);
            kbase1.addKsession(ksession1);
            kbase1.addKagent(kagent);
            this.addKBase(kbase1);
            this.setPollingFrequency(70);
        }
    };
    private static final Set<String> LIBS = new HashSet<String>(){
        {
            this.add("log4j-1.2.16.jar");
            this.add("jdom-1.0.jar");
        }
    };
    private static final String MODEL_NAME = "org/drools/guvnor/server/jarWithSourceFiles.jar";

    @Before
    @After
    public void cleanUp() {
        GuvnorArtifactCacheSupport.cleanTempDir();
    }

    @Test(expected=NullPointerException.class)
    public void testNullPointer1() throws IOException {
        ServiceWarGenerator.buildWar(null, (Map)null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullPointer2() throws IOException {
        ServiceWarGenerator.buildWar((ServiceConfig)new ServiceConfig(REST_SERVICE_CONFIG), (Map)null, null);
    }

    @Test
    public void testNoModelUsingRest() throws IOException {
        this.setupLocalCache();
        File temp = File.createTempFile("drools-service", ".jar");
        temp.deleteOnExit();
        FileOutputStream out = new FileOutputStream(temp);
        ServiceWarGenerator.buildWar((ServiceConfig)new ServiceConfig(REST_SERVICE_CONFIG), (Map)null, (OutputStream)out);
        WebArchive archive = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)temp);
        LinkedList<String> fileNames = new LinkedList<String>();
        for (Map.Entry entry : archive.getContent().entrySet()) {
            String extension = FilenameUtils.getExtension((String)((ArchivePath)entry.getKey()).get());
            String fileName = FilenameUtils.getName((String)((ArchivePath)entry.getKey()).get());
            if (extension.equalsIgnoreCase("jar")) {
                fileNames.add(fileName);
                continue;
            }
            if (!extension.equalsIgnoreCase("xml")) continue;
            this.validateGeneratedFiles("rest-", fileName, this.toString(((Node)entry.getValue()).getAsset().openStream()));
        }
        Assert.assertEquals((long)2L, (long)fileNames.size());
        Assert.assertTrue((boolean)LIBS.containsAll(fileNames));
    }

    @Test
    public void testRest() throws IOException, URISyntaxException {
        this.setupLocalCache();
        File temp = File.createTempFile("drools-service", ".jar");
        temp.deleteOnExit();
        FileOutputStream out = new FileOutputStream(temp);
        HashMap<String, File> models = new HashMap<String, File>(){
            {
                this.put("jarWithSourceFiles.jar", new File(ServiceWarGeneratorTest.class.getClassLoader().getResource(ServiceWarGeneratorTest.MODEL_NAME).toURI()));
            }
        };
        ServiceWarGenerator.buildWar((ServiceConfig)new ServiceConfig(REST_SERVICE_CONFIG), (Map)models, (OutputStream)out);
        WebArchive archive = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)temp);
        LinkedList<String> fileNames = new LinkedList<String>();
        for (Map.Entry entry : archive.getContent().entrySet()) {
            String extension = FilenameUtils.getExtension((String)((ArchivePath)entry.getKey()).get());
            String fileName = FilenameUtils.getName((String)((ArchivePath)entry.getKey()).get());
            if (extension.equalsIgnoreCase("jar")) {
                fileNames.add(fileName);
                continue;
            }
            if (!extension.equalsIgnoreCase("xml")) continue;
            this.validateGeneratedFiles("rest-", fileName, this.toString(((Node)entry.getValue()).getAsset().openStream()));
        }
        Assert.assertEquals((long)3L, (long)fileNames.size());
        Assert.assertTrue((boolean)fileNames.containsAll(LIBS));
        Assert.assertTrue((boolean)fileNames.contains("jarWithSourceFiles.jar"));
    }

    @Test
    public void testNoModelUsingWs() throws IOException {
        this.setupLocalCache();
        File temp = File.createTempFile("drools-service", ".jar");
        temp.deleteOnExit();
        FileOutputStream out = new FileOutputStream(temp);
        ServiceWarGenerator.buildWar((ServiceConfig)new ServiceConfig(WS_SERVICE_CONFIG), (Map)null, (OutputStream)out);
        WebArchive archive = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)temp);
        LinkedList<String> fileNames = new LinkedList<String>();
        for (Map.Entry entry : archive.getContent().entrySet()) {
            String extension = FilenameUtils.getExtension((String)((ArchivePath)entry.getKey()).get());
            String fileName = FilenameUtils.getName((String)((ArchivePath)entry.getKey()).get());
            if (extension.equalsIgnoreCase("jar")) {
                fileNames.add(fileName);
                continue;
            }
            if (!extension.equalsIgnoreCase("xml")) continue;
            this.validateGeneratedFiles("ws-", fileName, this.toString(((Node)entry.getValue()).getAsset().openStream()));
        }
        Assert.assertEquals((long)2L, (long)fileNames.size());
        Assert.assertTrue((boolean)LIBS.containsAll(fileNames));
    }

    @Test
    public void testWs() throws IOException, URISyntaxException {
        this.setupLocalCache();
        File temp = File.createTempFile("drools-service", ".jar");
        temp.deleteOnExit();
        FileOutputStream out = new FileOutputStream(temp);
        HashMap<String, File> models = new HashMap<String, File>(){
            {
                this.put("jarWithSourceFiles.jar", new File(ServiceWarGeneratorTest.class.getClassLoader().getResource(ServiceWarGeneratorTest.MODEL_NAME).toURI()));
            }
        };
        ServiceWarGenerator.buildWar((ServiceConfig)new ServiceConfig(WS_SERVICE_CONFIG), (Map)models, (OutputStream)out);
        WebArchive archive = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)temp);
        LinkedList<String> fileNames = new LinkedList<String>();
        for (Map.Entry entry : archive.getContent().entrySet()) {
            String extension = FilenameUtils.getExtension((String)((ArchivePath)entry.getKey()).get());
            String fileName = FilenameUtils.getName((String)((ArchivePath)entry.getKey()).get());
            if (extension.equalsIgnoreCase("jar")) {
                fileNames.add(fileName);
                continue;
            }
            if (!extension.equalsIgnoreCase("xml")) continue;
            this.validateGeneratedFiles("ws-", fileName, this.toString(((Node)entry.getValue()).getAsset().openStream()));
        }
        Assert.assertEquals((long)3L, (long)fileNames.size());
        Assert.assertTrue((boolean)fileNames.containsAll(LIBS));
        Assert.assertTrue((boolean)fileNames.contains("jarWithSourceFiles.jar"));
    }

    private void setupLocalCache() {
        ArrayList<String> repositories = new ArrayList<String>(){
            {
                this.add(GuvnorArtifactCacheSupport.getURLtoLocalUserMavenRepo());
            }
        };
        ArrayList<MavenArtifact> dependencies = new ArrayList<MavenArtifact>(){
            {
                this.add(new MavenArtifact("log4j:log4j:jar:1.2.16:compile"));
                this.add(new MavenArtifact("jdom:jdom:jar:1.0:compile"));
            }
        };
        GuvnorArtifactCacheSupport.buildCache((Collection)repositories, (Collection)dependencies);
    }

    private void validateGeneratedFiles(String protocol, String fileName, String generatedContent) {
        String origContent = ServiceWarGeneratorTest.getResourceContent("org/drools/guvnor/server/generators/" + protocol + fileName);
        Assert.assertEquals((String)("Following file content doesn't match - " + fileName), (Object)origContent, (Object)generatedContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    private static String getResourceContent(String fileName) {
        try {
            ByteArrayOutputStream outContent = new ByteArrayOutputStream();
            BufferedInputStream inContent = new BufferedInputStream(ServiceWarGeneratorTest.class.getClassLoader().getResourceAsStream(fileName));
            IOUtils.copy((InputStream)inContent, (OutputStream)outContent);
            return outContent.toString();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error " + fileName, ex);
        }
    }
}

