/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Specializes;
import javax.jcr.Repository;
import org.apache.commons.io.FileUtils;
import org.drools.guvnor.server.repository.ProductionRepositoryStartupService;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleBasedPermissionStore;
import org.drools.guvnor.server.security.RoleType;
import org.drools.repository.RulesRepository;

@Specializes
public class TestRepositoryStartupService
extends ProductionRepositoryStartupService {
    public Repository getRepositoryInstance() {
        File repositoryDir;
        File targetDir = new File("target/");
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        if ((repositoryDir = new File(targetDir, "repository/")).exists()) {
            try {
                FileUtils.deleteDirectory((File)repositoryDir);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed at deleting test repositoryDir (" + repositoryDir + ").", e);
            }
            this.log.info("Deleted test repositoryDir (" + repositoryDir + ").");
        }
        this.guvnorBootstrapConfiguration.getProperties().put("repository.root.directory", repositoryDir.getAbsolutePath());
        return super.getRepositoryInstance();
    }

    @PostConstruct
    private void insertTestData() {
        RulesRepository rulesRepository = new RulesRepository(this.sessionForSetup);
        RoleBasedPermissionStore adminStore = new RoleBasedPermissionStore(rulesRepository);
        adminStore.addRoleBasedPermissionForTesting("admin", new RoleBasedPermission("admin", RoleType.ADMIN.getName(), null, null));
    }
}

