/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import java.util.List;
import org.drools.guvnor.server.repository.UserInbox;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.UserInfo;
import org.junit.Assert;
import org.junit.Test;

public class UserInboxIntegrationTest
extends GuvnorIntegrationTest {
    @Test
    public void testInboxen() throws Exception {
        RulesRepository repo = this.rulesRepository;
        UserInbox inb = new UserInbox(repo);
        inb.clearAll();
        inb.addToRecentEdited("ABC", "This is a note");
        Thread.sleep(100L);
        inb.addToRecentEdited("QED", "Here we go...");
        repo.save();
        List entries = inb.loadRecentEdited();
        Assert.assertEquals((long)2L, (long)entries.size());
        UserInfo.InboxEntry e1 = (UserInfo.InboxEntry)entries.get(0);
        Assert.assertEquals((Object)"ABC", (Object)e1.assetUUID);
        Assert.assertEquals((Object)"This is a note", (Object)e1.note);
        UserInfo.InboxEntry e2 = (UserInfo.InboxEntry)entries.get(1);
        Assert.assertEquals((Object)"QED", (Object)e2.assetUUID);
        Assert.assertTrue((e2.timestamp > e1.timestamp ? 1 : 0) != 0);
        inb.clearAll();
        for (int i = 0; i < 200; ++i) {
            inb.addToRecentEdited("X" + i, "NOTE" + i);
        }
        Assert.assertEquals((Object)"X0", (Object)((UserInfo.InboxEntry)inb.loadRecentEdited().get((int)0)).assetUUID);
        inb.addToRecentEdited("Y1", "NOTE");
        List res = inb.loadRecentEdited();
        Assert.assertEquals((Object)"X1", (Object)((UserInfo.InboxEntry)inb.loadRecentEdited().get((int)0)).assetUUID);
        Assert.assertEquals((Object)"Y1", (Object)((UserInfo.InboxEntry)res.get((int)(res.size() - 1))).assetUUID);
        Assert.assertTrue((boolean)((UserInfo.InboxEntry)res.get((int)(res.size() - 2))).assetUUID.startsWith("X"));
        inb.addToRecentEdited("Y2", "NOTE");
        res = inb.loadRecentEdited();
        Assert.assertEquals((Object)"X2", (Object)((UserInfo.InboxEntry)inb.loadRecentEdited().get((int)0)).assetUUID);
        Assert.assertEquals((Object)"Y2", (Object)((UserInfo.InboxEntry)res.get((int)(res.size() - 1))).assetUUID);
        Assert.assertEquals((Object)"Y1", (Object)((UserInfo.InboxEntry)res.get((int)(res.size() - 2))).assetUUID);
    }

    @Test
    public void testLoadEntriesRecentlyOpened() {
        RulesRepository repo = this.rulesRepository;
        UserInbox inb = new UserInbox(repo);
        inb.clearAll();
        inb.addToRecentOpened("QED", "hey");
        List es = inb.loadEntries("recentViewed");
        Assert.assertEquals((long)1L, (long)es.size());
        Assert.assertEquals((Object)"QED", (Object)((UserInfo.InboxEntry)es.get((int)0)).assetUUID);
    }

    @Test
    public void testLoadEntriesRecentlyEdited() throws Exception {
        RulesRepository repo = this.rulesRepository;
        UserInbox inb = new UserInbox(repo);
        inb.clearAll();
        inb.addToRecentEdited("ABC", "This is a note");
        List es = inb.loadEntries("recentEdited");
        Assert.assertEquals((long)1L, (long)es.size());
        Assert.assertEquals((Object)"ABC", (Object)((UserInfo.InboxEntry)es.get((int)0)).assetUUID);
    }

    @Test
    public void testLoadEntriesIncoming() throws Exception {
        RulesRepository repo = this.rulesRepository;
        AssetItem asset = repo.loadDefaultModule().addAsset("testLoadEntriesIncoming", "");
        UserInbox ib = new UserInbox(repo);
        ib.clearAll();
        ib.addToIncoming(asset.getUUID(), "hey", "mic");
        List es = ib.loadIncoming();
        Assert.assertEquals((long)1L, (long)es.size());
        Assert.assertEquals((Object)asset.getUUID(), (Object)((UserInfo.InboxEntry)es.get((int)0)).assetUUID);
    }

    @Test
    public void testRead() throws Exception {
        RulesRepository repo = this.rulesRepository;
        UserInbox inb = new UserInbox(repo);
        inb.clearAll();
        inb.addToRecentOpened("QED", "hey");
        inb.addToRecentEdited("ABC", "This is a note");
        List es = inb.loadRecentOpened();
        Assert.assertEquals((long)1L, (long)es.size());
        Assert.assertEquals((Object)"QED", (Object)((UserInfo.InboxEntry)es.get((int)0)).assetUUID);
    }

    @Test
    public void testDupes() throws Exception {
        RulesRepository repo = this.rulesRepository;
        UserInbox inb = new UserInbox(repo);
        inb.clearAll();
        for (int i = 0; i < 120; ++i) {
            inb.addToRecentOpened("A" + i, "NOTE");
        }
        List res = inb.loadRecentOpened();
        Assert.assertEquals((long)120L, (long)res.size());
        inb.addToRecentOpened("XX", "hey");
        Assert.assertEquals((long)(res.size() + 1), (long)inb.loadRecentOpened().size());
        UserInfo.InboxEntry firstOld = (UserInfo.InboxEntry)inb.loadRecentOpened().get(0);
        Assert.assertEquals((Object)"A0", (Object)firstOld.assetUUID);
        Thread.sleep(30L);
        inb.addToRecentOpened("A0", "hey22");
        List finalList = inb.loadRecentOpened();
        Assert.assertEquals((long)(res.size() + 1), (long)finalList.size());
        Assert.assertEquals((Object)"A1", (Object)((UserInfo.InboxEntry)finalList.get((int)0)).assetUUID);
        UserInfo.InboxEntry lastEntry = (UserInfo.InboxEntry)finalList.get(finalList.size() - 1);
        Assert.assertEquals((Object)"A0", (Object)lastEntry.assetUUID);
        Assert.assertTrue((lastEntry.timestamp > firstOld.timestamp ? 1 : 0) != 0);
    }

    @Test
    public void testHelper() throws Exception {
        RulesRepository repo = this.rulesRepository;
        UserInbox ib = new UserInbox(repo);
        ib.clearAll();
        AssetItem asset = repo.loadDefaultModule().addAsset("InBoxTestHelper", "hey");
        UserInbox.recordOpeningEvent((AssetItem)asset);
        List es = ib.loadRecentOpened();
        Assert.assertEquals((long)1L, (long)es.size());
        Assert.assertEquals((Object)asset.getUUID(), (Object)((UserInfo.InboxEntry)es.get((int)0)).assetUUID);
        Assert.assertEquals((Object)"InBoxTestHelper", (Object)((UserInfo.InboxEntry)es.get((int)0)).note);
        UserInbox.recordUserEditEvent((AssetItem)asset);
        es = ib.loadRecentEdited();
        Assert.assertEquals((long)1L, (long)es.size());
        Assert.assertEquals((Object)asset.getUUID(), (Object)((UserInfo.InboxEntry)es.get((int)0)).assetUUID);
    }

    @Test
    public void testIncoming() throws Exception {
        RulesRepository repo = this.rulesRepository;
        AssetItem asset = repo.loadDefaultModule().addAsset("testIncoming", "");
        UserInbox ib = new UserInbox(repo);
        ib.clearAll();
        ib.addToIncoming(asset.getUUID(), "hey", "mic");
        ib.addToIncoming("YYY", "hey2", "mic");
        List es = ib.loadIncoming();
        Assert.assertEquals((long)2L, (long)es.size());
        Assert.assertEquals((Object)asset.getUUID(), (Object)((UserInfo.InboxEntry)es.get((int)0)).assetUUID);
        Assert.assertEquals((Object)"YYY", (Object)((UserInfo.InboxEntry)es.get((int)1)).assetUUID);
        UserInbox.recordOpeningEvent((AssetItem)asset);
        es = ib.loadIncoming();
        Assert.assertEquals((long)1L, (long)es.size());
        Assert.assertEquals((Object)"YYY", (Object)((UserInfo.InboxEntry)es.get((int)0)).assetUUID);
    }
}

