/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleBasedPermissionStore;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.junit.Assert;
import org.junit.Test;

public class RoleBasedPermissionStoreIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private RoleBasedPermissionStore roleBasedPermissionStore;

    @Test
    public void testGetRoleBasedPermissionsByUserName() throws Exception {
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting("jervis", new RoleBasedPermission("jervis", RoleType.PACKAGE_ADMIN.getName(), "package1Name", null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting("jervis", new RoleBasedPermission("jervis", RoleType.PACKAGE_READONLY.getName(), "package2Name", null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting("jervis", new RoleBasedPermission("jervis", RoleType.PACKAGE_READONLY.getName(), "package3Name", null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting("jervis", new RoleBasedPermission("jervis", RoleType.ANALYST.getName(), null, "category1"));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting("john", new RoleBasedPermission("john", RoleType.ANALYST.getName(), null, "category2"));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting("johnson", new RoleBasedPermission("johnson", RoleType.ADMIN.getName(), null, null));
        List perms = this.roleBasedPermissionStore.getRoleBasedPermissionsByUserName("jervis");
        Assert.assertTrue((perms.size() == 4 ? 1 : 0) != 0);
        ArrayList<RoleBasedPermission> expectedPerms = new ArrayList<RoleBasedPermission>();
        expectedPerms.add(new RoleBasedPermission("jervis", RoleType.PACKAGE_ADMIN.getName(), "package1Name", null));
        expectedPerms.add(new RoleBasedPermission("jervis", RoleType.PACKAGE_READONLY.getName(), "package2Name", null));
        expectedPerms.add(new RoleBasedPermission("jervis", RoleType.PACKAGE_READONLY.getName(), "package3Name", null));
        expectedPerms.add(new RoleBasedPermission("jervis", RoleType.ANALYST.getName(), null, "category1"));
        block0: for (RoleBasedPermission perm : perms) {
            for (RoleBasedPermission expectedPerm : expectedPerms) {
                if (perm.getPackageName() != null && perm.getPackageName().equals(expectedPerm.getPackageName()) && perm.getRole().equals(expectedPerm.getRole())) {
                    expectedPerms.remove(expectedPerm);
                    continue block0;
                }
                if (perm.getCategoryPath() == null || !perm.getCategoryPath().equals(expectedPerm.getCategoryPath()) || !perm.getRole().equals(expectedPerm.getRole())) continue;
                expectedPerms.remove(expectedPerm);
                continue block0;
            }
        }
        Assert.assertTrue((expectedPerms.size() == 0 ? 1 : 0) != 0);
        perms = this.roleBasedPermissionStore.getRoleBasedPermissionsByUserName("john");
        Assert.assertTrue((perms.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((RoleBasedPermission)perms.get(0)).getRole().equals(RoleType.ANALYST.getName()));
        Assert.assertTrue((boolean)((RoleBasedPermission)perms.get(0)).getUserName().equals("john"));
        perms = this.roleBasedPermissionStore.getRoleBasedPermissionsByUserName("johnson");
        Assert.assertTrue((perms.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((RoleBasedPermission)perms.get(0)).getRole().equals(RoleType.ADMIN.getName()));
        Assert.assertTrue((boolean)((RoleBasedPermission)perms.get(0)).getUserName().equals("johnson"));
    }
}

