/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.selector;

import org.drools.guvnor.server.selector.BuiltInSelector;
import org.drools.guvnor.server.selector.SelectorManager;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.junit.Assert;
import org.junit.Test;

public class BuiltInSelectorIntegrationTest
extends GuvnorIntegrationTest {
    @Test
    public void testBuiltInSelector() throws Exception {
        this.rulesRepository.loadDefaultModule();
        this.rulesRepository.createModule("testBuiltInSelectorPackage", "woot");
        this.rulesRepository.createState("Dev");
        this.rulesRepository.createState("QA");
        CategoryItem cat = this.rulesRepository.loadCategory("/");
        cat.addCategory("testBuiltInSelectorCat1", "yeah");
        cat.addCategory("testBuiltInSelectorCat2", "yeah");
        String uuid1 = this.serviceImplementation.createNewRule("test AddRule1", "a description", "testBuiltInSelectorCat1", "testBuiltInSelectorPackage", "txt");
        AssetItem item1 = this.rulesRepository.loadAssetByUUID(uuid1);
        item1.updateState("Dev");
        String uuid2 = this.serviceImplementation.createNewRule("test AddRule2", "a description", "testBuiltInSelectorCat1", "testBuiltInSelectorPackage", "txt");
        AssetItem item2 = this.rulesRepository.loadAssetByUUID(uuid2);
        item2.updateState("QA");
        String uuid3 = this.serviceImplementation.createNewRule("test AddRule3", "a description", "testBuiltInSelectorCat2", "testBuiltInSelectorPackage", "txt");
        AssetItem item3 = this.rulesRepository.loadAssetByUUID(uuid3);
        item3.updateState("Dev");
        String uuid4 = this.serviceImplementation.createNewRule("test AddRule4", "a description", "testBuiltInSelectorCat2", "testBuiltInSelectorPackage", "txt");
        AssetItem item4 = this.rulesRepository.loadAssetByUUID(uuid4);
        item4.updateState("QA");
        BuiltInSelector selector1 = (BuiltInSelector)SelectorManager.getInstance().getSelector("BuiltInSelector");
        selector1.setCategory("testBuiltInSelectorCat1");
        selector1.setCategoryOperator("=");
        selector1.setEnableCategorySelector(true);
        selector1.setStatus("Dev");
        selector1.setStatusOperator("=");
        selector1.setEnableStatusSelector(false);
        Assert.assertTrue((boolean)selector1.isAssetAllowed(item1));
        Assert.assertTrue((boolean)selector1.isAssetAllowed(item2));
        Assert.assertFalse((boolean)selector1.isAssetAllowed(item3));
        Assert.assertFalse((boolean)selector1.isAssetAllowed(item4));
        BuiltInSelector selector2 = (BuiltInSelector)SelectorManager.getInstance().getSelector("BuiltInSelector");
        selector2.setCategory("testBuiltInSelectorCat1");
        selector2.setCategoryOperator("!=");
        selector2.setEnableCategorySelector(true);
        selector2.setStatus("Dev");
        selector2.setStatusOperator("=");
        selector2.setEnableStatusSelector(false);
        Assert.assertFalse((boolean)selector2.isAssetAllowed(item1));
        Assert.assertFalse((boolean)selector2.isAssetAllowed(item2));
        Assert.assertTrue((boolean)selector2.isAssetAllowed(item3));
        Assert.assertTrue((boolean)selector2.isAssetAllowed(item4));
        BuiltInSelector selector3 = (BuiltInSelector)SelectorManager.getInstance().getSelector("BuiltInSelector");
        selector3.setCategory("testBuiltInSelectorCat1");
        selector3.setCategoryOperator("!=");
        selector3.setEnableCategorySelector(false);
        selector3.setStatus("Dev");
        selector3.setStatusOperator("=");
        selector3.setEnableStatusSelector(true);
        Assert.assertTrue((boolean)selector3.isAssetAllowed(item1));
        Assert.assertFalse((boolean)selector3.isAssetAllowed(item2));
        Assert.assertTrue((boolean)selector3.isAssetAllowed(item3));
        Assert.assertFalse((boolean)selector3.isAssetAllowed(item4));
        BuiltInSelector selector4 = (BuiltInSelector)SelectorManager.getInstance().getSelector("BuiltInSelector");
        selector4.setCategory("testBuiltInSelectorCat1");
        selector4.setCategoryOperator("!=");
        selector4.setEnableCategorySelector(false);
        selector4.setStatus("Dev");
        selector4.setStatusOperator("!=");
        selector4.setEnableStatusSelector(true);
        Assert.assertFalse((boolean)selector4.isAssetAllowed(item1));
        Assert.assertTrue((boolean)selector4.isAssetAllowed(item2));
        Assert.assertFalse((boolean)selector4.isAssetAllowed(item3));
        Assert.assertTrue((boolean)selector4.isAssetAllowed(item4));
        BuiltInSelector selector5 = (BuiltInSelector)SelectorManager.getInstance().getSelector("BuiltInSelector");
        selector5.setCategory("testBuiltInSelectorCat1");
        selector5.setCategoryOperator("=");
        selector5.setEnableCategorySelector(true);
        selector5.setStatus("Dev");
        selector5.setStatusOperator("=");
        selector5.setEnableStatusSelector(true);
        Assert.assertTrue((boolean)selector5.isAssetAllowed(item1));
        Assert.assertFalse((boolean)selector5.isAssetAllowed(item2));
        Assert.assertFalse((boolean)selector5.isAssetAllowed(item3));
        Assert.assertFalse((boolean)selector5.isAssetAllowed(item4));
        BuiltInSelector selector6 = (BuiltInSelector)SelectorManager.getInstance().getSelector("BuiltInSelector");
        selector6.setCategory("testBuiltInSelectorCat1");
        selector6.setCategoryOperator("!=");
        selector6.setEnableCategorySelector(true);
        selector6.setStatus("Dev");
        selector6.setStatusOperator("=");
        selector6.setEnableStatusSelector(true);
        Assert.assertFalse((boolean)selector6.isAssetAllowed(item1));
        Assert.assertFalse((boolean)selector6.isAssetAllowed(item2));
        Assert.assertTrue((boolean)selector6.isAssetAllowed(item3));
        Assert.assertFalse((boolean)selector6.isAssetAllowed(item4));
        BuiltInSelector selector7 = (BuiltInSelector)SelectorManager.getInstance().getSelector("BuiltInSelector");
        selector7.setCategory("testBuiltInSelectorCat1");
        selector7.setCategoryOperator("!=");
        selector7.setEnableCategorySelector(false);
        selector7.setStatus("Dev");
        selector7.setStatusOperator("=");
        selector7.setEnableStatusSelector(false);
        Assert.assertTrue((boolean)selector6.isAssetAllowed(item1));
        Assert.assertTrue((boolean)selector6.isAssetAllowed(item2));
        Assert.assertTrue((boolean)selector6.isAssetAllowed(item3));
        Assert.assertTrue((boolean)selector6.isAssetAllowed(item4));
    }

    @Test
    public void testBuiltInSelectorWithAssetCategory() throws Exception {
        this.rulesRepository.loadDefaultModule();
        this.rulesRepository.createModule("testBuiltInSelectorWithAssetCategoryPackage", "woot");
        CategoryItem cat = this.rulesRepository.loadCategory("/");
        CategoryItem cat1 = cat.addCategory("testBuiltInSelectorWithAssetCategoryCat1", "yeah");
        CategoryItem cat2 = cat.addCategory("testBuiltInSelectorWithAssetCategoryCat2", "yeah");
        CategoryItem cat3 = cat2.addCategory("testBuiltInSelectorWithAssetCategoryCat3", "yeah");
        String uuid1 = this.serviceImplementation.createNewRule("test AddRule1", "a description", "testBuiltInSelectorWithAssetCategoryCat1", "testBuiltInSelectorWithAssetCategoryPackage", "txt");
        AssetItem item1 = this.rulesRepository.loadAssetByUUID(uuid1);
        item1.addCategory("testBuiltInSelectorWithAssetCategoryCat2/testBuiltInSelectorWithAssetCategoryCat3");
        String uuid2 = this.serviceImplementation.createNewRule("test AddRule2", "a description", null, "testBuiltInSelectorWithAssetCategoryPackage", "txt");
        AssetItem item2 = this.rulesRepository.loadAssetByUUID(uuid2);
        BuiltInSelector selector1 = (BuiltInSelector)SelectorManager.getInstance().getSelector("BuiltInSelector");
        selector1.setCategory("testBuiltInSelectorWithAssetCategoryCat2/testBuiltInSelectorWithAssetCategoryCat3");
        selector1.setCategoryOperator("!=");
        selector1.setEnableCategorySelector(true);
        Assert.assertFalse((boolean)selector1.isAssetAllowed(item1));
        Assert.assertTrue((boolean)selector1.isAssetAllowed(item2));
    }
}

