/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.TreeMap;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.xpath.DefaultXPath;
import org.drools.guvnor.server.DroolsServiceImplementation;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.RepositoryCategoryService;
import org.drools.guvnor.server.RepositoryModuleService;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.repository.TestRepositoryStartupService;
import org.drools.repository.RulesRepository;
import org.drools.repository.utils.IOUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.Identity;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.DependencyResolvers;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.api.maven.MavenImporter;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.picketlink.idm.api.Credential;
import org.picketlink.idm.impl.api.PasswordCredential;

@RunWith(value=Arquillian.class)
public abstract class GuvnorIntegrationTest {
    public static final String ADMIN_USERNAME = "admin";
    @Inject
    protected RulesRepository rulesRepository;
    @Inject
    protected ServiceImplementation serviceImplementation;
    @Inject
    protected RepositoryAssetService repositoryAssetService;
    @Inject
    protected RepositoryModuleService repositoryPackageService;
    @Inject
    protected RepositoryCategoryService repositoryCategoryService;
    @Inject
    protected Identity identity;
    @Inject
    protected Credentials credentials;
    @Inject
    protected DroolsServiceImplementation droolsServiceImplementation;
    protected boolean autoLoginAsAdmin = true;

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive webArchive = (WebArchive)((MavenImporter)ShrinkWrap.create(MavenImporter.class)).loadEffectivePom("pom.xml", new String[0]).importBuildOutput().importTestBuildOutput().as(WebArchive.class);
        GuvnorIntegrationTest.addTestDependencies(webArchive);
        File explodedWarFile = new File("target/guvnor-webapp-drools-5.5.0.Beta1");
        if (!explodedWarFile.exists()) {
            throw new IllegalStateException("The exploded war file (" + explodedWarFile + ") should exist, run \"mvn package\" first.");
        }
        GuvnorIntegrationTest.filterWebXml(webArchive, explodedWarFile);
        GuvnorIntegrationTest.removeExcludedFiles(webArchive, explodedWarFile);
        return webArchive;
    }

    private static void filterWebXml(WebArchive webArchive, File explodedWarFile) {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(new File(explodedWarFile.getPath() + "/WEB-INF/web.xml"));
            DefaultXPath xpath = new DefaultXPath("//j:context-param[j:param-name/text()=\"resteasy.injector.factory\"]");
            TreeMap<String, String> namespaces = new TreeMap<String, String>();
            namespaces.put("j", "http://java.sun.com/xml/ns/javaee");
            xpath.setNamespaceURIs(namespaces);
            Node node = xpath.selectSingleNode((Object)document);
            node.detach();
            File filteredWebXml = new File("target/test/filtered/jboss-as-7_0/WEB-INF/web.xml");
            filteredWebXml.getParentFile().mkdirs();
            FileWriter writer = null;
            try {
                writer = new FileWriter(filteredWebXml);
                document.write((Writer)writer);
            }
            catch (IOException e) {
                try {
                    throw new IllegalStateException("filterWebXml failed", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
            webArchive.delete(ArchivePaths.create((String)"WEB-INF/web.xml"));
            webArchive.addAsWebInfResource(filteredWebXml, ArchivePaths.create((String)"web.xml"));
        }
        catch (DocumentException e) {
            throw new IllegalStateException("filterWebXml failed", e);
        }
    }

    private static void dumpArchive(WebArchive webArchive) {
        File shrinkwrapParentDir = new File("target/shrinkwrap");
        FileUtils.deleteQuietly((File)shrinkwrapParentDir);
        shrinkwrapParentDir.mkdirs();
        ((ExplodedExporter)webArchive.as(ExplodedExporter.class)).exportExploded(shrinkwrapParentDir);
    }

    private static void addTestDependencies(WebArchive webArchive) {
        ((WebArchive)((WebArchive)webArchive.addClasses(new Class[]{TestRepositoryStartupService.class})).addAsLibraries(((MavenDependencyResolver)((MavenDependencyResolver)((MavenDependencyResolver)DependencyResolvers.use(MavenDependencyResolver.class)).artifact("org.apache.abdera:abdera-core:1.1.1")).artifact("org.apache.abdera:abdera-client:1.1.1")).resolveAsFiles())).addAsLibrary(new File("target/test-classes/billasurf.jar"));
    }

    private static void removeExcludedFiles(WebArchive webArchive, File explodedWarFile) {
        webArchive.delete(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil"));
        File libDir = new File(explodedWarFile, "WEB-INF/lib");
        for (File file : libDir.listFiles()) {
            String fileName = file.getName();
            if (!fileName.endsWith(".jar") || !fileName.startsWith("weld-") && !fileName.startsWith("resteasy-")) continue;
            webArchive.delete(ArchivePaths.create((String)("WEB-INF/lib/" + fileName)));
        }
    }

    @BeforeClass
    public static void setUpGuvnorTestBase() {
        System.setProperty("drools.serialization.sign", "false");
    }

    @Before
    public void autoLoginAsAdmin() {
        if (this.autoLoginAsAdmin) {
            this.loginAs(ADMIN_USERNAME);
        }
    }

    @After
    public void autoLogoutAsAdmin() {
        if (this.autoLoginAsAdmin) {
            this.logoutAs(ADMIN_USERNAME);
        }
    }

    protected void loginAs(String username) {
        this.credentials.setUsername(username);
        this.credentials.setCredential((Credential)new PasswordCredential(username));
        this.identity.login();
    }

    protected void logoutAs(String username) {
        this.identity.logout();
        this.credentials.clear();
    }
}

