/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.verification;

import java.util.Collections;
import java.util.HashMap;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.widgets.toolbar.DefaultActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.server.MockAssetItemIterator;
import org.drools.guvnor.server.verification.AssetVerifier;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;
import org.drools.verifier.Verifier;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AssetVerifierTest {
    private ModuleItem packageItem;

    @Before
    public void setUp() {
        this.packageItem = this.createPackage();
        this.setUpAssetItemIterator();
    }

    private Verifier createVerifier() {
        Verifier verifier = (Verifier)Mockito.mock(Verifier.class);
        VerifierReport verifierReport = this.createVerifierReport();
        Mockito.when((Object)verifier.getResult()).thenReturn((Object)verifierReport);
        return verifier;
    }

    private VerifierReport createVerifierReport() {
        VerifierReport report = (VerifierReport)Mockito.mock(VerifierReport.class);
        Mockito.when((Object)report.getBySeverity((Severity)Matchers.any())).thenReturn(Collections.emptyList());
        VerifierData verifierData = (VerifierData)Mockito.mock(VerifierData.class);
        Mockito.when((Object)report.getVerifierData()).thenReturn((Object)verifierData);
        return report;
    }

    private void setUpAssetItemIterator() {
        AssetItemIterator assetItemIterator = (AssetItemIterator)Mockito.mock(AssetItemIterator.class);
        Mockito.when((Object)assetItemIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.packageItem.listAssetsByFormat(new String[]{(String)Matchers.anyVararg()})).thenReturn((Object)assetItemIterator);
    }

    @Test
    public void testVerifySingleAsset() throws Exception {
        for (String format : DefaultActionToolbarButtonsConfigurationProvider.VERIFY_FORMATS) {
            if (format.equals("xls")) continue;
            AssetItem originalAssetItem = this.getAssetItem(format);
            this.setUpAssetIterator(originalAssetItem, format);
            AssetItem assetItemUnderVerification = this.getAssetItem(format);
            AssetVerifier verifierRunner = new AssetVerifier(this.createVerifier(), assetItemUnderVerification);
            AnalysisReport report = verifierRunner.verify();
            ((AssetItem)Mockito.verify((Object)originalAssetItem, (VerificationMode)Mockito.never())).getContent();
            ((AssetItem)Mockito.verify((Object)assetItemUnderVerification)).getContent();
            Assert.assertNotNull((Object)report);
        }
    }

    private void setUpAssetIterator(AssetItem originalAssetItem, String format) {
        MockAssetItemIterator itemIterator = new MockAssetItemIterator();
        itemIterator.setAssets(originalAssetItem);
        Mockito.when((Object)this.packageItem.listAssetsByFormat(new String[]{format})).thenReturn((Object)itemIterator);
    }

    private AssetItem getAssetItem(String format) {
        AssetItem assetItem = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)assetItem.getUUID()).thenReturn((Object)"mockUUID");
        Mockito.when((Object)assetItem.getModule()).thenReturn((Object)this.packageItem);
        Mockito.when((Object)assetItem.getFormat()).thenReturn((Object)format);
        Mockito.when((Object)assetItem.getContent()).thenReturn((Object)"");
        return assetItem;
    }

    public ModuleItem createPackage() {
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)packageItem.getName()).thenReturn((Object)"mockPackage");
        Mockito.when((Object)packageItem.getCategoryRules()).thenReturn(new HashMap());
        return packageItem;
    }
}

