/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.event.logical.shared.SelectionEvent;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.Fact;
import org.drools.ide.common.client.modeldriven.testing.FieldPlaceHolder;

public class AddFieldToFactClickHandler
        extends AddFieldClickHandler {


    private final Fact fact;

    public AddFieldToFactClickHandler(Fact fact,
                                      SuggestionCompletionEngine suggestionCompletionEngine,
                                      ScenarioParentWidget parent) {
        super(suggestionCompletionEngine, parent);
        this.fact = fact;
    }

    @Override
    public void onSelection(SelectionEvent<String> stringSelectionEvent) {
        fact.getFieldData().add(new FieldPlaceHolder(stringSelectionEvent.getSelectedItem()));
        parent.renderEditor();
    }

    protected FactFieldSelector createFactFieldSelector() {
        FactFieldSelector factFieldSelector = new FactFieldSelector();
        for (String fieldName : suggestionCompletionEngine.getModelFields(fact.getType())) {
            if (!fact.isFieldNameInUse(fieldName)) {
                factFieldSelector.addField(fieldName);
            }
        }
        return factFieldSelector;
    }
}
