/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKAgentConfig;
import org.junit.Assert;
import org.junit.Test;

public class ServiceKAgentConfigTest {
    @Test
    public void testGeneralState() {
        ServiceKAgentConfig kagent = new ServiceKAgentConfig("kagent1", null, null, null);
        Assert.assertNotNull((Object)kagent);
        Assert.assertEquals((Object)"kagent1", (Object)kagent.getName());
        Assert.assertNull((Object)kagent.getNewInstance());
        Assert.assertNull((Object)kagent.getUseKBaseClassloader());
        Assert.assertNotNull((Object)kagent.getResources());
        Assert.assertEquals((long)0L, (long)kagent.getResources().size());
        Assert.assertEquals((Object)kagent, (Object)new ServiceKAgentConfig(kagent.getName()));
        Assert.assertEquals((long)kagent.hashCode(), (long)new ServiceKAgentConfig(kagent.getName()).hashCode());
        Assert.assertEquals((Object)kagent, (Object)kagent);
        Assert.assertEquals((Object)kagent, (Object)new ServiceKAgentConfig(kagent));
        Assert.assertEquals((long)kagent.hashCode(), (long)new ServiceKAgentConfig(kagent).hashCode());
        ServiceKAgentConfig kagentEmptySet = new ServiceKAgentConfig("kagent2", Boolean.valueOf(false), Boolean.valueOf(true), new ArrayList());
        Assert.assertNotNull((Object)kagentEmptySet);
        Assert.assertEquals((Object)"kagent2", (Object)kagentEmptySet.getName());
        Assert.assertEquals((Object)false, (Object)kagentEmptySet.getNewInstance());
        Assert.assertEquals((Object)true, (Object)kagentEmptySet.getUseKBaseClassloader());
        Assert.assertNotNull((Object)kagentEmptySet.getResources());
        Assert.assertEquals((long)0L, (long)kagentEmptySet.getResources().size());
        Assert.assertFalse((boolean)kagentEmptySet.equals((Object)new ServiceKAgentConfig(kagentEmptySet.getName())));
        Assert.assertFalse((kagentEmptySet.hashCode() == new ServiceKAgentConfig(kagentEmptySet.getName()).hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)kagentEmptySet, (Object)kagentEmptySet);
        Assert.assertEquals((Object)kagentEmptySet, (Object)new ServiceKAgentConfig(kagentEmptySet));
        Assert.assertEquals((long)kagentEmptySet.hashCode(), (long)new ServiceKAgentConfig(kagentEmptySet).hashCode());
        ArrayList<AssetReference> resources = new ArrayList<AssetReference>(){
            {
                this.add(new AssetReference("a", "b", "c", "d", "e"));
                this.add(new AssetReference("a", "b", "c", "d", "e"));
                this.add(new AssetReference("a2", "b2", "c2", "d2", "e2"));
                this.add(new AssetReference("a3", "b3", "c3", "d3", "e3"));
            }
        };
        ServiceKAgentConfig kagentFull = new ServiceKAgentConfig("kagent3", Boolean.valueOf(false), Boolean.valueOf(true), (Collection)resources);
        Assert.assertNotNull((Object)kagentFull);
        Assert.assertEquals((Object)"kagent3", (Object)kagentFull.getName());
        Assert.assertEquals((Object)false, (Object)kagentFull.getNewInstance());
        Assert.assertEquals((Object)true, (Object)kagentFull.getUseKBaseClassloader());
        Assert.assertNotNull((Object)kagentFull.getResources());
        Assert.assertEquals((long)3L, (long)kagentFull.getResources().size());
        Assert.assertFalse((boolean)kagentFull.equals((Object)new ServiceKAgentConfig(kagentFull.getName())));
        Assert.assertFalse((kagentFull.hashCode() == new ServiceKAgentConfig(kagentFull.getName()).hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)kagentFull, (Object)kagentFull);
        Assert.assertEquals((Object)kagentFull, (Object)new ServiceKAgentConfig(kagentFull));
        Assert.assertEquals((long)kagentFull.hashCode(), (long)new ServiceKAgentConfig(kagentFull).hashCode());
        Assert.assertFalse((boolean)kagentFull.equals((Object)kagentEmptySet));
        Assert.assertFalse((boolean)kagentFull.equals((Object)kagent));
        Assert.assertFalse((boolean)kagent.equals((Object)kagentEmptySet));
    }

    @Test
    public void testEquals() {
        ArrayList<AssetReference> resources1 = new ArrayList<AssetReference>(){
            {
                this.add(new AssetReference("a", "b", "c", "d", "e"));
                this.add(new AssetReference("a", "b", "c", "d", "e"));
                this.add(new AssetReference("a2", "b2", "c2", "d2", "e2"));
                this.add(new AssetReference("a3", "b3", "c3", "d3", "e3"));
            }
        };
        ArrayList<AssetReference> resources2 = new ArrayList<AssetReference>(){
            {
                this.add(new AssetReference("a", "b", "c", "d", "e"));
                this.add(new AssetReference("a2", "b2", "c2", "d2", "e2"));
                this.add(new AssetReference("a3", "b3", "c3", "d3", "e3"));
            }
        };
        ArrayList<AssetReference> resources3 = new ArrayList<AssetReference>(){
            {
                this.add(new AssetReference("a", "b", "c", "d", "e"));
                this.add(new AssetReference("a3", "b3", "c3", "d3", "e3"));
            }
        };
        ServiceKAgentConfig kagent1a = new ServiceKAgentConfig("kagent1", Boolean.valueOf(false), Boolean.valueOf(true), (Collection)resources1);
        ServiceKAgentConfig kagent1b = new ServiceKAgentConfig("kagent1", Boolean.valueOf(false), Boolean.valueOf(true), (Collection)resources2);
        ServiceKAgentConfig kagent1c = new ServiceKAgentConfig("kagent1", Boolean.valueOf(false), Boolean.valueOf(true), (Collection)resources3);
        Assert.assertNotNull((Object)kagent1a);
        Assert.assertNotNull((Object)kagent1b);
        Assert.assertNotNull((Object)kagent1c);
        Assert.assertTrue((boolean)kagent1a.equals((Object)kagent1b));
        Assert.assertFalse((boolean)kagent1b.equals((Object)kagent1c));
        Assert.assertFalse((boolean)kagent1c.equals((Object)kagent1a));
        Assert.assertFalse((boolean)kagent1c.equals(null));
        Assert.assertFalse((boolean)kagent1c.equals((Object)"??"));
        ServiceKAgentConfig kagent1btf = new ServiceKAgentConfig("kagent1", Boolean.valueOf(true), Boolean.valueOf(false), (Collection)resources2);
        ServiceKAgentConfig kagent1ctf = new ServiceKAgentConfig("kagent1", Boolean.valueOf(true), Boolean.valueOf(false), (Collection)resources3);
        Assert.assertFalse((boolean)kagent1b.equals((Object)kagent1btf));
        Assert.assertFalse((boolean)kagent1c.equals((Object)kagent1ctf));
        kagent1btf.setNewInstance(false);
        kagent1btf.setUseKBaseClassloader(true);
        kagent1ctf.setNewInstance(false);
        kagent1ctf.setUseKBaseClassloader(true);
        Assert.assertTrue((boolean)kagent1b.equals((Object)kagent1btf));
        Assert.assertTrue((boolean)kagent1c.equals((Object)kagent1ctf));
        ServiceKAgentConfig kagent1bff = new ServiceKAgentConfig("kagent1", Boolean.valueOf(false), Boolean.valueOf(false), (Collection)resources2);
        ServiceKAgentConfig kagent1cff = new ServiceKAgentConfig("kagent1", Boolean.valueOf(false), Boolean.valueOf(false), (Collection)resources3);
        Assert.assertFalse((boolean)kagent1b.equals((Object)kagent1bff));
        Assert.assertFalse((boolean)kagent1c.equals((Object)kagent1cff));
        kagent1btf.setNewInstance(false);
        kagent1btf.setUseKBaseClassloader(true);
        kagent1ctf.setNewInstance(false);
        kagent1ctf.setUseKBaseClassloader(true);
        Assert.assertTrue((boolean)kagent1b.equals((Object)kagent1btf));
        Assert.assertTrue((boolean)kagent1c.equals((Object)kagent1ctf));
        ServiceKAgentConfig kagent1btt = new ServiceKAgentConfig("kagent1", Boolean.valueOf(true), Boolean.valueOf(true), (Collection)resources2);
        ServiceKAgentConfig kagent1ctt = new ServiceKAgentConfig("kagent1", Boolean.valueOf(true), Boolean.valueOf(true), (Collection)resources3);
        Assert.assertFalse((boolean)kagent1b.equals((Object)kagent1btt));
        Assert.assertFalse((boolean)kagent1c.equals((Object)kagent1ctt));
        kagent1btf.setNewInstance(false);
        kagent1btf.setUseKBaseClassloader(true);
        kagent1ctf.setNewInstance(false);
        kagent1ctf.setUseKBaseClassloader(true);
        Assert.assertTrue((boolean)kagent1b.equals((Object)kagent1btf));
        Assert.assertTrue((boolean)kagent1c.equals((Object)kagent1ctf));
    }

    @Test
    public void testAddRemoveResources() {
        ServiceKAgentConfig kagent = new ServiceKAgentConfig("kagent1", null, null, null);
        kagent.addResource(new AssetReference("a", "b", "c", "d", "e"));
        kagent.addResource(new AssetReference("a", "b", "c", "d", "e"));
        Assert.assertEquals((long)1L, (long)kagent.getResources().size());
        kagent.removeResource(new AssetReference("a", "b", "c", "d", "e"));
        kagent.removeResource(new AssetReference("a", "b", "c", "d", "e"));
        kagent.removeResource(null);
        Assert.assertEquals((long)0L, (long)kagent.getResources().size());
    }

    @Test
    public void tesAddResources() {
        ServiceKAgentConfig kagent = new ServiceKAgentConfig("kagent1", null, null, null);
        Assert.assertEquals((long)0L, (long)kagent.getResources().size());
        kagent.addResource(new AssetReference("za", "zb", "zc", "zd", "ze"));
        Assert.assertEquals((long)1L, (long)kagent.getResources().size());
        ArrayList<AssetReference> resources = new ArrayList<AssetReference>(){
            {
                this.add(new AssetReference("a", "b", "c", "d", "e"));
                this.add(new AssetReference("a", "b", "c", "d", "e"));
                this.add(new AssetReference("a2", "b2", "c2", "d2", "e2"));
                this.add(new AssetReference("a3", "b3", "c3", "d3", "e3"));
            }
        };
        kagent.addResources(null);
        kagent.addResources(new ArrayList());
        kagent.addResources((Collection)resources);
        Assert.assertEquals((long)4L, (long)kagent.getResources().size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullName() {
        new ServiceKAgentConfig((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyName() {
        new ServiceKAgentConfig("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnCopy() {
        new ServiceKAgentConfig((ServiceKAgentConfig)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnAddResource() {
        ServiceKAgentConfig kagent = new ServiceKAgentConfig("kagent1", null, null, null);
        kagent.addResource(null);
    }
}

