/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssertBehaviorOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.EventProcessingOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKAgentConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKBaseConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKSessionConfig;
import org.junit.Assert;
import org.junit.Test;

public class ServiceKBaseConfigTest {
    final Collection<AssetReference> resources = new ArrayList<AssetReference>(){
        {
            this.add(new AssetReference("myPkg", "a", "drl", "http://localhost/c/source", "uuid1"));
            this.add(new AssetReference("myPkg", "a", "drl", "http://localhost/c/source", "uuid1"));
            this.add(new AssetReference("myPkg", "aa", "drl", "http://localhost/cc/source", "uuid2"));
            this.add(new AssetReference("myPkg", "ab", "changeset", "http://localhost/cd/source", "uuid3"));
        }
    };
    final Collection<AssetReference> models = new ArrayList<AssetReference>(){
        {
            this.add(new AssetReference("myPkg", "a.jar", "model", "http://localhost/a.jar", "uudi44"));
            this.add(new AssetReference("myPkg", "a.jar", "model", "http://localhost/a.jar", "uudi44"));
        }
    };
    final Collection<ServiceKSessionConfig> ksessions = new ArrayList<ServiceKSessionConfig>(){
        {
            this.add(new ServiceKSessionConfig("ksession1"));
            this.add(new ServiceKSessionConfig("ksession1"));
            this.add(new ServiceKSessionConfig("ksession2"));
        }
    };
    final Collection<ServiceKAgentConfig> kagents = new ArrayList<ServiceKAgentConfig>(){
        {
            this.add(new ServiceKAgentConfig("kagent1"));
            this.add(new ServiceKAgentConfig("kagent1"));
            this.add(new ServiceKAgentConfig("kagent2"));
        }
    };

    @Test
    public void testSimpleConstructors() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1", null, null, null, null, null, null, null, null, null, null);
        Assert.assertNotNull((Object)kbase);
        Assert.assertEquals((Object)"kbase1", (Object)kbase.getName());
        Assert.assertNull((Object)kbase.getMaxThreads());
        Assert.assertNull((Object)kbase.getMbeans());
        Assert.assertNull((Object)kbase.getEventProcessingMode());
        Assert.assertNull((Object)kbase.getAssertBehavior());
        Assert.assertNull((Object)kbase.getAssetsUser());
        Assert.assertNull((Object)kbase.getAssetsPassword());
        Assert.assertFalse((boolean)kbase.hasConfig());
        Assert.assertNotNull((Object)kbase.getResources());
        Assert.assertNotNull((Object)kbase.getModels());
        Assert.assertEquals((long)0L, (long)kbase.getResources().size());
        Assert.assertEquals((long)0L, (long)kbase.getModels().size());
        Assert.assertNotNull((Object)kbase.getKsessions());
        Assert.assertNotNull((Object)kbase.getKagents());
        Assert.assertEquals((long)0L, (long)kbase.getKsessions().size());
        Assert.assertEquals((long)0L, (long)kbase.getKagents().size());
        Assert.assertEquals((Object)kbase, (Object)new ServiceKBaseConfig(kbase.getName()));
        Assert.assertTrue((kbase.hashCode() == new ServiceKBaseConfig(kbase.getName()).hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)kbase, (Object)new ServiceKBaseConfig(kbase));
        Assert.assertTrue((kbase.hashCode() == new ServiceKBaseConfig(kbase).hashCode() ? 1 : 0) != 0);
        ServiceKBaseConfig kbaseEmptyCollections = new ServiceKBaseConfig("kbase1", null, null, null, null, null, null, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
        Assert.assertEquals((Object)kbase, (Object)kbaseEmptyCollections);
        Assert.assertTrue((kbase.hashCode() == kbaseEmptyCollections.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testConstructorsWithContentLists() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1", null, null, null, null, null, null, this.resources, this.models, this.ksessions, this.kagents);
        Assert.assertNotNull((Object)kbase.getResources());
        Assert.assertNotNull((Object)kbase.getModels());
        Assert.assertFalse((boolean)kbase.hasConfig());
        Assert.assertEquals((long)3L, (long)kbase.getResources().size());
        Assert.assertEquals((long)1L, (long)kbase.getModels().size());
        Assert.assertNotNull((Object)kbase.getKsessions());
        Assert.assertNotNull((Object)kbase.getKagents());
        Assert.assertEquals((long)2L, (long)kbase.getKsessions().size());
        Assert.assertEquals((long)2L, (long)kbase.getKagents().size());
        Assert.assertNull((Object)kbase.getKsession("notExists"));
        Assert.assertNotNull((Object)kbase.getKsession("ksession1"));
    }

    @Test
    public void testEquals() {
        ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
        Assert.assertEquals((Object)kbase1, (Object)kbase1);
        Assert.assertFalse((boolean)kbase1.equals((Object)"???"));
        Assert.assertFalse((boolean)kbase1.equals(null));
        Assert.assertFalse((boolean)kbase1.equals((Object)new ServiceKBaseConfig("kbase2")));
        Assert.assertFalse((kbase1.hashCode() == new ServiceKBaseConfig("kbase2").hashCode() ? 1 : 0) != 0);
        kbase1.setAssertBehavior(AssertBehaviorOption.EQUALITY);
        Assert.assertTrue((boolean)kbase1.hasConfig());
        Assert.assertFalse((boolean)new ServiceKBaseConfig("kbase1").equals((Object)kbase1));
        kbase1 = new ServiceKBaseConfig("kbase1");
        kbase1.setEventProcessingMode(EventProcessingOption.CLOUD);
        Assert.assertTrue((boolean)kbase1.hasConfig());
        Assert.assertFalse((boolean)new ServiceKBaseConfig("kbase1").equals((Object)kbase1));
        Assert.assertFalse((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
        kbase1 = new ServiceKBaseConfig("kbase1");
        kbase1.setAssetsPassword("password");
        Assert.assertFalse((boolean)kbase1.hasConfig());
        Assert.assertFalse((boolean)new ServiceKBaseConfig("kbase1").equals((Object)kbase1));
        Assert.assertFalse((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
        kbase1 = new ServiceKBaseConfig("kbase1");
        kbase1.setAssetsUser("user");
        Assert.assertFalse((boolean)kbase1.hasConfig());
        Assert.assertFalse((boolean)new ServiceKBaseConfig("kbase1").equals((Object)kbase1));
        Assert.assertFalse((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
        kbase1 = new ServiceKBaseConfig("kbase1");
        kbase1.setMaxThreads(10);
        Assert.assertFalse((boolean)new ServiceKBaseConfig("kbase1").equals((Object)kbase1));
        Assert.assertFalse((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
        kbase1 = new ServiceKBaseConfig("kbase1");
        kbase1.setMbeans(true);
        Assert.assertFalse((boolean)new ServiceKBaseConfig("kbase1").equals((Object)kbase1));
        Assert.assertFalse((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testAddRemoveModels() {
        ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
        Assert.assertNotNull((Object)kbase1.getResources());
        Assert.assertNotNull((Object)kbase1.getModels());
        Assert.assertEquals((long)0L, (long)kbase1.getModels().size());
        kbase1.addModels(this.models);
        kbase1.addModels(null);
        kbase1.addModels(new ArrayList());
        Assert.assertEquals((long)1L, (long)kbase1.getModels().size());
        Assert.assertFalse((boolean)kbase1.equals((Object)new ServiceKBaseConfig("kbase1")));
        Assert.assertFalse((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
        kbase1.removeModel(new AssetReference("myPkg", "a.jar", "model", "http://localhost/a.jar", "uudi44"));
        kbase1.removeModel(new AssetReference("aaamyPkg", "a.jar", "model", "http://localhost/a.jar", "uudi44"));
        kbase1.removeModel(null);
        Assert.assertTrue((boolean)kbase1.equals((Object)new ServiceKBaseConfig("kbase1")));
        Assert.assertTrue((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
        kbase1.addModel(new AssetReference("aaamyPkg", "a.jar", "model", "http://localhost/a.jar", "uudi44"));
        kbase1.addModel(null);
        Assert.assertEquals((long)1L, (long)kbase1.getModels().size());
        kbase1.setModels(null);
        Assert.assertEquals((long)0L, (long)kbase1.getModels().size());
        kbase1.setModels(this.models);
        Assert.assertEquals((long)1L, (long)kbase1.getModels().size());
    }

    @Test
    public void testAddRemoveResources() {
        ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
        Assert.assertNotNull((Object)kbase1.getResources());
        Assert.assertEquals((long)0L, (long)kbase1.getResources().size());
        kbase1.addResources(this.resources);
        kbase1.addResources(null);
        kbase1.addResources(new ArrayList());
        Assert.assertEquals((long)3L, (long)kbase1.getResources().size());
        Assert.assertFalse((boolean)kbase1.equals((Object)new ServiceKBaseConfig("kbase1")));
        Assert.assertFalse((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
        kbase1.removeResource(new AssetReference("myPkg", "a", "drl", "http://localhost/c/source", "uuid1"));
        kbase1.removeResource(new AssetReference("myPkg", "aa", "drl", "http://localhost/cc/source", "uuid2"));
        kbase1.removeResource(new AssetReference("myPkg", "ab", "changeset", "http://localhost/cd/source", "uuid3"));
        kbase1.removeResource(new AssetReference("aaaamyPkg", "ab", "changeset", "http://localhost/cd/source", "uuid3"));
        kbase1.removeResource(null);
        Assert.assertTrue((boolean)kbase1.equals((Object)new ServiceKBaseConfig("kbase1")));
        Assert.assertTrue((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
        kbase1.addResource(new AssetReference("aaaamyPkg", "ab", "changeset", "http://localhost/cd/source", "uuid3"));
        kbase1.addResource(null);
        Assert.assertEquals((long)1L, (long)kbase1.getResources().size());
        kbase1.setResources(null);
        Assert.assertEquals((long)0L, (long)kbase1.getResources().size());
        kbase1.setResources(this.resources);
        Assert.assertEquals((long)3L, (long)kbase1.getResources().size());
    }

    @Test
    public void testAddRemoveKAgents() {
        ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
        Assert.assertNotNull((Object)kbase1.getKagents());
        Assert.assertEquals((long)0L, (long)kbase1.getKagents().size());
        kbase1.addKagent(new ServiceKAgentConfig("kagent1"));
        kbase1.addKagent(new ServiceKAgentConfig("kagent2"));
        kbase1.addKagent(new ServiceKAgentConfig("kagent3"));
        kbase1.addKagent(null);
        Assert.assertEquals((long)3L, (long)kbase1.getKagents().size());
        Assert.assertFalse((boolean)kbase1.equals((Object)new ServiceKBaseConfig("kbase1")));
        Assert.assertFalse((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
        kbase1.removeKagent("kagent1");
        kbase1.removeKagent("kagent2");
        kbase1.removeKagent("kagent3");
        kbase1.removeKagent("");
        kbase1.removeKagent(null);
        Assert.assertTrue((boolean)kbase1.equals((Object)new ServiceKBaseConfig("kbase1")));
        Assert.assertTrue((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testAddRemoveKSession() {
        ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
        Assert.assertNotNull((Object)kbase1.getKsessions());
        Assert.assertEquals((long)0L, (long)kbase1.getKsessions().size());
        kbase1.addKsession(new ServiceKSessionConfig("ksession1"));
        kbase1.addKsession(new ServiceKSessionConfig("ksession2"));
        kbase1.addKsession(new ServiceKSessionConfig("ksession3"));
        kbase1.addKsession(null);
        Assert.assertEquals((long)3L, (long)kbase1.getKsessions().size());
        Assert.assertFalse((boolean)kbase1.equals((Object)new ServiceKBaseConfig("kbase1")));
        Assert.assertFalse((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
        kbase1.removeKsession("ksession1");
        kbase1.removeKsession("ksession2");
        kbase1.removeKsession("ksession3");
        kbase1.removeKsession("");
        kbase1.removeKsession(null);
        Assert.assertTrue((boolean)kbase1.equals((Object)new ServiceKBaseConfig("kbase1")));
        Assert.assertTrue((kbase1.hashCode() == new ServiceKBaseConfig("kbase1").hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testNextKSessionName() {
        ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
        Assert.assertEquals((Object)"ksession1", (Object)kbase1.getNextKSessionName());
        Assert.assertEquals((Object)"ksession1", (Object)kbase1.getNextKSessionName());
        kbase1.addKsession(new ServiceKSessionConfig("ksession1"));
        kbase1.addKsession(new ServiceKSessionConfig("ksession3"));
        Assert.assertEquals((Object)"ksession2", (Object)kbase1.getNextKSessionName());
        kbase1.addKsession(new ServiceKSessionConfig("ksession2"));
        Assert.assertEquals((Object)"ksession4", (Object)kbase1.getNextKSessionName());
    }

    @Test
    public void testNextKAgentName() {
        ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
        Assert.assertEquals((Object)"kagent1", (Object)kbase1.getNextKAgentName());
        Assert.assertEquals((Object)"kagent1", (Object)kbase1.getNextKAgentName());
        kbase1.addKagent(new ServiceKAgentConfig("kagent1"));
        kbase1.addKagent(new ServiceKAgentConfig("kagent3"));
        Assert.assertEquals((Object)"kagent2", (Object)kbase1.getNextKAgentName());
        kbase1.addKagent(new ServiceKAgentConfig("kagent2"));
        Assert.assertEquals((Object)"kagent4", (Object)kbase1.getNextKAgentName());
    }

    @Test
    public void testCloneWithDifferentName() {
        ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
        kbase1.setMbeans(true);
        kbase1.setModels(this.models);
        ServiceKBaseConfig kbase2 = new ServiceKBaseConfig("kbase2", kbase1);
        Assert.assertTrue((boolean)kbase2.getMbeans());
        Assert.assertEquals((long)1L, (long)kbase2.getModels().size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullName() {
        new ServiceKBaseConfig((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyName() {
        new ServiceKBaseConfig("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnCopy() {
        new ServiceKBaseConfig((ServiceKBaseConfig)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnAssetsPassword() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.setAssetsPassword(null);
    }

    @Test
    public void testEmptyOnAssetsPassword() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.setAssetsPassword("");
    }

    @Test
    public void testNullOnAssetsPassword2() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.setAssetsPassword("sss");
        Assert.assertNotNull((Object)kbase.getAssetsPassword());
        kbase.setAssetsPasswordToNull();
        Assert.assertNull((Object)kbase.getAssetsPassword());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnAssetsUser() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.setAssetsUser(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyOnAssetsUser() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.setAssetsUser("");
    }

    @Test
    public void testEmptyOnAssetsUser2() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.setAssetsUser("sss");
        Assert.assertNotNull((Object)kbase.getAssetsUser());
        kbase.setAssetsUserToNull();
        Assert.assertNull((Object)kbase.getAssetsUser());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnEventProcessing() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.setEventProcessingMode(null);
    }

    @Test
    public void testNullOnEventProcessing2() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.setEventProcessingMode(EventProcessingOption.CLOUD);
        Assert.assertNotNull((Object)kbase.getEventProcessingMode());
        kbase.setEventProcessingModeToNull();
        Assert.assertNull((Object)kbase.getEventProcessingMode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnAssertBehavior() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.setAssertBehavior(null);
    }

    @Test
    public void testNullOnAssertBehavior2() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.setAssertBehavior(AssertBehaviorOption.EQUALITY);
        Assert.assertNotNull((Object)kbase.getAssertBehavior());
        kbase.setAssertBehaviorToNull();
        Assert.assertNull((Object)kbase.getAssertBehavior());
    }

    @Test
    public void testNullOnMbeans() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.setMbeans(true);
        Assert.assertNotNull((Object)kbase.getMbeans());
        kbase.setMbeansToNull();
        Assert.assertNull((Object)kbase.getMbeans());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testKSessionAlreadyExists() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.addKsession(new ServiceKSessionConfig("ksession1"));
        kbase.addKsession(new ServiceKSessionConfig("ksession1"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testKAgentAlreadyExists() {
        ServiceKBaseConfig kbase = new ServiceKBaseConfig("kbase1");
        kbase.addKagent(new ServiceKAgentConfig("kagent1"));
        kbase.addKagent(new ServiceKAgentConfig("kagent1"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCloneNull() {
        new ServiceKBaseConfig("kbase2", null);
    }
}

