/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import java.util.HashMap;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ClockType;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.MarshallingOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ProtocolOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKSessionConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.SessionType;
import org.junit.Assert;
import org.junit.Test;

public class ServiceKSessionConfigTest {
    @Test
    public void testDefaultValues() {
        ServiceKSessionConfig ksession = new ServiceKSessionConfig("ksession1", null, null, null, null, null, null, null);
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((Object)"ksession1", (Object)ksession.getName());
        Assert.assertEquals((Object)"ksession1", (Object)ksession.getUrl());
        Assert.assertEquals((Object)ProtocolOption.REST, (Object)ksession.getProtocol());
        Assert.assertEquals((Object)MarshallingOption.XSTREAM, (Object)ksession.getMarshalling());
        Assert.assertEquals((Object)SessionType.STATELESS, (Object)ksession.getType());
        Assert.assertFalse((boolean)ksession.hasConfig());
        Assert.assertNull((Object)ksession.getClockType());
        Assert.assertNull((Object)ksession.getKeepReference());
        Assert.assertNotNull((Object)ksession.getListeners());
        Assert.assertEquals((long)0L, (long)ksession.getListeners().size());
        Assert.assertEquals((long)0L, (long)ksession.getAgendaListeners().size());
        Assert.assertEquals((long)0L, (long)ksession.getProcessListeners().size());
        Assert.assertEquals((long)0L, (long)ksession.getWorkingMemoryListeners().size());
        Assert.assertEquals((Object)ksession, (Object)new ServiceKSessionConfig(ksession.getName()));
        Assert.assertEquals((long)ksession.hashCode(), (long)new ServiceKSessionConfig(ksession.getName()).hashCode());
        Assert.assertEquals((Object)ksession, (Object)new ServiceKSessionConfig(ksession.getName(), null, null, ProtocolOption.REST, MarshallingOption.XSTREAM, null, null, new HashMap()));
        Assert.assertEquals((long)ksession.hashCode(), (long)new ServiceKSessionConfig(ksession.getName(), null, null, ProtocolOption.REST, MarshallingOption.XSTREAM, null, null, new HashMap()).hashCode());
        Assert.assertEquals((Object)ksession, (Object)ksession);
        Assert.assertEquals((Object)ksession, (Object)new ServiceKSessionConfig(ksession));
        Assert.assertEquals((long)ksession.hashCode(), (long)new ServiceKSessionConfig(ksession).hashCode());
    }

    @Test
    public void testEqualsOnProtocol() {
        ServiceKSessionConfig ksession1a = new ServiceKSessionConfig("ksession1", "url_ksession1", null, null, null, null, null, null);
        ServiceKSessionConfig ksession1b = new ServiceKSessionConfig("ksession1", "url_ksession1", null, ProtocolOption.WEB_SERVICE, MarshallingOption.XSTREAM, null, null, null);
        ServiceKSessionConfig ksession1c = new ServiceKSessionConfig("ksession1", "url_ksession1", null, ProtocolOption.REST, MarshallingOption.JSON, null, null, null);
        Assert.assertFalse((boolean)ksession1a.equals((Object)ksession1b));
        Assert.assertFalse((boolean)ksession1a.equals((Object)ksession1c));
        Assert.assertFalse((boolean)ksession1b.equals((Object)ksession1c));
        ksession1b.setProtocol(ProtocolOption.REST);
        Assert.assertTrue((boolean)ksession1a.equals((Object)ksession1b));
        ksession1c.setMarshalling(MarshallingOption.XSTREAM);
        Assert.assertTrue((boolean)ksession1a.equals((Object)ksession1c));
        ksession1b.setUrl("custom_url");
        Assert.assertFalse((boolean)ksession1a.equals((Object)ksession1b));
        ksession1c.setUrl("custom_url");
        Assert.assertFalse((boolean)ksession1a.equals((Object)ksession1c));
        Assert.assertTrue((boolean)ksession1c.equals((Object)ksession1b));
    }

    @Test
    public void testEqualsOnGeneral() {
        ServiceKSessionConfig ksession1apn = new ServiceKSessionConfig("ksession1", "url_ksession1", null, null, null, ClockType.PSEUDO, null, null);
        ServiceKSessionConfig ksession1bnt = new ServiceKSessionConfig("ksession1", "url_ksession1", null, null, null, null, Boolean.valueOf(true), null);
        ServiceKSessionConfig ksession1crf = new ServiceKSessionConfig("ksession1", "url_ksession1", null, null, null, ClockType.REALTIME, Boolean.valueOf(false), null);
        ServiceKSessionConfig ksession1dpf = new ServiceKSessionConfig("ksession1", "url_ksession1", null, null, null, ClockType.PSEUDO, Boolean.valueOf(false), null);
        Assert.assertFalse((boolean)ksession1apn.equals((Object)ksession1bnt));
        Assert.assertFalse((boolean)ksession1apn.equals((Object)ksession1crf));
        Assert.assertFalse((boolean)ksession1bnt.equals((Object)ksession1crf));
        Assert.assertFalse((boolean)ksession1bnt.equals((Object)ksession1dpf));
        Assert.assertFalse((boolean)ksession1crf.equals((Object)ksession1dpf));
        ksession1apn.setKeepReference(true);
        Assert.assertTrue((boolean)ksession1apn.hasConfig());
        Assert.assertFalse((boolean)ksession1apn.equals((Object)ksession1bnt));
        Assert.assertFalse((boolean)ksession1apn.equals((Object)ksession1crf));
        Assert.assertFalse((boolean)ksession1apn.equals((Object)ksession1dpf));
        ksession1apn.setKeepReference(false);
        Assert.assertTrue((boolean)ksession1apn.hasConfig());
        Assert.assertTrue((boolean)ksession1apn.equals((Object)ksession1dpf));
        ksession1bnt.setClockType(ClockType.REALTIME);
        Assert.assertTrue((boolean)ksession1bnt.hasConfig());
        Assert.assertFalse((boolean)ksession1apn.equals((Object)ksession1bnt));
        Assert.assertFalse((boolean)ksession1apn.equals((Object)ksession1crf));
        Assert.assertFalse((boolean)ksession1bnt.equals((Object)ksession1crf));
        Assert.assertFalse((boolean)ksession1bnt.equals((Object)ksession1dpf));
        Assert.assertFalse((boolean)ksession1crf.equals((Object)ksession1dpf));
        ksession1bnt.setKeepReference(false);
        Assert.assertTrue((boolean)ksession1bnt.hasConfig());
        Assert.assertFalse((boolean)ksession1apn.equals((Object)ksession1bnt));
        Assert.assertFalse((boolean)ksession1apn.equals((Object)ksession1crf));
        Assert.assertFalse((boolean)ksession1bnt.equals((Object)ksession1dpf));
        Assert.assertFalse((boolean)ksession1crf.equals((Object)ksession1dpf));
        Assert.assertTrue((boolean)ksession1bnt.equals((Object)ksession1crf));
    }

    @Test
    public void simpleEquals() {
        ServiceKSessionConfig ksession1 = new ServiceKSessionConfig("ksession1");
        ServiceKSessionConfig ksession2 = new ServiceKSessionConfig("ksession1");
        ksession2.setType(SessionType.STATEFUL);
        Assert.assertFalse((boolean)ksession1.equals((Object)ksession2));
        Assert.assertTrue((boolean)ksession1.equals((Object)ksession1));
        Assert.assertFalse((boolean)ksession1.equals((Object)new ServiceKSessionConfig("mmm")));
        Assert.assertFalse((boolean)ksession1.equals(null));
        Assert.assertFalse((boolean)ksession1.equals((Object)"mm"));
    }

    @Test
    public void testAddRemoveListeners() {
        ServiceKSessionConfig ksession = new ServiceKSessionConfig("ksession1");
        Assert.assertNotNull((Object)ksession.getListeners());
        Assert.assertEquals((long)0L, (long)ksession.getListeners().size());
        Assert.assertEquals((long)0L, (long)ksession.getAgendaListeners().size());
        Assert.assertEquals((long)0L, (long)ksession.getProcessListeners().size());
        Assert.assertEquals((long)0L, (long)ksession.getWorkingMemoryListeners().size());
        ksession.addAgendaListener("a.b.Ccc");
        ksession.addAgendaListener("a.b.Ddd");
        ksession.addAgendaListener("a.b.Eee");
        ksession.addAgendaListener("a.b.Eee");
        Assert.assertEquals((long)3L, (long)ksession.getListeners().size());
        Assert.assertEquals((long)3L, (long)ksession.getAgendaListeners().size());
        Assert.assertEquals((long)0L, (long)ksession.getProcessListeners().size());
        Assert.assertEquals((long)0L, (long)ksession.getWorkingMemoryListeners().size());
        Assert.assertTrue((boolean)ksession.hasConfig());
        ksession.addProcessListener("a.b.Ccc");
        ksession.addProcessListener("a.b.Ddd");
        ksession.addProcessListener("a.b.Ddd");
        ksession.addProcessListener("a.b.Eee");
        Assert.assertEquals((long)3L, (long)ksession.getListeners().size());
        Assert.assertEquals((long)3L, (long)ksession.getAgendaListeners().size());
        Assert.assertEquals((long)3L, (long)ksession.getProcessListeners().size());
        Assert.assertEquals((long)0L, (long)ksession.getWorkingMemoryListeners().size());
        ksession.addWorkingMemoryListener("a.b.Ccc");
        ksession.addWorkingMemoryListener("a.b.Ccc");
        ksession.addWorkingMemoryListener("a.b.Ddd");
        ksession.addWorkingMemoryListener("a.b.Eee");
        Assert.assertEquals((long)3L, (long)ksession.getListeners().size());
        Assert.assertEquals((long)3L, (long)ksession.getAgendaListeners().size());
        Assert.assertEquals((long)3L, (long)ksession.getProcessListeners().size());
        Assert.assertEquals((long)3L, (long)ksession.getWorkingMemoryListeners().size());
        Assert.assertEquals((Object)ksession, (Object)ksession);
        Assert.assertFalse((boolean)ksession.equals((Object)new ServiceKSessionConfig(ksession.getName())));
        Assert.assertEquals((Object)ksession, (Object)new ServiceKSessionConfig(ksession));
        Assert.assertEquals((long)ksession.hashCode(), (long)new ServiceKSessionConfig(ksession).hashCode());
        ksession.removeAgendaListener("a.b.Ccc");
        ksession.removeAgendaListener("");
        ksession.removeAgendaListener(null);
        Assert.assertEquals((long)3L, (long)ksession.getListeners().size());
        Assert.assertEquals((long)2L, (long)ksession.getAgendaListeners().size());
        Assert.assertEquals((long)3L, (long)ksession.getProcessListeners().size());
        Assert.assertEquals((long)3L, (long)ksession.getWorkingMemoryListeners().size());
        ksession.removeProcessListener("a.b.Ddd");
        ksession.removeProcessListener("");
        ksession.removeProcessListener(null);
        Assert.assertEquals((long)3L, (long)ksession.getListeners().size());
        Assert.assertEquals((long)2L, (long)ksession.getAgendaListeners().size());
        Assert.assertEquals((long)2L, (long)ksession.getProcessListeners().size());
        Assert.assertEquals((long)3L, (long)ksession.getWorkingMemoryListeners().size());
        ksession.removeWorkingMemoryListener("a.b.Eee");
        ksession.removeWorkingMemoryListener("");
        ksession.removeWorkingMemoryListener(null);
        Assert.assertEquals((long)3L, (long)ksession.getListeners().size());
        Assert.assertEquals((long)2L, (long)ksession.getAgendaListeners().size());
        Assert.assertEquals((long)2L, (long)ksession.getProcessListeners().size());
        Assert.assertEquals((long)2L, (long)ksession.getWorkingMemoryListeners().size());
        ksession.removeAgendaListener("a.b.Ddd");
        ksession.removeProcessListener("a.b.Ddd");
        ksession.removeWorkingMemoryListener("a.b.Ddd");
        Assert.assertEquals((long)2L, (long)ksession.getListeners().size());
        Assert.assertEquals((long)2L, (long)ksession.getProcessListeners().size());
        Assert.assertEquals((long)1L, (long)ksession.getWorkingMemoryListeners().size());
        Assert.assertEquals((long)1L, (long)ksession.getAgendaListeners().size());
    }

    @Test
    public void testCloneWithDifferentName() {
        ServiceKSessionConfig ksession1 = new ServiceKSessionConfig("ksession1");
        ksession1.setUrl("aaa");
        ksession1.setType(SessionType.STATEFUL);
        ServiceKSessionConfig ksession2 = new ServiceKSessionConfig("ksession2", ksession1);
        Assert.assertEquals((Object)"aaa", (Object)ksession2.getUrl());
        Assert.assertEquals((Object)SessionType.STATEFUL, (Object)ksession2.getType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullName() {
        new ServiceKSessionConfig((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyName() {
        new ServiceKSessionConfig("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnCopy() {
        new ServiceKSessionConfig((ServiceKSessionConfig)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnClockType() {
        ServiceKSessionConfig ksession = new ServiceKSessionConfig("ksession1");
        ksession.setClockType(null);
    }

    @Test
    public void testNullOnClockType2() {
        ServiceKSessionConfig ksession = new ServiceKSessionConfig("ksession1");
        ksession.setClockType(ClockType.PSEUDO);
        Assert.assertNotNull((Object)ksession.getClockType());
        ksession.setClockTypeToNull();
        Assert.assertNull((Object)ksession.getClockType());
    }

    @Test
    public void testNullOnKeepReference() {
        ServiceKSessionConfig ksession = new ServiceKSessionConfig("ksession1");
        ksession.setKeepReference(true);
        Assert.assertNotNull((Object)ksession.getKeepReference());
        ksession.setKeepReferenceToNull();
        Assert.assertNull((Object)ksession.getKeepReference());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnMarshalling() {
        ServiceKSessionConfig ksession = new ServiceKSessionConfig("ksession1");
        ksession.setMarshalling(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnProtocol() {
        ServiceKSessionConfig ksession = new ServiceKSessionConfig("ksession1");
        ksession.setProtocol(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnUrl() {
        ServiceKSessionConfig ksession = new ServiceKSessionConfig("ksession1");
        ksession.setUrl(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyOnUrl() {
        ServiceKSessionConfig ksession = new ServiceKSessionConfig("ksession1");
        ksession.setUrl("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnType() {
        ServiceKSessionConfig ksession = new ServiceKSessionConfig("ksession1");
        ksession.setType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCloneNull() {
        new ServiceKSessionConfig("ksession", null);
    }
}

