/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.analysis;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.decisiontable.analysis.DecisionTableAnalyzer;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.Analysis;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.junit.Assert;
import org.junit.Test;

public class DecisionTableAnalyzerTest {
    @Test
    public void testImpossibleMatchesBoolean() throws ParseException {
        SuggestionCompletionEngine sce = this.buildSuggestionCompletionEngine();
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 driverPattern = new Pattern52();
        driverPattern.setBoundName("driverPattern");
        driverPattern.setFactType("Driver");
        ConditionCol52 approved = new ConditionCol52();
        approved.setFactField("approved");
        approved.setOperator("==");
        approved.setConstraintValueType(1);
        driverPattern.getChildColumns().add(approved);
        ConditionCol52 disapproved = new ConditionCol52();
        disapproved.setFactField("approved");
        disapproved.setOperator("!=");
        disapproved.setConstraintValueType(1);
        driverPattern.getChildColumns().add(disapproved);
        dt.getConditions().add(driverPattern);
        ActionSetFieldCol52 message = new ActionSetFieldCol52();
        message.setBoundName("m");
        message.setFactField("message");
        dt.getActionCols().add(message);
        List<List> data = Arrays.asList(Arrays.asList(new DTCellValue52(Integer.valueOf(1)), new DTCellValue52("Row 1 description"), new DTCellValue52(Boolean.TRUE), new DTCellValue52(Boolean.FALSE), new DTCellValue52("Row 1 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(2)), new DTCellValue52("Row 2 description"), new DTCellValue52(Boolean.TRUE), new DTCellValue52(Boolean.TRUE), new DTCellValue52("Row 2 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(3)), new DTCellValue52("Row 3 description"), new DTCellValue52(Boolean.TRUE), new DTCellValue52((Boolean)null), new DTCellValue52("Row 3 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(4)), new DTCellValue52("Row 4 description"), new DTCellValue52((Boolean)null), new DTCellValue52(Boolean.TRUE), new DTCellValue52("Row 4 message")));
        dt.setData(data);
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(sce);
        List analysisData = analyzer.analyze(dt);
        Assert.assertEquals((long)data.size(), (long)analysisData.size());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(0)).getImpossibleMatchesSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(1)).getImpossibleMatchesSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(2)).getImpossibleMatchesSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(3)).getImpossibleMatchesSize());
    }

    @Test
    public void testImpossibleMatchesNumeric() throws ParseException {
        SuggestionCompletionEngine sce = this.buildSuggestionCompletionEngine();
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 driverPattern = new Pattern52();
        driverPattern.setBoundName("driverPattern");
        driverPattern.setFactType("Driver");
        ConditionCol52 ageMinimum = new ConditionCol52();
        ageMinimum.setFactField("age");
        ageMinimum.setOperator(">=");
        ageMinimum.setConstraintValueType(1);
        driverPattern.getChildColumns().add(ageMinimum);
        ConditionCol52 ageMaximum = new ConditionCol52();
        ageMaximum.setFactField("age");
        ageMaximum.setOperator("<=");
        ageMaximum.setConstraintValueType(1);
        driverPattern.getChildColumns().add(ageMaximum);
        dt.getConditions().add(driverPattern);
        ActionSetFieldCol52 message = new ActionSetFieldCol52();
        message.setBoundName("m");
        message.setFactField("message");
        dt.getActionCols().add(message);
        List<List> data = Arrays.asList(Arrays.asList(new DTCellValue52(Integer.valueOf(1)), new DTCellValue52("Row 1 description"), new DTCellValue52(new Integer("20")), new DTCellValue52(new Integer("50")), new DTCellValue52("Row 1 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(2)), new DTCellValue52("Row 2 description"), new DTCellValue52(new Integer("40")), new DTCellValue52(new Integer("30")), new DTCellValue52("Row 2 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(3)), new DTCellValue52("Row 3 description"), new DTCellValue52((Integer)null), new DTCellValue52(new Integer("50")), new DTCellValue52("Row 3 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(4)), new DTCellValue52("Row 4 description"), new DTCellValue52(new Integer("20")), new DTCellValue52((Integer)null), new DTCellValue52("Row 4 message")));
        dt.setData(data);
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(sce);
        List analysisData = analyzer.analyze(dt);
        Assert.assertEquals((long)data.size(), (long)analysisData.size());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(0)).getImpossibleMatchesSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(1)).getImpossibleMatchesSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(2)).getImpossibleMatchesSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(3)).getImpossibleMatchesSize());
    }

    @Test
    public void testImpossibleMatchesString() throws ParseException {
        SuggestionCompletionEngine sce = this.buildSuggestionCompletionEngine();
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 driverPattern = new Pattern52();
        driverPattern.setBoundName("driverPattern");
        driverPattern.setFactType("Driver");
        ConditionCol52 name = new ConditionCol52();
        name.setFactField("name");
        name.setOperator("==");
        name.setConstraintValueType(1);
        driverPattern.getChildColumns().add(name);
        ConditionCol52 notName = new ConditionCol52();
        notName.setFactField("name");
        notName.setOperator("!=");
        notName.setConstraintValueType(1);
        driverPattern.getChildColumns().add(notName);
        ConditionCol52 nameIn = new ConditionCol52();
        nameIn.setFactField("name");
        nameIn.setOperator("in");
        nameIn.setConstraintValueType(1);
        driverPattern.getChildColumns().add(nameIn);
        dt.getConditions().add(driverPattern);
        ActionSetFieldCol52 message = new ActionSetFieldCol52();
        message.setBoundName("m");
        message.setFactField("message");
        dt.getActionCols().add(message);
        List<List> data = Arrays.asList(Arrays.asList(new DTCellValue52(Integer.valueOf(1)), new DTCellValue52("Row 1 description"), new DTCellValue52("Homer"), new DTCellValue52("Bart"), new DTCellValue52((String)null), new DTCellValue52("Row 1 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(2)), new DTCellValue52("Row 2 description"), new DTCellValue52("Homer"), new DTCellValue52("Homer"), new DTCellValue52((String)null), new DTCellValue52("Row 2 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(3)), new DTCellValue52("Row 3 description"), new DTCellValue52("Homer"), new DTCellValue52((String)null), new DTCellValue52((String)null), new DTCellValue52("Row 3 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(4)), new DTCellValue52("Row 4 description"), new DTCellValue52((String)null), new DTCellValue52("Bart"), new DTCellValue52((String)null), new DTCellValue52("Row 4 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(5)), new DTCellValue52("Row 5 description"), new DTCellValue52("Homer"), new DTCellValue52((String)null), new DTCellValue52("Marge,Lisa"), new DTCellValue52("Row 5 message")));
        dt.setData(data);
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(sce);
        List analysisData = analyzer.analyze(dt);
        Assert.assertEquals((long)data.size(), (long)analysisData.size());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(0)).getImpossibleMatchesSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(1)).getImpossibleMatchesSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(2)).getImpossibleMatchesSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(3)).getImpossibleMatchesSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(4)).getImpossibleMatchesSize());
    }

    @Test
    public void testImpossibleMatchesDate() throws ParseException {
        SuggestionCompletionEngine sce = this.buildSuggestionCompletionEngine();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 driverPattern = new Pattern52();
        driverPattern.setBoundName("driverPattern");
        driverPattern.setFactType("Driver");
        ConditionCol52 dateOfBirthMinimum = new ConditionCol52();
        dateOfBirthMinimum.setFactField("dateOfBirth");
        dateOfBirthMinimum.setOperator(">=");
        dateOfBirthMinimum.setConstraintValueType(1);
        driverPattern.getChildColumns().add(dateOfBirthMinimum);
        ConditionCol52 dateOfBirthMaximum = new ConditionCol52();
        dateOfBirthMaximum.setFactField("dateOfBirth");
        dateOfBirthMaximum.setOperator("<=");
        dateOfBirthMaximum.setConstraintValueType(1);
        driverPattern.getChildColumns().add(dateOfBirthMaximum);
        dt.getConditions().add(driverPattern);
        ActionSetFieldCol52 message = new ActionSetFieldCol52();
        message.setBoundName("m");
        message.setFactField("message");
        dt.getActionCols().add(message);
        List<List> data = Arrays.asList(Arrays.asList(new DTCellValue52(Integer.valueOf(1)), new DTCellValue52("Row 1 description"), new DTCellValue52(dateFormat.parse("1981-01-01")), new DTCellValue52(dateFormat.parse("2001-01-01")), new DTCellValue52("Row 1 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(2)), new DTCellValue52("Row 2 description"), new DTCellValue52(dateFormat.parse("2001-01-01")), new DTCellValue52(dateFormat.parse("1981-01-01")), new DTCellValue52("Row 2 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(3)), new DTCellValue52("Row 3 description"), new DTCellValue52((Date)null), new DTCellValue52(dateFormat.parse("2001-01-01")), new DTCellValue52("Row 3 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(4)), new DTCellValue52("Row 4 description"), new DTCellValue52(dateFormat.parse("1981-01-01")), new DTCellValue52((Date)null), new DTCellValue52("Row 4 message")));
        dt.setData(data);
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(sce);
        List analysisData = analyzer.analyze(dt);
        Assert.assertEquals((long)data.size(), (long)analysisData.size());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(0)).getImpossibleMatchesSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(1)).getImpossibleMatchesSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(2)).getImpossibleMatchesSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(3)).getImpossibleMatchesSize());
    }

    @Test
    public void testImpossibleMatchesCombination() throws ParseException {
        SuggestionCompletionEngine sce = this.buildSuggestionCompletionEngine();
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 driverPattern = new Pattern52();
        driverPattern.setBoundName("driverPattern");
        driverPattern.setFactType("Driver");
        ConditionCol52 name = new ConditionCol52();
        name.setFactField("name");
        name.setOperator("==");
        name.setConstraintValueType(1);
        driverPattern.getChildColumns().add(name);
        ConditionCol52 ageMinimum = new ConditionCol52();
        ageMinimum.setFactField("age");
        ageMinimum.setOperator(">=");
        ageMinimum.setConstraintValueType(1);
        driverPattern.getChildColumns().add(ageMinimum);
        ConditionCol52 ageMaximum = new ConditionCol52();
        ageMaximum.setFactField("age");
        ageMaximum.setOperator("<=");
        ageMaximum.setConstraintValueType(1);
        driverPattern.getChildColumns().add(ageMaximum);
        dt.getConditions().add(driverPattern);
        ActionSetFieldCol52 message = new ActionSetFieldCol52();
        message.setBoundName("m");
        message.setFactField("message");
        dt.getActionCols().add(message);
        List<List> data = Arrays.asList(Arrays.asList(new DTCellValue52(Integer.valueOf(1)), new DTCellValue52("Row 1 description"), new DTCellValue52("Homer"), new DTCellValue52(new Integer("20")), new DTCellValue52(new Integer("50")), new DTCellValue52("Row 1 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(2)), new DTCellValue52("Row 2 description"), new DTCellValue52("Homer"), new DTCellValue52(new Integer("40")), new DTCellValue52(new Integer("30")), new DTCellValue52("Row 2 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(3)), new DTCellValue52("Row 3 description"), new DTCellValue52((String)null), new DTCellValue52(new Integer("40")), new DTCellValue52(new Integer("30")), new DTCellValue52("Row 3 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(4)), new DTCellValue52("Row 4 description"), new DTCellValue52("Homer"), new DTCellValue52(new Integer("20")), new DTCellValue52((Integer)null), new DTCellValue52("Row 4 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(5)), new DTCellValue52("Row 5 description"), new DTCellValue52((String)null), new DTCellValue52((Integer)null), new DTCellValue52((Integer)null), new DTCellValue52("Row 5 message")));
        dt.setData(data);
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(sce);
        List analysisData = analyzer.analyze(dt);
        Assert.assertEquals((long)data.size(), (long)analysisData.size());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(0)).getImpossibleMatchesSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(1)).getImpossibleMatchesSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(2)).getImpossibleMatchesSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(3)).getImpossibleMatchesSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(4)).getImpossibleMatchesSize());
    }

    @Test
    public void testImpossibleMatchesLimitedEntry() throws ParseException {
        SuggestionCompletionEngine sce = this.buildSuggestionCompletionEngine();
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 driverPattern = new Pattern52();
        driverPattern.setBoundName("driverPattern");
        driverPattern.setFactType("Driver");
        LimitedEntryConditionCol52 child = new LimitedEntryConditionCol52();
        child.setFactField("age");
        child.setOperator("<");
        child.setValue(new DTCellValue52(new Integer("18")));
        child.setConstraintValueType(1);
        driverPattern.getChildColumns().add(child);
        LimitedEntryConditionCol52 pensioner = new LimitedEntryConditionCol52();
        pensioner.setFactField("age");
        pensioner.setOperator(">=");
        pensioner.setValue(new DTCellValue52(new Integer("65")));
        pensioner.setConstraintValueType(1);
        driverPattern.getChildColumns().add(pensioner);
        dt.getConditions().add(driverPattern);
        ActionSetFieldCol52 message = new ActionSetFieldCol52();
        message.setBoundName("m");
        message.setFactField("message");
        dt.getActionCols().add(message);
        List<List> data = Arrays.asList(Arrays.asList(new DTCellValue52(Integer.valueOf(1)), new DTCellValue52("Row 1 description"), new DTCellValue52(Boolean.TRUE), new DTCellValue52(Boolean.FALSE), new DTCellValue52("Row 1 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(2)), new DTCellValue52("Row 2 description"), new DTCellValue52(Boolean.TRUE), new DTCellValue52(Boolean.TRUE), new DTCellValue52("Row 2 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(3)), new DTCellValue52("Row 3 description"), new DTCellValue52(Boolean.FALSE), new DTCellValue52(Boolean.TRUE), new DTCellValue52("Row 3 message")));
        dt.setData(data);
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(sce);
        List analysisData = analyzer.analyze(dt);
        Assert.assertEquals((long)data.size(), (long)analysisData.size());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(0)).getImpossibleMatchesSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(1)).getImpossibleMatchesSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(2)).getImpossibleMatchesSize());
    }

    @Test
    public void testConflictingMatchNumeric() throws ParseException {
        SuggestionCompletionEngine sce = this.buildSuggestionCompletionEngine();
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 driverPattern = new Pattern52();
        driverPattern.setBoundName("driverPattern");
        driverPattern.setFactType("Driver");
        ConditionCol52 ageMinimum = new ConditionCol52();
        ageMinimum.setFactField("age");
        ageMinimum.setOperator(">=");
        ageMinimum.setConstraintValueType(1);
        driverPattern.getChildColumns().add(ageMinimum);
        ConditionCol52 ageMaximum = new ConditionCol52();
        ageMaximum.setFactField("age");
        ageMaximum.setOperator("<=");
        ageMaximum.setConstraintValueType(1);
        driverPattern.getChildColumns().add(ageMaximum);
        dt.getConditions().add(driverPattern);
        ActionSetFieldCol52 message = new ActionSetFieldCol52();
        message.setBoundName("m");
        message.setFactField("message");
        dt.getActionCols().add(message);
        List<List> data = Arrays.asList(Arrays.asList(new DTCellValue52(Integer.valueOf(1)), new DTCellValue52("Row 1 description"), new DTCellValue52((Integer)null), new DTCellValue52(new Integer("20")), new DTCellValue52("Row 1 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(2)), new DTCellValue52("Row 2 description"), new DTCellValue52(new Integer("21")), new DTCellValue52(new Integer("40")), new DTCellValue52("Row 2 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(3)), new DTCellValue52("Row 3 description"), new DTCellValue52(new Integer("30")), new DTCellValue52(new Integer("60")), new DTCellValue52("Row 3 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(4)), new DTCellValue52("Row 4 description"), new DTCellValue52(new Integer("50")), new DTCellValue52((Integer)null), new DTCellValue52("Row 4 message")));
        dt.setData(data);
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(sce);
        List analysisData = analyzer.analyze(dt);
        Assert.assertEquals((long)data.size(), (long)analysisData.size());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(0)).getConflictingMatchSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(1)).getConflictingMatchSize());
        Assert.assertEquals((long)2L, (long)((Analysis)analysisData.get(2)).getConflictingMatchSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(3)).getConflictingMatchSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(0)).getDuplicatedMatchSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(1)).getDuplicatedMatchSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(2)).getDuplicatedMatchSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(3)).getDuplicatedMatchSize());
    }

    @Test
    public void testConflictingMatchCombination() throws ParseException {
        SuggestionCompletionEngine sce = this.buildSuggestionCompletionEngine();
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 driverPattern = new Pattern52();
        driverPattern.setBoundName("driverPattern");
        driverPattern.setFactType("Driver");
        ConditionCol52 ageMinimum = new ConditionCol52();
        ageMinimum.setFactField("age");
        ageMinimum.setOperator(">=");
        ageMinimum.setConstraintValueType(1);
        driverPattern.getChildColumns().add(ageMinimum);
        ConditionCol52 ageMaximum = new ConditionCol52();
        ageMaximum.setFactField("age");
        ageMaximum.setOperator("<=");
        ageMaximum.setConstraintValueType(1);
        driverPattern.getChildColumns().add(ageMaximum);
        ConditionCol52 approved = new ConditionCol52();
        approved.setFactField("approved");
        approved.setOperator("==");
        approved.setConstraintValueType(1);
        driverPattern.getChildColumns().add(approved);
        dt.getConditions().add(driverPattern);
        ActionSetFieldCol52 message = new ActionSetFieldCol52();
        message.setBoundName("m");
        message.setFactField("message");
        dt.getActionCols().add(message);
        List<List> data = Arrays.asList(Arrays.asList(new DTCellValue52(Integer.valueOf(1)), new DTCellValue52("Row 1 description"), new DTCellValue52((Integer)null), new DTCellValue52(new Integer("20")), new DTCellValue52(Boolean.TRUE), new DTCellValue52("Row 1 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(2)), new DTCellValue52("Row 2 description"), new DTCellValue52(new Integer("21")), new DTCellValue52(new Integer("40")), new DTCellValue52(Boolean.TRUE), new DTCellValue52("Row 2 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(3)), new DTCellValue52("Row 3 description"), new DTCellValue52(new Integer("41")), new DTCellValue52((Integer)null), new DTCellValue52(Boolean.TRUE), new DTCellValue52("Row 3 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(4)), new DTCellValue52("Row 4 description"), new DTCellValue52((Integer)null), new DTCellValue52(new Integer("25")), new DTCellValue52(Boolean.FALSE), new DTCellValue52("Row 4 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(5)), new DTCellValue52("Row 5 description"), new DTCellValue52(new Integer("26")), new DTCellValue52(new Integer("60")), new DTCellValue52(Boolean.FALSE), new DTCellValue52("Row 5 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(6)), new DTCellValue52("Row 6 description"), new DTCellValue52(new Integer("50")), new DTCellValue52((Integer)null), new DTCellValue52(Boolean.FALSE), new DTCellValue52("Row 6 message")));
        dt.setData(data);
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(sce);
        List analysisData = analyzer.analyze(dt);
        Assert.assertEquals((long)data.size(), (long)analysisData.size());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(0)).getConflictingMatchSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(1)).getConflictingMatchSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(2)).getConflictingMatchSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(3)).getConflictingMatchSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(4)).getConflictingMatchSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(5)).getConflictingMatchSize());
    }

    @Test
    public void testConflictingMatchLimitedEntry() throws ParseException {
        SuggestionCompletionEngine sce = this.buildSuggestionCompletionEngine();
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 driverPattern = new Pattern52();
        driverPattern.setBoundName("driverPattern");
        driverPattern.setFactType("Driver");
        LimitedEntryConditionCol52 child = new LimitedEntryConditionCol52();
        child.setFactField("age");
        child.setOperator("<");
        child.setValue(new DTCellValue52(new Integer("18")));
        child.setConstraintValueType(1);
        driverPattern.getChildColumns().add(child);
        LimitedEntryConditionCol52 adult = new LimitedEntryConditionCol52();
        adult.setFactField("age");
        adult.setOperator(">=");
        adult.setValue(new DTCellValue52(new Integer("18")));
        adult.setConstraintValueType(1);
        driverPattern.getChildColumns().add(adult);
        LimitedEntryConditionCol52 pensioner = new LimitedEntryConditionCol52();
        pensioner.setFactField("age");
        pensioner.setOperator(">=");
        pensioner.setValue(new DTCellValue52(new Integer("65")));
        pensioner.setConstraintValueType(1);
        driverPattern.getChildColumns().add(pensioner);
        dt.getConditions().add(driverPattern);
        ActionSetFieldCol52 message = new ActionSetFieldCol52();
        message.setBoundName("m");
        message.setFactField("message");
        dt.getActionCols().add(message);
        List<List> data = Arrays.asList(Arrays.asList(new DTCellValue52(Integer.valueOf(1)), new DTCellValue52("Row 1 description"), new DTCellValue52(Boolean.TRUE), new DTCellValue52(Boolean.FALSE), new DTCellValue52(Boolean.FALSE), new DTCellValue52("Row 1 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(2)), new DTCellValue52("Row 2 description"), new DTCellValue52(Boolean.FALSE), new DTCellValue52(Boolean.TRUE), new DTCellValue52(Boolean.FALSE), new DTCellValue52("Row 2 message")), Arrays.asList(new DTCellValue52(Integer.valueOf(3)), new DTCellValue52("Row 3 description"), new DTCellValue52(Boolean.FALSE), new DTCellValue52(Boolean.FALSE), new DTCellValue52(Boolean.TRUE), new DTCellValue52("Row 3 message")));
        dt.setData(data);
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(sce);
        List analysisData = analyzer.analyze(dt);
        Assert.assertEquals((long)data.size(), (long)analysisData.size());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(0)).getConflictingMatchSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(1)).getConflictingMatchSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(2)).getConflictingMatchSize());
    }

    @Test
    public void testDuplicatedMatchNumeric() throws ParseException {
        SuggestionCompletionEngine sce = this.buildSuggestionCompletionEngine();
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 driverPattern = new Pattern52();
        driverPattern.setBoundName("driverPattern");
        driverPattern.setFactType("Driver");
        ConditionCol52 ageMinimum = new ConditionCol52();
        ageMinimum.setFactField("age");
        ageMinimum.setOperator(">=");
        ageMinimum.setConstraintValueType(1);
        driverPattern.getChildColumns().add(ageMinimum);
        ConditionCol52 ageMaximum = new ConditionCol52();
        ageMaximum.setFactField("age");
        ageMaximum.setOperator("<=");
        ageMaximum.setConstraintValueType(1);
        driverPattern.getChildColumns().add(ageMaximum);
        dt.getConditions().add(driverPattern);
        ActionSetFieldCol52 message = new ActionSetFieldCol52();
        message.setBoundName("m");
        message.setFactField("message");
        dt.getActionCols().add(message);
        List<List> data = Arrays.asList(Arrays.asList(new DTCellValue52(Integer.valueOf(1)), new DTCellValue52("Row 1 description"), new DTCellValue52((Integer)null), new DTCellValue52(new Integer("20")), new DTCellValue52("Same message")), Arrays.asList(new DTCellValue52(Integer.valueOf(2)), new DTCellValue52("Row 2 description"), new DTCellValue52(new Integer("21")), new DTCellValue52(new Integer("40")), new DTCellValue52("Same message")), Arrays.asList(new DTCellValue52(Integer.valueOf(3)), new DTCellValue52("Row 3 description"), new DTCellValue52(new Integer("30")), new DTCellValue52(new Integer("60")), new DTCellValue52("Same message")), Arrays.asList(new DTCellValue52(Integer.valueOf(4)), new DTCellValue52("Row 4 description"), new DTCellValue52(new Integer("50")), new DTCellValue52((Integer)null), new DTCellValue52("Same message")));
        dt.setData(data);
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(sce);
        List analysisData = analyzer.analyze(dt);
        Assert.assertEquals((long)data.size(), (long)analysisData.size());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(0)).getDuplicatedMatchSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(1)).getDuplicatedMatchSize());
        Assert.assertEquals((long)2L, (long)((Analysis)analysisData.get(2)).getDuplicatedMatchSize());
        Assert.assertEquals((long)1L, (long)((Analysis)analysisData.get(3)).getDuplicatedMatchSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(0)).getConflictingMatchSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(1)).getConflictingMatchSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(2)).getConflictingMatchSize());
        Assert.assertEquals((long)0L, (long)((Analysis)analysisData.get(3)).getConflictingMatchSize());
    }

    private SuggestionCompletionEngine buildSuggestionCompletionEngine() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Driver", new ModelField[]{new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String"), new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Integer"), new ModelField("dateOfBirth", Date.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Date"), new ModelField("approved", Boolean.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Boolean")});
            }
        });
        return sce;
    }
}

