/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.decoratedgrid.data;

import java.util.SortedSet;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.BaseDynamicDataTests;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.RowMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DynamicDataRowMapperTests
extends BaseDynamicDataTests {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.data.addRow(this.makeRow());
        this.data.addRow(this.makeRow());
        this.data.addRow(this.makeRow());
        this.data.addRow(this.makeRow());
        this.data.addRow(this.makeRow());
        this.data.get(0).get(0).setValue((Object)"-");
        this.data.get(0).get(1).setValue((Object)"-");
        this.data.get(0).get(2).setValue((Object)"-");
        this.data.get(1).get(0).setValue((Object)"1");
        this.data.get(1).get(1).setValue((Object)"1");
        this.data.get(1).get(2).setValue((Object)"1");
        this.data.get(2).get(0).setValue((Object)"1");
        this.data.get(2).get(1).setValue((Object)"1");
        this.data.get(2).get(2).setValue((Object)"1");
        this.data.get(3).get(0).setValue((Object)"1");
        this.data.get(3).get(1).setValue((Object)"1");
        this.data.get(3).get(2).setValue((Object)"1");
        this.data.get(4).get(0).setValue((Object)"2");
        this.data.get(4).get(1).setValue((Object)"2");
        this.data.get(4).get(2).setValue((Object)"2");
        this.data.get(5).get(0).setValue((Object)"2");
        this.data.get(5).get(1).setValue((Object)"2");
        this.data.get(5).get(2).setValue((Object)"2");
        this.data.get(6).get(0).setValue((Object)"2");
        this.data.get(6).get(1).setValue((Object)"2");
        this.data.get(6).get(2).setValue((Object)"2");
        this.data.get(7).get(0).setValue((Object)"-");
        this.data.get(7).get(1).setValue((Object)"-");
        this.data.get(7).get(2).setValue((Object)"-");
    }

    @Test
    public void testMapToMergedRow() {
        RowMapper rowMapper = new RowMapper(this.data);
        CellValue cv = this.data.get(1).get(0);
        this.data.setMerged(true);
        this.data.applyModelGrouping(cv);
        Assert.assertEquals((long)0L, (long)rowMapper.mapToMergedRow(0));
        Assert.assertEquals((long)1L, (long)rowMapper.mapToMergedRow(1));
        Assert.assertEquals((long)1L, (long)rowMapper.mapToMergedRow(2));
        Assert.assertEquals((long)1L, (long)rowMapper.mapToMergedRow(3));
        Assert.assertEquals((long)2L, (long)rowMapper.mapToMergedRow(4));
        Assert.assertEquals((long)3L, (long)rowMapper.mapToMergedRow(5));
        Assert.assertEquals((long)4L, (long)rowMapper.mapToMergedRow(6));
        Assert.assertEquals((long)5L, (long)rowMapper.mapToMergedRow(7));
    }

    @Test
    public void testMapToAbsoluteRow() {
        RowMapper rowMapper = new RowMapper(this.data);
        CellValue cv = this.data.get(1).get(0);
        this.data.setMerged(true);
        this.data.applyModelGrouping(cv);
        Assert.assertEquals((long)0L, (long)rowMapper.mapToAbsoluteRow(0));
        Assert.assertEquals((long)1L, (long)rowMapper.mapToAbsoluteRow(1));
        Assert.assertEquals((long)4L, (long)rowMapper.mapToAbsoluteRow(2));
        Assert.assertEquals((long)5L, (long)rowMapper.mapToAbsoluteRow(3));
        Assert.assertEquals((long)6L, (long)rowMapper.mapToAbsoluteRow(4));
        Assert.assertEquals((long)7L, (long)rowMapper.mapToAbsoluteRow(5));
    }

    @Test
    public void testMapToAllAbsoluteRows() {
        RowMapper rowMapper = new RowMapper(this.data);
        CellValue cv = this.data.get(1).get(0);
        this.data.setMerged(true);
        this.data.applyModelGrouping(cv);
        SortedSet results = rowMapper.mapToAllAbsoluteRows(0);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(0));
        results = rowMapper.mapToAllAbsoluteRows(1);
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(1));
        Assert.assertTrue((boolean)results.contains(2));
        Assert.assertTrue((boolean)results.contains(3));
        results = rowMapper.mapToAllAbsoluteRows(2);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(4));
        results = rowMapper.mapToAllAbsoluteRows(3);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(5));
        results = rowMapper.mapToAllAbsoluteRows(4);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(6));
        results = rowMapper.mapToAllAbsoluteRows(5);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(7));
    }
}

