/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.gwtutil;

import java.io.InputStream;
import java.util.List;
import org.drools.guvnor.server.util.ModuleEditorConfiguration;
import org.drools.guvnor.server.util.PerspectiveConfigurationParser;
import org.junit.Assert;
import org.junit.Test;

public class PerspectiveConfigurationParserTest {
    @Test
    public void testReadConfig() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("/org/drools/guvnor/gwtutil/perspective.xml");
        PerspectiveConfigurationParser a = new PerspectiveConfigurationParser(in);
        List configList = a.getModuleEditors();
        Assert.assertEquals((long)2L, (long)configList.size());
        boolean foundPackageModuleEditor = false;
        boolean foundSOAServiceModuleEditor = false;
        for (ModuleEditorConfiguration config : configList) {
            if (config.getFormat().equalsIgnoreCase("package")) {
                Assert.assertEquals((Object)"org.drools.guvnor.client.moduleeditor.drools.PackageEditor", (Object)config.getEditorClass());
                Assert.assertEquals((Object)"brl,dslr,xls", (Object)config.getAssetEditorFormats());
                foundPackageModuleEditor = true;
            }
            if (!config.getFormat().equalsIgnoreCase("soaservice")) continue;
            Assert.assertEquals((Object)"org.drools.guvnor.client.moduleeditor.soa.SOAServiceEditor", (Object)config.getEditorClass());
            Assert.assertEquals((Object)"brl", (Object)config.getAssetEditorFormats());
            foundSOAServiceModuleEditor = true;
        }
        Assert.assertTrue((boolean)foundPackageModuleEditor);
        Assert.assertTrue((boolean)foundSOAServiceModuleEditor);
    }
}

