/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.RangeIterator;
import javax.jcr.Session;
import org.drools.guvnor.client.rpc.CategoryPageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.server.RepositoryCategoryOperations;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemPageResult;
import org.drools.repository.CategoryItem;
import org.drools.repository.RulesRepository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class RepositoryCategoryOperationsTest {
    private final RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
    private final RepositoryCategoryOperations repositoryCategoryOperations = new RepositoryCategoryOperations();

    @Before
    public void setUp() {
        this.repositoryCategoryOperations.setRulesRepositoryForTest(this.rulesRepository);
    }

    @Test
    public void testLoadChildCategories() {
        CategoryItem categoryItem = (CategoryItem)Mockito.mock(CategoryItem.class);
        Mockito.when((Object)this.rulesRepository.loadCategory("categorypath")).thenReturn((Object)categoryItem);
        ArrayList<CategoryItem> childTags = new ArrayList<CategoryItem>();
        CategoryItem categoryItemNode = (CategoryItem)Mockito.mock(CategoryItem.class);
        childTags.add(categoryItemNode);
        Mockito.when((Object)categoryItemNode.getName()).thenReturn((Object)"categoryNodeName");
        Mockito.when((Object)categoryItem.getChildTags()).thenReturn(childTags);
        Assert.assertArrayEquals((Object[])this.repositoryCategoryOperations.loadChildCategories("categorypath"), (Object[])new String[]{"categoryNodeName"});
    }

    @Test
    public void testCreateCategoryWhenPathIncludingHtml() {
        this.testAndVerifyCreateCategory("<path>", "&lt;path&gt;");
    }

    @Test
    public void testCreateCategoryWhenPathIsNull() {
        this.testAndVerifyCreateCategory(null, "/");
    }

    @Test
    public void testCreateCategoryWhenPathIsEmpty() {
        this.testAndVerifyCreateCategory("", "/");
    }

    public void testAndVerifyCreateCategory(String createPath, String loadPath) {
        this.initSession();
        CategoryItem categoryItem = (CategoryItem)Mockito.mock(CategoryItem.class);
        Mockito.when((Object)this.rulesRepository.loadCategory(loadPath)).thenReturn((Object)categoryItem);
        this.repositoryCategoryOperations.createCategory(createPath, "name", "description");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).loadCategory(loadPath);
        ((CategoryItem)Mockito.verify((Object)categoryItem)).addCategory("name", "description");
    }

    @Test
    public void testRenameCategory() {
        this.repositoryCategoryOperations.renameCategory("orig", "new");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).renameCategory("orig", "new");
    }

    @Test
    public void testLoadRuleListForCategories() throws SerializationException {
        CategoryPageRequest categoryPageRequest = new CategoryPageRequest("/path", 0, new Integer(10));
        RangeIterator rangeIterator = (RangeIterator)Mockito.mock(RangeIterator.class);
        Mockito.when((Object)rangeIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)rangeIterator.getPosition()).thenReturn((Object)1L);
        AssetItemPageResult assetItemPageResult = new AssetItemPageResult(Arrays.asList((AssetItem)Mockito.mock(AssetItem.class, (Answer)Mockito.RETURNS_MOCKS)), 1L, false);
        Mockito.when((Object)this.rulesRepository.findAssetsByCategory(categoryPageRequest.getCategoryPath(), false, categoryPageRequest.getStartRowIndex(), 10)).thenReturn((Object)assetItemPageResult);
        PageResponse loadRuleListForCategories = this.repositoryCategoryOperations.loadRuleListForCategories(categoryPageRequest);
        Assert.assertNotNull((Object)loadRuleListForCategories);
        Assert.assertEquals((long)loadRuleListForCategories.getStartRowIndex(), (long)categoryPageRequest.getStartRowIndex());
        Assert.assertNotNull((Object)loadRuleListForCategories.getPageRowList());
        Assert.assertEquals((long)loadRuleListForCategories.getPageRowList().size(), (long)1L);
        Assert.assertEquals((Object)loadRuleListForCategories.isLastPage(), (Object)true);
    }

    @Test
    public void testRemoveCategory() throws SerializationException {
        this.initSession();
        CategoryItem categoryItem = (CategoryItem)Mockito.mock(CategoryItem.class);
        Mockito.when((Object)this.rulesRepository.loadCategory("/path")).thenReturn((Object)categoryItem);
        this.repositoryCategoryOperations.removeCategory("/path");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).loadCategory("/path");
        ((CategoryItem)Mockito.verify((Object)categoryItem)).remove();
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).save();
    }

    private void initSession() {
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)this.rulesRepository.getSession()).thenReturn((Object)session);
    }
}

