/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.CategoryPageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleBasedPermissionManager;
import org.drools.guvnor.server.security.RoleBasedPermissionResolver;
import org.drools.guvnor.server.security.RoleBasedPermissionStore;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.ModuleItem;
import org.junit.Assert;
import org.junit.Test;

public class RepositoryCategoryServiceIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private RoleBasedPermissionStore roleBasedPermissionStore;
    @Inject
    private RoleBasedPermissionManager roleBasedPermissionManager;
    @Inject
    private RoleBasedPermissionResolver roleBasedPermissionResolver;

    public RepositoryCategoryServiceIntegrationTest() {
        this.autoLoginAsAdmin = false;
    }

    @Test
    public void testRemoveCategory() throws Exception {
        this.loginAs("admin");
        String[] children = this.repositoryCategoryService.loadChildCategories("/");
        this.repositoryCategoryService.createCategory("/", "testRemoveCategory", "foo");
        this.repositoryCategoryService.removeCategory("testRemoveCategory");
        String[] _children = this.repositoryCategoryService.loadChildCategories("/");
        Assert.assertEquals((long)children.length, (long)_children.length);
        this.logoutAs("admin");
    }

    @Test
    public void testAddCategories() throws Exception {
        this.loginAs("admin");
        this.rulesRepository.createModule("testAddCategoriesPackage", "desc");
        this.repositoryCategoryService.createCategory("", "testAddCategoriesCat1", "this is a cat");
        this.repositoryCategoryService.createCategory("", "testAddCategoriesCat2", "this is a cat");
        String uuid = this.serviceImplementation.createNewRule("testCreateNewRuleName", "an initial desc", "testAddCategoriesCat1", "testAddCategoriesPackage", "dslr");
        AssetItem dtItem = this.rulesRepository.loadAssetByUUID(uuid);
        dtItem.addCategory("testAddCategoriesCat1");
        this.rulesRepository.save();
        AssetItem dtItem1 = this.rulesRepository.loadAssetByUUID(uuid);
        Assert.assertEquals((long)1L, (long)dtItem1.getCategories().size());
        Assert.assertTrue((boolean)dtItem1.getCategorySummary().contains("testAddCategoriesCat1"));
        AssetItem dtItem2 = this.rulesRepository.loadAssetByUUID(uuid);
        dtItem2.addCategory("testAddCategoriesCat2");
        this.rulesRepository.save();
        AssetItem dtItem3 = this.rulesRepository.loadAssetByUUID(uuid);
        Assert.assertEquals((long)2L, (long)dtItem3.getCategories().size());
        Assert.assertTrue((boolean)dtItem3.getCategorySummary().contains("testAddCategoriesCat2"));
        this.logoutAs("admin");
    }

    @Test
    public void testLoadRuleListForCategoryPagedResultsCategory() throws Exception {
        this.loginAs("admin");
        String[] originalCats = this.repositoryCategoryService.loadChildCategories("/");
        Boolean result = this.repositoryCategoryService.createCategory("/", "TopLevel1", "a description");
        Assert.assertTrue((boolean)result);
        result = this.repositoryCategoryService.createCategory("/", "TopLevel2", "a description");
        Assert.assertTrue((boolean)result);
        String[] cats = this.repositoryCategoryService.loadChildCategories("/");
        Assert.assertTrue((cats.length == originalCats.length + 2 ? 1 : 0) != 0);
        result = this.repositoryCategoryService.createCategory("", "Top3", "description");
        Assert.assertTrue((boolean)result);
        result = this.repositoryCategoryService.createCategory(null, "Top4", "description");
        Assert.assertTrue((boolean)result);
        this.logoutAs("admin");
    }

    @Test
    public void testLoadRuleListForCategoryPagedResults() throws Exception {
        this.loginAs("admin");
        int PAGE_SIZE = 2;
        String cat = "testLoadRuleListForCategoryPagedResultsCategory";
        this.repositoryCategoryService.createCategory("/", cat, "testCategoryDescription");
        this.repositoryPackageService.createModule("testLoadRuleListForCategoryPagedResultsCategoryPackage", "testLoadRuleListForCategoryPagedResultsCategoryPackageDescription", "package");
        this.serviceImplementation.createNewRule("testTextRule1", "testLoadRuleListForCategoryPagedResultsCategoryRule1", cat, "testLoadRuleListForCategoryPagedResultsCategoryPackage", "drl");
        this.serviceImplementation.createNewRule("testTextRule2", "testLoadRuleListForCategoryPagedResultsCategoryRule2", cat, "testLoadRuleListForCategoryPagedResultsCategoryPackage", "drl");
        this.serviceImplementation.createNewRule("testTextRule3", "testLoadRuleListForCategoryPagedResultsCategoryRule3", cat, "testLoadRuleListForCategoryPagedResultsCategoryPackage", "drl");
        CategoryPageRequest request = new CategoryPageRequest(cat, 0, Integer.valueOf(2));
        PageResponse response = this.repositoryCategoryService.loadRuleListForCategories(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.repositoryCategoryService.loadRuleListForCategories(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isLastPage());
        this.logoutAs("admin");
    }

    @Test
    public void testLoadRuleListForCategoryFullResults() throws Exception {
        this.loginAs("admin");
        String cat = "testLoadRuleListForCategoryFullResultsCategory";
        this.repositoryCategoryService.createCategory("/", cat, "testLoadRuleListForCategoryFullResultsCategoryDescription");
        this.repositoryPackageService.createModule("testLoadRuleListForCategoryFullResultsCategoryPackage", "testLoadRuleListForCategoryFullResultsCategoryPackageDescription", "package");
        this.serviceImplementation.createNewRule("testTextRule1", "testLoadRuleListForCategoryFullResultsCategoryRule1", cat, "testLoadRuleListForCategoryFullResultsCategoryPackage", "drl");
        this.serviceImplementation.createNewRule("testTextRule2", "testLoadRuleListForCategoryFullResultsCategoryRule2", cat, "testLoadRuleListForCategoryFullResultsCategoryPackage", "drl");
        this.serviceImplementation.createNewRule("testTextRule3", "testLoadRuleListForCategoryFullResultsCategoryRule3", cat, "testLoadRuleListForCategoryFullResultsCategoryPackage", "drl");
        CategoryPageRequest request = new CategoryPageRequest(cat, 0, null);
        PageResponse response = this.repositoryCategoryService.loadRuleListForCategories(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isLastPage());
        this.logoutAs("admin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testLoadRuleListForCategoriesWithAnalystPermission() throws SerializationException {
        this.loginAs("admin");
        CategoryItem rootCategory = this.rulesRepository.loadCategory("/");
        CategoryItem cat = rootCategory.addCategory("testLoadRuleListForCategoriesWithAnalystPermissionRootCat", "description");
        cat.addCategory("testLoadRuleListForCategoriesWithAnalystPermissionCat1", "yeah");
        cat.addCategory("testLoadRuleListForCategoriesWithAnalystPermissionCat2", "yeah");
        this.logoutAs("admin");
        String USERNAME = "categoryUser";
        this.loginAs("categoryUser");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting("categoryUser", new RoleBasedPermission("categoryUser", RoleType.ANALYST.getName(), null, "/testLoadRuleListForCategoriesWithAnalystPermissionRootCat"));
        this.roleBasedPermissionManager.create();
        RuntimeException failingException = null;
        ModuleItem pkg = this.rulesRepository.createModule("testLoadRuleListForCategoriesWithAnalystPermission", "");
        AssetItem asset = pkg.addAsset("testLoadRuleListForCategoriesWithAnalystPermission1", "", "/testLoadRuleListForCategoriesWithAnalystPermissionRootCat/testLoadRuleListForCategoriesWithAnalystPermissionCat1", null);
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        asset = pkg.addAsset("testLoadRuleListForCategoriesWithAnalystPermission2", "", "/testLoadRuleListForCategoriesWithAnalystPermissionRootCat", null);
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        asset = pkg.addAsset("testLoadRuleListForCategoriesWithAnalystPermission3", "", "/testLoadRuleListForCategoriesWithAnalystPermissionRootCat", null);
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        asset = pkg.addAsset("testLoadRuleListForCategoriesWithAnalystPermission4", "", "/testLoadRuleListForCategoriesWithAnalystPermissionRootCat/testLoadRuleListForCategoriesWithAnalystPermissionCat1", null);
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        asset = pkg.addAsset("testLoadRuleListForCategoriesWithAnalystPermission5", "", "/testLoadRuleListForCategoriesWithAnalystPermissionRootCat", null);
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        CategoryPageRequest request = new CategoryPageRequest("/testLoadRuleListForCategoriesWithAnalystPermissionRootCat", 0, new Integer(2));
        PageResponse response = this.repositoryCategoryService.loadRuleListForCategories(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.repositoryCategoryService.loadRuleListForCategories(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)2L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
        Assert.assertEquals((Object)true, (Object)response.isTotalRowSizeExact());
        Assert.assertEquals((long)3L, (long)response.getTotalRowSize());
        Assert.assertTrue((boolean)response.isLastPage());
        try {
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting("categoryUser");
            try {
                this.logoutAs("categoryUser");
            }
            catch (IllegalStateException ise) {}
        }
        catch (RuntimeException e) {
            throw failingException != null ? failingException : e;
        }
        catch (RuntimeException e) {
            try {
                failingException = e;
            }
            catch (Throwable throwable) {
                try {
                    this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
                    this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting("categoryUser");
                    try {
                        this.logoutAs("categoryUser");
                    }
                    catch (IllegalStateException ise) {}
                }
                catch (RuntimeException e2) {
                    throw failingException != null ? failingException : e2;
                }
                throw throwable;
            }
            try {
                this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
                this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting("categoryUser");
                try {
                    this.logoutAs("categoryUser");
                }
                catch (IllegalStateException ise) {}
            }
            catch (RuntimeException e3) {
                throw failingException != null ? failingException : e3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testLoadRuleListForCategoriesWithAnalystNoRootCatPermission() throws SerializationException {
        this.loginAs("admin");
        CategoryItem rootCategory = this.rulesRepository.loadCategory("/");
        CategoryItem cat = rootCategory.addCategory("testLoadRuleListForCategoriesWithAnalystNoRootCatPermission", "description");
        cat.addCategory("testLoadRuleListForCategoriesWithAnalystNoRootCatPermissionCat1", "yeah");
        cat.addCategory("testLoadRuleListForCategoriesWithAnalystNoRootCatPermissionCat2", "yeah");
        this.logoutAs("admin");
        String USERNAME = "categoryUser";
        this.loginAs("categoryUser");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting("categoryUser", new RoleBasedPermission("categoryUser", RoleType.ANALYST.getName(), null, "/testLoadRuleListForCategoriesWithAnalystNoRootCatPermission/testLoadRuleListForCategoriesWithAnalystNoRootCatPermissionCat1"));
        this.roleBasedPermissionManager.create();
        RuntimeException failingException = null;
        ModuleItem pkg = this.rulesRepository.createModule("testLoadRuleListForCategoriesWithAnalystNoRootCatPermission", "");
        AssetItem asset = pkg.addAsset("testLoadRuleListForCategoriesWithAnalystNoRootCatPermission1", "", "/testLoadRuleListForCategoriesWithAnalystNoRootCatPermission/testLoadRuleListForCategoriesWithAnalystNoRootCatPermissionCat1", null);
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        asset = pkg.addAsset("testLoadRuleListForCategoriesWithAnalystNoRootCatPermission2", "", "/testLoadRuleListForCategoriesWithAnalystNoRootCatPermission", null);
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        asset = pkg.addAsset("testLoadRuleListForCategoriesWithAnalystNoRootCatPermission3", "", "/testLoadRuleListForCategoriesWithAnalystNoRootCatPermission", null);
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        asset = pkg.addAsset("testLoadRuleListForCategoriesWithAnalystNoRootCatPermission4", "", "/testLoadRuleListForCategoriesWithAnalystNoRootCatPermission/testLoadRuleListForCategoriesWithAnalystNoRootCatPermissionCat1", null);
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        asset = pkg.addAsset("testLoadRuleListForCategoriesWithAnalystNoRootCatPermission5", "", "/testLoadRuleListForCategoriesWithAnalystNoRootCatPermission", null);
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        CategoryPageRequest request = new CategoryPageRequest("/testLoadRuleListForCategoriesWithAnalystNoRootCatPermission", 0, new Integer(2));
        PageResponse response = this.repositoryCategoryService.loadRuleListForCategories(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)0L, (long)response.getPageRowList().size());
        Assert.assertEquals((Object)true, (Object)response.isTotalRowSizeExact());
        Assert.assertEquals((long)0L, (long)response.getTotalRowSize());
        Assert.assertTrue((boolean)response.isLastPage());
        try {
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting("categoryUser");
            try {
                this.logoutAs("categoryUser");
            }
            catch (IllegalStateException ise) {}
        }
        catch (RuntimeException e) {
            throw failingException != null ? failingException : e;
        }
        catch (RuntimeException e) {
            try {
                failingException = e;
            }
            catch (Throwable throwable) {
                try {
                    this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
                    this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting("categoryUser");
                    try {
                        this.logoutAs("categoryUser");
                    }
                    catch (IllegalStateException ise) {}
                }
                catch (RuntimeException e2) {
                    throw failingException != null ? failingException : e2;
                }
                throw throwable;
            }
            try {
                this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
                this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting("categoryUser");
                try {
                    this.logoutAs("categoryUser");
                }
                catch (IllegalStateException ise) {}
            }
            catch (RuntimeException e3) {
                throw failingException != null ? failingException : e3;
            }
        }
    }
}

