/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.server.DroolsServiceImplementation;
import org.drools.guvnor.server.RepositoryModuleOperations;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.builder.ModuleAssembler;
import org.drools.guvnor.server.builder.PackageAssembler;
import org.drools.guvnor.server.util.BRMSSuggestionCompletionLoader;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RepositoryPackageOperationsTest {
    private final RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
    private final RepositoryModuleOperations repositoryPackageOperations = new RepositoryModuleOperations();

    @Before
    public void setUp() {
        this.repositoryPackageOperations.setRulesRepositoryForTest(this.rulesRepository);
    }

    @Test
    public void testPackageNameSorting() {
        Module c1 = new Module("org.foo");
        Module c2 = new Module("org.foo.bar");
        ArrayList<Module> ls = new ArrayList<Module>();
        ls.add(c2);
        ls.add(c1);
        this.repositoryPackageOperations.sortModules(ls);
        Assert.assertEquals((Object)c1, ls.get(0));
        Assert.assertEquals((Object)c2, ls.get(1));
    }

    @Test
    public void testLoadGlobalPackageAndDependenciesAreNotFetched() {
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)this.rulesRepository.loadGlobalArea()).thenReturn((Object)packageItem);
        this.prepareMockForPackageConfigDataFactory(packageItem);
        Assert.assertNull((Object)this.repositoryPackageOperations.loadGlobalModule().getDependencies());
    }

    @Test
    public void testLoadGlobalPackageAndIsSnapshot() {
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)this.rulesRepository.loadGlobalArea()).thenReturn((Object)packageItem);
        this.preparePackageItemMockDates(packageItem);
        Mockito.when((Object)packageItem.isSnapshot()).thenReturn((Object)true);
        Mockito.when((Object)packageItem.getSnapshotName()).thenReturn((Object)"snapshotName123");
        Assert.assertTrue((boolean)this.repositoryPackageOperations.loadGlobalModule().isSnapshot());
        Assert.assertEquals((Object)this.repositoryPackageOperations.loadGlobalModule().getSnapshotName(), (Object)"snapshotName123");
    }

    @Test
    public void testLoadGlobalPackageAndIsNotSnapshot() {
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)this.rulesRepository.loadGlobalArea()).thenReturn((Object)packageItem);
        this.preparePackageItemMockDates(packageItem);
        Mockito.when((Object)packageItem.isSnapshot()).thenReturn((Object)false);
        Mockito.when((Object)packageItem.getSnapshotName()).thenReturn((Object)"snapshotName123");
        Assert.assertFalse((boolean)this.repositoryPackageOperations.loadGlobalModule().isSnapshot());
        Assert.assertNull((Object)this.repositoryPackageOperations.loadGlobalModule().getSnapshotName());
    }

    @Test
    public void testCopyPackage() throws SerializationException {
        this.initSession();
        ModuleItem mockModule = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)this.rulesRepository.loadModuleByUUID("newUUID")).thenReturn((Object)mockModule);
        AssetItemIterator assetIterator = (AssetItemIterator)Mockito.mock(AssetItemIterator.class);
        Mockito.when((Object)mockModule.listAssetsByFormat(new String[]{Mockito.anyString(), Mockito.anyString(), Mockito.anyString()})).thenReturn((Object)assetIterator);
        Mockito.when((Object)this.rulesRepository.copyModule("from", "to")).thenReturn((Object)"newUUID");
        this.repositoryPackageOperations.copyModules("from", "to");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).copyModule("from", "to");
    }

    @Test
    public void testRemovePackage() throws SerializationException {
        this.initSession();
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)this.rulesRepository.loadModuleByUUID("uuid")).thenReturn((Object)packageItem);
        this.repositoryPackageOperations.removeModule("uuid");
        ((ModuleItem)Mockito.verify((Object)packageItem)).remove();
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).save();
    }

    @Test
    public void testRenamePackage() throws SerializationException {
        this.initSession();
        ModuleItem mockModule = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)this.rulesRepository.loadModuleByUUID("old")).thenReturn((Object)mockModule);
        AssetItemIterator assetIterator = (AssetItemIterator)Mockito.mock(AssetItemIterator.class);
        Mockito.when((Object)mockModule.listAssetsByFormat(new String[]{Mockito.anyString(), Mockito.anyString(), Mockito.anyString()})).thenReturn((Object)assetIterator);
        this.repositoryPackageOperations.renameModule("old", "new");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).renameModule("old", "new");
    }

    @Test
    public void testExportPackages() throws PathNotFoundException, IOException, RepositoryException {
        this.initSession();
        this.repositoryPackageOperations.exportModules("packageName");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).dumpModuleFromRepositoryXml("packageName");
    }

    @Test
    public void testImportPackages() {
        this.repositoryPackageOperations.importPackages(new byte[0], false);
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).importPackageToRepository(new byte[0], false);
    }

    @Test
    public void testCreatePackage() {
        this.initSession();
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)packageItem.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.rulesRepository.createModule("name", "description", "package", new String[]{"workspace"}, "Initial")).thenReturn((Object)packageItem);
        Assert.assertEquals((Object)this.repositoryPackageOperations.createModule("name", "description", "package", new String[]{"workspace"}), (Object)"uuid");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).createModule("name", "description", "package", new String[]{"workspace"}, "Initial");
    }

    @Test
    public void testSubCreatePackage() throws SerializationException {
        this.initSession();
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)packageItem.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.rulesRepository.createSubModule("name", "description", "parentNode")).thenReturn((Object)packageItem);
        Assert.assertEquals((Object)this.repositoryPackageOperations.createSubModule("name", "description", "parentNode"), (Object)"uuid");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).createSubModule("name", "description", "parentNode");
    }

    @Test
    public void testLoadPackageConfigWithDependencies() {
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)this.rulesRepository.loadGlobalArea()).thenReturn((Object)packageItem);
        this.prepareMockForPackageConfigDataFactory(packageItem);
        Assert.assertNotNull((Object)this.repositoryPackageOperations.loadModule(packageItem).getDependencies());
    }

    @Test
    public void testSavePackageArhived() throws SerializationException {
        RepositoryModuleOperations localRepositoryPackageOperations = this.initSpyingOnRealRepositoryPackageOperations();
        Module packageConfigData = this.createPackageConfigData(false);
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Calendar calendar = GregorianCalendar.getInstance();
        Mockito.when((Object)packageItem.getLastModified()).thenReturn((Object)calendar);
        this.initDroolsHeaderCheck(packageItem);
        Mockito.when((Object)packageItem.isArchived()).thenReturn((Object)true);
        Mockito.when((Object)this.rulesRepository.loadModule(packageConfigData.getName())).thenReturn((Object)packageItem);
        ((RepositoryModuleOperations)Mockito.doNothing().when((Object)localRepositoryPackageOperations)).updateCategoryRules(packageConfigData, packageItem);
        ((RepositoryModuleOperations)Mockito.doNothing().when((Object)localRepositoryPackageOperations)).handleUnarchivedForSaveModule(packageConfigData, packageItem, calendar);
        localRepositoryPackageOperations.saveModule(packageConfigData);
        ((ModuleItem)Mockito.verify((Object)packageItem)).updateExternalURI(packageConfigData.getExternalURI());
        ((ModuleItem)Mockito.verify((Object)packageItem)).updateDescription(packageConfigData.getDescription());
        ((ModuleItem)Mockito.verify((Object)packageItem)).archiveItem(packageConfigData.isArchived());
        ((ModuleItem)Mockito.verify((Object)packageItem)).checkin(packageConfigData.getDescription());
        ((RepositoryModuleOperations)Mockito.verify((Object)localRepositoryPackageOperations)).handleUnarchivedForSaveModule(packageConfigData, packageItem, calendar);
    }

    @Test
    public void testSavePackageUnarhived() throws SerializationException {
        RepositoryModuleOperations localRepositoryPackageOperations = this.initSpyingOnRealRepositoryPackageOperations();
        Module packageConfigData = this.createPackageConfigData(true);
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        this.initDroolsHeaderCheck(packageItem);
        Mockito.when((Object)packageItem.isArchived()).thenReturn((Object)false);
        Mockito.when((Object)this.rulesRepository.loadModule(packageConfigData.getName())).thenReturn((Object)packageItem);
        ((RepositoryModuleOperations)Mockito.doNothing().when((Object)localRepositoryPackageOperations)).updateCategoryRules(packageConfigData, packageItem);
        ((RepositoryModuleOperations)Mockito.doNothing().when((Object)localRepositoryPackageOperations)).handleArchivedForSaveModule(packageConfigData, packageItem);
        localRepositoryPackageOperations.saveModule(packageConfigData);
        ((ModuleItem)Mockito.verify((Object)packageItem)).updateExternalURI(packageConfigData.getExternalURI());
        ((ModuleItem)Mockito.verify((Object)packageItem)).updateDescription(packageConfigData.getDescription());
        ((ModuleItem)Mockito.verify((Object)packageItem)).archiveItem(packageConfigData.isArchived());
        ((ModuleItem)Mockito.verify((Object)packageItem)).checkin(packageConfigData.getDescription());
        ((RepositoryModuleOperations)Mockito.verify((Object)localRepositoryPackageOperations)).handleArchivedForSaveModule(packageConfigData, packageItem);
    }

    @Test
    public void testValidatePackageConfiguration() throws SerializationException {
        RepositoryModuleOperations localRepositoryPackageOperations = this.initSpyingOnRealRepositoryPackageOperations();
        Module packageConfigData = this.createPackageConfigData(true);
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        this.initDroolsHeaderCheck(packageItem);
        Mockito.when((Object)packageItem.isArchived()).thenReturn((Object)false);
        Mockito.when((Object)this.rulesRepository.loadModule(packageConfigData.getName())).thenReturn((Object)packageItem);
        ((RepositoryModuleOperations)Mockito.doNothing().when((Object)localRepositoryPackageOperations)).updateCategoryRules(packageConfigData, packageItem);
        ((RepositoryModuleOperations)Mockito.doNothing().when((Object)localRepositoryPackageOperations)).handleArchivedForSaveModule(packageConfigData, packageItem);
        ServiceSecurity serviceSecurity = (ServiceSecurity)Mockito.mock(ServiceSecurity.class);
        DroolsServiceImplementation droolsServiceImplementation = (DroolsServiceImplementation)Mockito.spy((Object)new DroolsServiceImplementation(this.rulesRepository, serviceSecurity));
        this.initSpyingAndMockingOnSuggestionCompletionLoader(droolsServiceImplementation);
        droolsServiceImplementation.validateModule(packageConfigData);
        ((ModuleItem)Mockito.verify((Object)packageItem, (VerificationMode)Mockito.never())).updateExternalURI("");
        ((ModuleItem)Mockito.verify((Object)packageItem, (VerificationMode)Mockito.never())).updateDescription(packageConfigData.getDescription());
        ((ModuleItem)Mockito.verify((Object)packageItem, (VerificationMode)Mockito.never())).archiveItem(packageConfigData.isArchived());
        ((ModuleItem)Mockito.verify((Object)packageItem, (VerificationMode)Mockito.never())).checkin(packageConfigData.getDescription());
        ((RepositoryModuleOperations)Mockito.verify((Object)localRepositoryPackageOperations, (VerificationMode)Mockito.never())).handleArchivedForSaveModule(packageConfigData, packageItem);
    }

    @Test
    public void testCreatePackageSnapshotAndReplacingExisting() throws SerializationException {
        this.initSession();
        String packageName = "packageName";
        String snapshotName = "snapshotName";
        String comment = "comment";
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)this.rulesRepository.containsSnapshot("packageName", "snapshotName")).thenReturn((Object)true);
        Mockito.when((Object)this.rulesRepository.loadModuleSnapshot("packageName", "snapshotName")).thenReturn((Object)packageItem);
        this.repositoryPackageOperations.createModuleSnapshot("packageName", "snapshotName", true, "comment");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).removeModuleSnapshot("packageName", "snapshotName");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).createModuleSnapshot("packageName", "snapshotName");
        ((ModuleItem)Mockito.verify((Object)packageItem)).updateCheckinComment("comment");
    }

    @Test
    public void testCreatePackageSnapshotAndNotReplacingExisting() throws SerializationException {
        this.initSession();
        String packageName = "packageName";
        String snapshotName = "snapshotName";
        String comment = "comment";
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)this.rulesRepository.loadModuleSnapshot("packageName", "snapshotName")).thenReturn((Object)packageItem);
        this.repositoryPackageOperations.createModuleSnapshot("packageName", "snapshotName", false, "comment");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository, (VerificationMode)Mockito.never())).removeModuleSnapshot("packageName", "snapshotName");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).createModuleSnapshot("packageName", "snapshotName");
        ((ModuleItem)Mockito.verify((Object)packageItem)).updateCheckinComment("comment");
    }

    @Test
    public void testCopyOrRemoveSnapshotAndRemoving() throws SerializationException {
        this.initSession();
        String packageName = "packageName";
        String snapshotName = "snapshotName";
        String newSnapshotName = "newSnapshotName";
        this.repositoryPackageOperations.copyOrRemoveSnapshot("packageName", "snapshotName", true, "newSnapshotName");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).removeModuleSnapshot("packageName", "snapshotName");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository, (VerificationMode)Mockito.never())).copyModuleSnapshot("packageName", "snapshotName", "newSnapshotName");
    }

    @Test
    public void testCopyOrRemoveSnapshotAndCopying() throws SerializationException {
        this.initSession();
        String packageName = "packageName";
        String snapshotName = "snapshotName";
        String newSnapshotName = "newSnapshotName";
        this.repositoryPackageOperations.copyOrRemoveSnapshot("packageName", "snapshotName", false, "newSnapshotName");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository, (VerificationMode)Mockito.never())).removeModuleSnapshot("packageName", "snapshotName");
        ((RulesRepository)Mockito.verify((Object)this.rulesRepository)).copyModuleSnapshot("packageName", "snapshotName", "newSnapshotName");
    }

    @Test
    @Ignore(value="This test does not test anything useful.Move the test to Arquillian or remove this test.")
    public void testListRulesInPackageAndtDRLMissing() throws DroolsParserException, SerializationException {
        RepositoryModuleOperations localRepositoryPackageOperations = this.initSpyingOnRealRepositoryPackageOperations();
        String packageName = "packageName";
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)this.rulesRepository.loadModule("packageName")).thenReturn((Object)packageItem);
        PackageAssembler contentPackageAssembler = (PackageAssembler)Mockito.mock(PackageAssembler.class);
        Mockito.when((Object)contentPackageAssembler.getCompiledSource()).thenReturn(null);
        Assert.assertArrayEquals((Object[])localRepositoryPackageOperations.listRulesInPackage("packageName"), (Object[])new String[0]);
        ((RepositoryModuleOperations)Mockito.verify((Object)localRepositoryPackageOperations, (VerificationMode)Mockito.never())).parseRulesToPackageList((ModuleAssembler)Mockito.any(PackageAssembler.class), Mockito.anyList());
    }

    @Test
    @Ignore(value="This test does not test anything useful.Move the test to Arquillian or remove this test.")
    public void testListRulesInPackageAndtDRLIsNotMissing() throws DroolsParserException, SerializationException {
        RepositoryModuleOperations localRepositoryPackageOperations = this.initSpyingOnRealRepositoryPackageOperations();
        String packageName = "packageName";
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)this.rulesRepository.loadModule("packageName")).thenReturn((Object)packageItem);
        PackageAssembler contentPackageAssembler = (PackageAssembler)Mockito.mock(PackageAssembler.class);
        ((RepositoryModuleOperations)Mockito.doNothing().when((Object)localRepositoryPackageOperations)).parseRulesToPackageList((ModuleAssembler)contentPackageAssembler, new ArrayList());
        Mockito.when((Object)contentPackageAssembler.getCompiledSource()).thenReturn((Object)"DRL");
        Assert.assertArrayEquals((Object[])localRepositoryPackageOperations.listRulesInPackage("packageName"), (Object[])new String[0]);
        ((RepositoryModuleOperations)Mockito.verify((Object)localRepositoryPackageOperations)).parseRulesToPackageList((ModuleAssembler)Mockito.any(PackageAssembler.class), Mockito.anyList());
    }

    private void initSpyingAndMockingOnSuggestionCompletionLoader(DroolsServiceImplementation droolsServiceImplementation) {
        BRMSSuggestionCompletionLoader suggestionCompletionLoader = (BRMSSuggestionCompletionLoader)Mockito.mock(BRMSSuggestionCompletionLoader.class);
        ((DroolsServiceImplementation)Mockito.doReturn((Object)suggestionCompletionLoader).when((Object)droolsServiceImplementation)).createBRMSSuggestionCompletionLoader();
    }

    private Module createPackageConfigData(boolean isArchived) {
        Module packageConfigData = new Module();
        packageConfigData.setName("name");
        packageConfigData.setHeader("header");
        packageConfigData.setArchived(isArchived);
        packageConfigData.setDescription("description");
        packageConfigData.setExternalURI("externalUri");
        return packageConfigData;
    }

    private RepositoryModuleOperations initSpyingOnRealRepositoryPackageOperations() {
        RepositoryModuleOperations localRepositoryPackageOperations = (RepositoryModuleOperations)Mockito.spy((Object)this.repositoryPackageOperations);
        localRepositoryPackageOperations.setRulesRepositoryForTest(this.rulesRepository);
        this.initSession();
        return localRepositoryPackageOperations;
    }

    private void initDroolsHeaderCheck(ModuleItem packageItem) {
        AssetItem assetItem = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)packageItem.containsAsset("drools")).thenReturn((Object)false);
        Mockito.when((Object)packageItem.addAsset("drools", "")).thenReturn((Object)assetItem);
        DroolsHeader.updateDroolsHeader((String)"expected", (ModuleItem)packageItem);
        ((ModuleItem)Mockito.verify((Object)packageItem)).addAsset("drools", "");
        ((AssetItem)Mockito.verify((Object)assetItem)).updateFormat("package");
        ((AssetItem)Mockito.verify((Object)assetItem)).updateContent("expected");
        ((AssetItem)Mockito.verify((Object)assetItem)).checkin("");
    }

    private void initSession() {
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)this.rulesRepository.getSession()).thenReturn((Object)session);
    }

    private void prepareMockForPackageConfigDataFactory(ModuleItem packageItem) {
        this.preparePackageItemMockDates(packageItem);
        Mockito.when((Object)packageItem.getDependencies()).thenReturn((Object)new String[]{"dependency"});
    }

    private void preparePackageItemMockDates(ModuleItem packageItem) {
        Mockito.when((Object)packageItem.getLastModified()).thenReturn((Object)GregorianCalendar.getInstance());
        Mockito.when((Object)packageItem.getCreatedDate()).thenReturn((Object)GregorianCalendar.getInstance());
    }
}

