/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import java.util.HashSet;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.client.rpc.VerificationService;
import org.drools.guvnor.server.MockAssetItemIterator;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.VerificationServiceImplementation;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class VerificationServiceImplementationTest {
    private VerificationService verificationService;
    private ModuleItem packageItem;
    private RulesRepository rulesRepository;

    @Before
    public void setUp() {
        RepositoryAssetService repositoryAssetService = (RepositoryAssetService)Mockito.mock(RepositoryAssetService.class);
        VerificationServiceImplementation verificationServiceImplementation = new VerificationServiceImplementation();
        verificationServiceImplementation.repositoryAssetService = repositoryAssetService;
        repositoryAssetService.rulesRepository = this.rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        this.packageItem = this.createPackage();
        AssetItemIterator assetItemIterator = (AssetItemIterator)Mockito.mock(AssetItemIterator.class);
        Mockito.when((Object)assetItemIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.packageItem.listAssetsByFormat(new String[]{(String)Matchers.anyVararg()})).thenReturn((Object)assetItemIterator);
        Mockito.when((Object)this.rulesRepository.loadModule("mockPackage")).thenReturn((Object)this.packageItem);
        this.verificationService = verificationServiceImplementation;
    }

    @Test
    @Ignore(value="See JIRA https://issues.jboss.org/browse/GUVNOR-1812")
    public void testVerifyAsset() throws Exception {
        MockAssetItemIterator itemIterator = new MockAssetItemIterator();
        AssetItem assetItem = this.getAssetItem("");
        Mockito.when((Object)this.rulesRepository.loadAssetByUUID((String)Matchers.any())).thenReturn((Object)assetItem);
        itemIterator.setAssets(assetItem);
        Mockito.when((Object)this.packageItem.listAssetsByFormat(new String[]{"drl"})).thenReturn((Object)itemIterator);
        String drl = "";
        drl = drl + "rule Test\n";
        drl = drl + "when\n";
        drl = drl + "P(a==true)\n";
        drl = drl + "then\n";
        drl = drl + "end\n";
        Asset ruleAsset = this.getAsset(drl);
        AnalysisReport report = this.verificationService.verifyAsset(ruleAsset, new HashSet());
        Assert.assertNotNull((Object)report);
        Assert.assertEquals((long)0L, (long)report.errors.length);
        Assert.assertEquals((long)0L, (long)report.warnings.length);
        Assert.assertEquals((long)0L, (long)report.notes.length);
    }

    public Asset getAsset(String content) {
        Asset ruleAsset = new Asset();
        ruleAsset.setUuid("mockUUID");
        ruleAsset.metaData = this.getMetaData();
        ruleAsset.setFormat("drl");
        ruleAsset.content = this.getRuleContentText(content);
        return ruleAsset;
    }

    private AssetItem getAssetItem(String content) {
        AssetItem assetItem = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)assetItem.getUUID()).thenReturn((Object)"mockUUID");
        Mockito.when((Object)assetItem.getFormat()).thenReturn((Object)"drl");
        Mockito.when((Object)assetItem.getContent()).thenReturn((Object)content);
        Mockito.when((Object)assetItem.getModule()).thenReturn((Object)this.packageItem);
        return assetItem;
    }

    private RuleContentText getRuleContentText(String content) {
        RuleContentText ruleContentText = new RuleContentText();
        ruleContentText.content = content;
        return ruleContentText;
    }

    public MetaData getMetaData() {
        MetaData metaData = new MetaData();
        metaData.moduleName = "mockPackage";
        return metaData;
    }

    public ModuleItem createPackage() {
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)packageItem.getName()).thenReturn((Object)"mockPackage");
        return packageItem;
    }
}

