/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.InputStream;
import org.drools.guvnor.server.builder.PackageAssembler;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.junit.Assert;
import org.junit.Test;

public class PackageDRLAssemblerIntegrationTest
extends GuvnorIntegrationTest {
    @Test
    public void testSimplePackageWithDeclaredTypes() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testSimplePackageWithDeclaredTypes2", "");
        DroolsHeader.updateDroolsHeader((String)"import java.util.HashMap", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n dialect 'mvel' \n when Album() \n then \nAlbum a = new Album(); \n end");
        rule1.checkin("");
        AssetItem model = pkg.addAsset("model", "qed");
        model.updateFormat("model.drl");
        model.updateContent("declare Album\n genre: String \n end");
        model.checkin("");
        this.rulesRepository.save();
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        String drl = asm.getCompiledSource();
        Assert.assertTrue((drl.indexOf("declare Album") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testSimplePackageWithDeclaredTypesUsingDependency() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testSimplePackageWithDeclaredTypesUsingDependency", "");
        DroolsHeader.updateDroolsHeader((String)"import java.util.HashMap", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n dialect 'mvel' \n when Album() \n then \nAlbum a = new Album(); \n end");
        rule1.checkin("");
        AssetItem model = pkg.addAsset("model", "qed");
        model.updateFormat("model.drl");
        model.updateContent("declare Album\n genre1: String \n end");
        model.checkin("version 0");
        model.updateContent("declare Album\n genre2: String \n end");
        model.checkin("version 1");
        model.updateContent("declare Album\n genre3: String \n end");
        model.checkin("version 2");
        this.rulesRepository.save();
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        Assert.assertFalse((String)asm.getErrors().toString(), (boolean)asm.hasErrors());
        asm = new PackageAssembler();
        asm.init(pkg, null);
        String drl = asm.getCompiledSource();
        Assert.assertTrue((drl.indexOf("genre2") == -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("genre3") > -1 ? 1 : 0) != 0);
        pkg.updateDependency("model?version=2");
        pkg.checkin("Update dependency");
        PackageAssembler asm2 = new PackageAssembler();
        asm2.init(pkg, null);
        Assert.assertFalse((String)asm2.getErrors().toString(), (boolean)asm2.hasErrors());
        asm2 = new PackageAssembler();
        asm2.init(pkg, null);
        String drl2 = asm2.getCompiledSource();
        Assert.assertTrue((drl2.indexOf("genre2") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl2.indexOf("genre3") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetHistoryPackageSource() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testGetHistoryPackageSource", "");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer1", (ModuleItem)pkg);
        AssetItem func = pkg.addAsset("func", "");
        func.updateFormat("function");
        func.updateContent("function void foo() { System.out.println(version 1); }");
        func.checkin("version 1");
        AssetItem dsl = pkg.addAsset("myDSL", "");
        dsl.updateFormat("dsl");
        dsl.updateContent("[then]call a func=foo();\n[when]foo=FooBarBaz1()");
        dsl.checkin("version 1");
        AssetItem rule = pkg.addAsset("rule1", "");
        rule.updateFormat("drl");
        rule.updateContent("rule 'foo' when Goo1() then end");
        rule.checkin("version 1");
        AssetItem rule2 = pkg.addAsset("rule2", "");
        rule2.updateFormat("dslr");
        rule2.updateContent("when \n foo \n then \n call a func");
        rule2.checkin("version 1");
        AssetItem rule3 = pkg.addAsset("model1", "");
        rule3.updateFormat("model.drl");
        rule3.updateContent("declare Album1\n genre1: String \n end");
        rule3.checkin("version 1");
        pkg.checkin("version2");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer2", (ModuleItem)pkg);
        func.updateContent("function void foo() { System.out.println(version 2); }");
        func.checkin("version 2");
        dsl.updateContent("[then]call a func=foo();\n[when]foo=FooBarBaz2()");
        dsl.checkin("version 2");
        rule.updateContent("rule 'foo' when Goo2() then end");
        rule.checkin("version 2");
        rule2.updateContent("when \n foo \n then \n call a func");
        rule2.checkin("version 2");
        rule3.updateContent("declare Album2\n genre2: String \n end");
        rule3.checkin("version 2");
        pkg.checkin("version3");
        ModuleItem item = this.rulesRepository.loadModule("testGetHistoryPackageSource");
        PackageAssembler asm = new PackageAssembler();
        asm.init(item, null);
        String drl = asm.getCompiledSource();
        System.out.println(drl);
        Assert.assertEquals((Object)"version3", (Object)item.getCheckinComment());
        Assert.assertTrue((drl.indexOf("global com.billasurf.Person customer2") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("System.out.println(version 2)") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("FooBarBaz2()") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rule 'foo' when Goo2() then end") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("foo") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("declare Album2") >= 0 ? 1 : 0) != 0);
        ModuleItem item2 = this.rulesRepository.loadModule("testGetHistoryPackageSource", 2L);
        PackageAssembler asm2 = new PackageAssembler();
        asm2.init(item2, null);
        String drl2 = asm2.getCompiledSource();
        System.out.println(drl2);
        Assert.assertEquals((Object)"version2", (Object)item2.getCheckinComment());
        Assert.assertTrue((drl2.indexOf("global com.billasurf.Person customer1") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl2.indexOf("System.out.println(version 1)") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl2.indexOf("FooBarBaz1()") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl2.indexOf("rule 'foo' when Goo1() then end") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl2.indexOf("foo") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl2.indexOf("declare Album1") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testShowSource() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testShowSource", "");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer", (ModuleItem)pkg);
        this.rulesRepository.save();
        AssetItem func = pkg.addAsset("func", "");
        func.updateFormat("function");
        func.updateContent("function void foo() { System.out.println(42); }");
        func.checkin("");
        AssetItem dsl = pkg.addAsset("myDSL", "");
        dsl.updateFormat("dsl");
        dsl.updateContent("[then]call a func=foo();\n[when]foo=FooBarBaz()");
        dsl.checkin("");
        AssetItem rule = pkg.addAsset("rule1", "");
        rule.updateFormat("drl");
        rule.updateContent("rule 'foo' when Goo() then end");
        rule.checkin("");
        AssetItem rule2 = pkg.addAsset("rule2", "");
        rule2.updateFormat("dslr");
        rule2.updateContent("when \n foo \n then \n call a func");
        rule2.checkin("");
        AssetItem rule3 = pkg.addAsset("model1", "");
        rule3.updateFormat("model.drl");
        rule3.updateContent("garbage");
        rule3.updateDisabled(true);
        rule3.checkin("");
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        String drl = asm.getCompiledSource();
        Assert.assertNotNull((Object)drl);
        this.assertContains("import com.billasurf.Board", drl);
        this.assertContains("global com.billasurf.Person customer", drl);
        this.assertContains("package testShowSource", drl);
        this.assertContains("function void foo() { System.out.println(42); }", drl);
        this.assertContains("foo();", drl);
        this.assertContains("FooBarBaz()", drl);
        this.assertContains("rule 'foo' when Goo() then end", drl);
        Assert.assertEquals((long)-1L, (long)drl.indexOf("garbage"));
    }

    @Test
    public void testShowSourceUsingSpecifiedDependencies() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testShowSourceUsingSpecifiedDependencies", "");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer", (ModuleItem)pkg);
        this.rulesRepository.save();
        AssetItem func = pkg.addAsset("func", "");
        func.updateFormat("function");
        func.updateContent("function void foo() { System.out.println(version 1); }");
        func.checkin("version 1");
        func.updateContent("function void foo() { System.out.println(version 2); }");
        func.checkin("version 2");
        AssetItem dsl = pkg.addAsset("myDSL", "");
        dsl.updateFormat("dsl");
        dsl.updateContent("[then]call a func=foo();\n[when]foo=FooBarBaz1()");
        dsl.checkin("version 1");
        dsl.updateContent("[then]call a func=foo();\n[when]foo=FooBarBaz2()");
        dsl.checkin("version 2");
        AssetItem rule = pkg.addAsset("rule1", "");
        rule.updateFormat("drl");
        rule.updateContent("rule 'foo' when Goo() then end");
        rule.checkin("version 1");
        rule.updateContent("rule 'foo' when Eoo() then end");
        rule.checkin("version 2");
        AssetItem rule2 = pkg.addAsset("rule2", "");
        rule2.updateFormat("dslr");
        rule2.updateContent("when \n foo \n then \n call a func");
        rule2.checkin("version 1");
        rule2.updateContent("when \n foo \n then \n call a func");
        rule2.checkin("version 2");
        AssetItem rule3 = pkg.addAsset("model1", "");
        rule3.updateFormat("model.drl");
        rule3.updateContent("garbage");
        rule3.updateDisabled(true);
        rule3.checkin("version 1");
        rule3.updateContent("declare Album\n genre1: String \n end");
        rule3.checkin("version 2");
        this.rulesRepository.save();
        pkg.updateDependency("func?version=1");
        pkg.updateDependency("myDSL?version=1");
        pkg.updateDependency("rule1?version=1");
        pkg.updateDependency("rule2?version=1");
        pkg.updateDependency("model1?version=1");
        pkg.checkin("Update dependency");
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        String drl = asm.getCompiledSource();
        Assert.assertNotNull((Object)drl);
        this.assertContains("import com.billasurf.Board", drl);
        this.assertContains("global com.billasurf.Person customer", drl);
        this.assertContains("package testShowSource", drl);
        this.assertContains("function void foo() { System.out.println(version 1); }", drl);
        this.assertContains("foo();", drl);
        this.assertContains("FooBarBaz1()", drl);
        this.assertContains("rule 'foo' when Goo() then end", drl);
        Assert.assertEquals((long)-1L, (long)drl.indexOf("garbage"));
        Assert.assertEquals((long)-1L, (long)drl.indexOf("Album"));
    }

    @Test
    public void testShowSourceForHistoricalPackage() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testShowSourceForHistoricalPackage", "");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer", (ModuleItem)pkg);
        this.rulesRepository.save();
        AssetItem func = pkg.addAsset("func", "");
        func.updateFormat("function");
        func.updateContent("function void foo() { System.out.println(version 1); }");
        func.checkin("version 1");
        func.updateContent("function void foo() { System.out.println(version 2); }");
        func.checkin("version 2");
        AssetItem dsl = pkg.addAsset("myDSL", "");
        dsl.updateFormat("dsl");
        dsl.updateContent("[then]call a func=foo();\n[when]foo=FooBarBaz1()");
        dsl.checkin("version 1");
        dsl.updateContent("[then]call a func=foo();\n[when]foo=FooBarBaz2()");
        dsl.checkin("version 2");
        AssetItem rule = pkg.addAsset("rule1", "");
        rule.updateFormat("drl");
        rule.updateContent("rule 'foo' when Goo() then end");
        rule.checkin("version 1");
        rule.updateContent("rule 'foo' when Eoo() then end");
        rule.checkin("version 2");
        AssetItem rule2 = pkg.addAsset("rule2", "");
        rule2.updateFormat("dslr");
        rule2.updateContent("when \n foo \n then \n call a func");
        rule2.checkin("version 1");
        rule2.updateContent("when \n foo \n then \n call a func");
        rule2.checkin("version 2");
        AssetItem rule3 = pkg.addAsset("model1", "");
        rule3.updateFormat("model.drl");
        rule3.updateContent("garbage");
        rule3.updateDisabled(true);
        rule3.checkin("version 1");
        rule3.updateContent("declare Album\n genre1: String \n end");
        rule3.checkin("version 2");
        this.rulesRepository.save();
        pkg.checkin("Version 2");
        pkg.checkout();
        pkg.checkin("Version 3");
        ModuleItem historicalPackage = this.rulesRepository.loadModule("testShowSourceForHistoricalPackage", 2L);
        PackageAssembler asm = new PackageAssembler();
        asm.init(historicalPackage, null);
        String drl = asm.getCompiledSource();
        Assert.assertNotNull((Object)drl);
        System.out.println(drl);
        this.assertContains("import com.billasurf.Board", drl);
        this.assertContains("global com.billasurf.Person customer", drl);
        this.assertContains("package testShowSource", drl);
        this.assertContains("function void foo() { System.out.println(version 2); }", drl);
        this.assertContains("FooBarBaz2()", drl);
        this.assertContains("rule 'foo' when Eoo() then end", drl);
        Assert.assertEquals((long)-1L, (long)drl.indexOf("garbage"));
        Assert.assertEquals((long)-1L, (long)drl.indexOf("Album"));
    }

    @Test
    public void testBuildPackageWithEmptyHeader() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testBuildPackageWithEmptyHeader", "");
        DroolsHeader.updateDroolsHeader((String)"\n", (ModuleItem)pkg);
        this.rulesRepository.save();
        PackageAssembler asm = null;
        try {
            asm = new PackageAssembler();
            asm.init(pkg, null);
        }
        catch (NullPointerException e) {
            Assert.fail((String)e.toString());
        }
        String drl = asm.getCompiledSource();
        Assert.assertNotNull((Object)drl);
        Assert.assertEquals((Object)"package testBuildPackageWithEmptyHeader", (Object)drl.trim());
    }

    @Test
    public void testSkipDisabledAssets() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testSkipDisabledAssets", "");
        this.rulesRepository.save();
        AssetItem assertRule1 = pkg.addAsset("rule1", "");
        assertRule1.updateFormat("drl");
        assertRule1.updateContent("rule 'foo1' when then end");
        assertRule1.checkin("");
        assertRule1.updateDisabled(false);
        AssetItem assertRule2 = pkg.addAsset("rule2", "");
        assertRule2.updateFormat("drl");
        assertRule2.updateContent("rule 'foo2' when then end");
        assertRule2.checkin("");
        assertRule2.updateDisabled(true);
        AssetItem assertRule3 = pkg.addAsset("rule3", "");
        assertRule3.updateFormat("drl");
        assertRule3.updateContent("rule 'foo3' when then end");
        assertRule3.checkin("");
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        Assert.assertFalse((boolean)asm.hasErrors());
        String drl = asm.getCompiledSource();
        Assert.assertNotNull((Object)drl);
        this.assertContains("rule 'foo1' when then end", drl);
        this.assertDoesNotContain("rule 'foo2' when then end", drl);
        this.assertContains("rule 'foo3' when then end", drl);
    }

    @Test
    public void testSkipDisabledImports() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testXLSDecisionTableIgnoreImports", "");
        this.rulesRepository.save();
        InputStream xls = this.getClass().getResourceAsStream("Sample.xls");
        Assert.assertNotNull((Object)xls);
        AssetItem asset = pkg.addAsset("MyDT", "");
        asset.updateFormat("xls");
        asset.updateBinaryContentAttachment(xls);
        asset.checkin("");
        PackageAssembler asm = new PackageAssembler();
        asm.init(pkg, null);
        String drl = asm.getCompiledSource();
        System.err.println(drl);
        Assert.assertTrue((drl.indexOf("package ", 2) == -1 ? 1 : 0) != 0);
    }

    private void assertContains(String sub, String text) {
        if (text.indexOf(sub) == -1) {
            Assert.fail((String)("the text: '" + sub + "' was not found."));
        }
    }

    private void assertDoesNotContain(String sub, String text) {
        if (text.indexOf(sub) > -1) {
            Assert.fail((String)("the text: '" + sub + "' was found."));
        }
    }
}

