/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.drools;

import java.io.InputStream;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.server.MockAssetItemIterator;
import org.drools.guvnor.server.builder.AssetItemValidator;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.drools.BRLContentHandler;
import org.drools.guvnor.server.contenthandler.drools.DRLFileContentHandler;
import org.drools.guvnor.server.contenthandler.drools.DSLDefinitionContentHandler;
import org.drools.guvnor.server.contenthandler.drools.DSLRuleContentHandler;
import org.drools.guvnor.server.contenthandler.drools.EnumerationContentHandler;
import org.drools.guvnor.server.contenthandler.drools.FactModelContentHandler;
import org.drools.guvnor.server.contenthandler.drools.FunctionContentHandler;
import org.drools.guvnor.server.contenthandler.drools.GuidedDTContentHandler;
import org.drools.guvnor.server.contenthandler.drools.RuleTemplateHandler;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AssetItemValidatorTest {
    private ModuleItem packageItem;
    private AssetItem unsavedAssetItem;
    private AssetItem savedAssetItem;

    @Before
    public void setUp() throws Exception {
        this.setUpPackageItem();
        this.setUpUnsavedAssetItem();
        this.setUpSavedAssetItem();
    }

    @Test
    public void testValidateBRL() throws Exception {
        this.testValidate("brl", (ContentHandler)new BRLContentHandler());
    }

    @Test
    public void testValidateDRL() throws Exception {
        this.testValidate("drl", (ContentHandler)new DRLFileContentHandler());
    }

    @Test
    public void testValidateDecisionTableGuided() throws Exception {
        this.testValidate("gdst", (ContentHandler)new GuidedDTContentHandler());
    }

    @Test
    public void testValidateDrlModel() throws Exception {
        this.testValidate("model.drl", (ContentHandler)new FactModelContentHandler());
    }

    @Test
    public void testValidateDsl() throws Exception {
        this.testValidate("dsl", (ContentHandler)new DSLDefinitionContentHandler());
    }

    @Test
    public void testValidateFunction() throws Exception {
        this.testValidate("function", (ContentHandler)new FunctionContentHandler());
    }

    @Test
    public void testValidateRuleTemplate() throws Exception {
        this.testValidate("template", (ContentHandler)new RuleTemplateHandler());
    }

    @Test
    public void testValidateDslTemplateRule() throws Exception {
        this.setUpMockAssets("dslr");
        this.setUpAssetItemIterators("dslr");
        this.setUpMockDSL();
        this.verifyValidate((ContentHandler)new DSLRuleContentHandler());
    }

    @Test
    public void testValidateDecisionSpreadsheetXLS() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("EmptyDecisionTable.xls");
        Mockito.when((Object)this.savedAssetItem.getFormat()).thenReturn((Object)"xls");
        Mockito.when((Object)this.savedAssetItem.getBinaryContentAttachment()).thenReturn((Object)in);
        Mockito.when((Object)this.unsavedAssetItem.getFormat()).thenReturn((Object)"xls");
        Mockito.when((Object)this.unsavedAssetItem.getBinaryContentAttachment()).thenReturn((Object)in);
        this.setUpAssetItemIterators("xls");
        this.runValidate((ContentHandler)new DSLRuleContentHandler());
        ((AssetItem)Mockito.verify((Object)this.unsavedAssetItem)).getBinaryContentAttachment();
        ((AssetItem)Mockito.verify((Object)this.savedAssetItem, (VerificationMode)Mockito.never())).getBinaryContentAttachment();
    }

    @Test
    public void testValidateEnumeration() throws Exception {
        this.setUpMockAssets("enumeration", "");
        this.setUpAssetItemIterators("enumeration");
        EnumerationContentHandler contentHandler = (EnumerationContentHandler)Mockito.spy((Object)new EnumerationContentHandler());
        this.runValidate((ContentHandler)contentHandler);
        ((EnumerationContentHandler)Mockito.verify((Object)contentHandler)).validateAsset((AssetItem)Matchers.any());
        ((AssetItem)Mockito.verify((Object)this.unsavedAssetItem)).getContent();
        ((AssetItem)Mockito.verify((Object)this.savedAssetItem, (VerificationMode)Mockito.never())).getContent();
    }

    private void setUpMockDSL() {
        AssetItem dslAssetItem = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)dslAssetItem.getUUID()).thenReturn((Object)"TempMockUUID");
        Mockito.when((Object)dslAssetItem.getFormat()).thenReturn((Object)"dsl");
        Mockito.when((Object)dslAssetItem.getContent()).thenReturn((Object)"");
        MockAssetItemIterator mockAssetItemIterator = this.createMockAssetItemIterator(dslAssetItem);
        Mockito.when((Object)this.packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"dsl"})).thenReturn((Object)mockAssetItemIterator);
    }

    public void testValidate(String assetFormat, ContentHandler contentHandler) throws Exception {
        this.setUpMockAssets(assetFormat);
        this.setUpAssetItemIterators(assetFormat);
        this.verifyValidate(contentHandler);
    }

    private void setUpMockAssets(String assetFormat, String content) {
        Mockito.when((Object)this.unsavedAssetItem.getFormat()).thenReturn((Object)assetFormat);
        Mockito.when((Object)this.unsavedAssetItem.getContent()).thenReturn((Object)content);
        Mockito.when((Object)this.savedAssetItem.getFormat()).thenReturn((Object)assetFormat);
        Mockito.when((Object)this.savedAssetItem.getContent()).thenReturn((Object)content);
    }

    private void setUpMockAssets(String assetFormat) {
        Mockito.when((Object)this.unsavedAssetItem.getFormat()).thenReturn((Object)assetFormat);
        Mockito.when((Object)this.savedAssetItem.getFormat()).thenReturn((Object)assetFormat);
    }

    private void verifyValidate(ContentHandler contentHandler) {
        this.runValidate(contentHandler);
        ((AssetItem)Mockito.verify((Object)this.unsavedAssetItem)).getContent();
        ((AssetItem)Mockito.verify((Object)this.savedAssetItem, (VerificationMode)Mockito.never())).getContent();
    }

    private void runValidate(ContentHandler contentHandler) {
        AssetItemValidator assetItemValidator = new AssetItemValidator(contentHandler, this.unsavedAssetItem);
        BuilderResult builderResult = assetItemValidator.validate();
        Assert.assertTrue((boolean)builderResult.getLines().isEmpty());
    }

    private void setUpPackageItem() {
        this.packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)this.packageItem.getName()).thenReturn((Object)"mock");
    }

    private void setUpUnsavedAssetItem() {
        this.unsavedAssetItem = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)this.unsavedAssetItem.getModule()).thenReturn((Object)this.packageItem);
        Mockito.when((Object)this.unsavedAssetItem.getContent()).thenReturn((Object)"");
        Mockito.when((Object)this.unsavedAssetItem.getUUID()).thenReturn((Object)"mock");
    }

    private void setUpSavedAssetItem() {
        this.savedAssetItem = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)this.savedAssetItem.getModule()).thenReturn((Object)this.packageItem);
        Mockito.when((Object)this.savedAssetItem.getContent()).thenReturn((Object)"");
        Mockito.when((Object)this.savedAssetItem.getUUID()).thenReturn((Object)"mock");
    }

    private void setUpAssetItemIterators(String assetFormat) {
        MockAssetItemIterator assetItemIterator = this.createMockAssetItemIterator(new AssetItem[0]);
        this.setUpConfigurations((AssetItemIterator)assetItemIterator);
        this.setUpAnIteratorForAllAssetFormats((AssetItemIterator)assetItemIterator);
        this.setUpAssetIteratorForAssetFormat(assetFormat);
    }

    private void setUpAssetIteratorForAssetFormat(String assetFormat) {
        MockAssetItemIterator mockAssetItemIterator = this.createMockAssetItemIterator(this.savedAssetItem);
        Mockito.when((Object)this.packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{assetFormat})).thenReturn((Object)mockAssetItemIterator);
    }

    private void setUpAnIteratorForAllAssetFormats(AssetItemIterator assetItemIterator) {
        Mockito.when((Object)this.packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat((String[])Matchers.any())).thenReturn((Object)assetItemIterator);
    }

    private void setUpConfigurations(AssetItemIterator assetItemIterator) {
        Mockito.when((Object)this.packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"properties", "conf"})).thenReturn((Object)assetItemIterator);
    }

    private MockAssetItemIterator createMockAssetItemIterator(AssetItem ... assetItems) {
        MockAssetItemIterator mockAssetItemIterator = new MockAssetItemIterator();
        mockAssetItemIterator.setAssets(assetItems);
        return mockAssetItemIterator;
    }
}

