/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactModels;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FieldMetaModel;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.server.contenthandler.drools.FactModelContentHandler;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.junit.Assert;
import org.junit.Test;

public class FactModelContentHandlerIntegrationTest
extends GuvnorIntegrationTest {
    @Test
    public void testToDrl() {
        ArrayList<FieldMetaModel> fields = new ArrayList<FieldMetaModel>();
        fields.add(new FieldMetaModel("f1", "int"));
        fields.add(new FieldMetaModel("f2", "String"));
        FactMetaModel mm = new FactMetaModel("FooBar", fields);
        FactModelContentHandler ch = new FactModelContentHandler();
        String drl = ch.toDRL(mm);
        Assert.assertNotNull((Object)drl);
        System.err.println(drl);
        Assert.assertEquals((Object)"declare FooBar\n\tf1: int\n\tf2: String\nend", (Object)drl);
        FactMetaModel mm2 = new FactMetaModel("BooBah", new ArrayList());
        ArrayList<FactMetaModel> models = new ArrayList<FactMetaModel>();
        models.add(mm);
        models.add(mm2);
        drl = ch.toDRL(models);
        System.err.println(drl);
        Assert.assertTrue((drl.indexOf("FooBar") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("BooBah") > drl.indexOf("FooBar") ? 1 : 0) != 0);
    }

    @Test
    public void testFromDrlDeclarationEmpty() throws Exception {
        String drl = "declare FooBar\nend";
        FactModelContentHandler ch = new FactModelContentHandler();
        List list = ch.toModel(drl);
        Assert.assertEquals((long)1L, (long)list.size());
        FactMetaModel mm = (FactMetaModel)list.get(0);
        Assert.assertEquals((Object)"FooBar", (Object)mm.getName());
        Assert.assertEquals((long)0L, (long)mm.getFields().size());
    }

    @Test
    public void testFromDrlDeclarationWithFields() throws Exception {
        String drl = "declare FooBar\n\tf1: int\n\tf2: String\nend";
        FactModelContentHandler ch = new FactModelContentHandler();
        List list = ch.toModel(drl);
        Assert.assertEquals((long)1L, (long)list.size());
        FactMetaModel mm = (FactMetaModel)list.get(0);
        Assert.assertEquals((Object)"FooBar", (Object)mm.getName());
        Assert.assertEquals((long)2L, (long)mm.getFields().size());
        for (int i = 0; i < mm.getFields().size(); ++i) {
            FieldMetaModel fm = (FieldMetaModel)mm.getFields().get(1);
            if (fm.name.equals("f1")) {
                Assert.assertEquals((Object)"f1", (Object)fm.name);
                Assert.assertEquals((Object)"int", (Object)fm.type);
                continue;
            }
            Assert.assertEquals((Object)"f2", (Object)fm.name);
            Assert.assertEquals((Object)"String", (Object)fm.type);
        }
    }

    @Test
    public void testFromDrlDeclarationWithAnnotations() throws Exception {
        String drl = "declare FooBar\n\t@role(event)\nend";
        FactModelContentHandler ch = new FactModelContentHandler();
        List list = ch.toModel(drl);
        Assert.assertEquals((long)1L, (long)list.size());
        FactMetaModel mm = (FactMetaModel)list.get(0);
        Assert.assertEquals((Object)"FooBar", (Object)mm.getName());
        Assert.assertEquals((long)0L, (long)mm.getFields().size());
        Assert.assertEquals((long)1L, (long)mm.getAnnotations().size());
        Assert.assertEquals((Object)"event", ((AnnotationMetaModel)mm.getAnnotations().get((int)0)).values.get("value"));
    }

    @Test
    public void testAdvancedDeprecated() throws Exception {
        String drl = "#advanced editor \ndeclare FooBar\n\t name: String  \nend";
        try {
            FactModelContentHandler ch = new FactModelContentHandler();
            ch.toModel(drl);
            Assert.fail((String)"should not parse this");
        }
        catch (DroolsParserException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testAdvanced() throws Exception {
        String drl = "//advanced editor \ndeclare FooBar\n\t name: String  \nend";
        try {
            FactModelContentHandler ch = new FactModelContentHandler();
            ch.toModel(drl);
            Assert.fail((String)"should not parse this");
        }
        catch (DroolsParserException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testFromEmptyDrl() throws Exception {
        String drl = "";
        FactModelContentHandler ch = new FactModelContentHandler();
        List list = ch.toModel(drl);
        Assert.assertNotNull((Object)list);
    }

    @Test
    public void testStore() throws Exception {
        FactModelContentHandler ch = new FactModelContentHandler();
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.loadDefaultModule();
        AssetItem asset = pkg.addAsset("testDeclaredTypeStore", "");
        asset.updateFormat("model.drl");
        asset.updateContent("declare Foo\n name: String\n end");
        asset.checkin("");
        Asset ass = new Asset();
        ch.retrieveAssetContent(ass, asset);
        Assert.assertTrue((boolean)(ass.getContent() instanceof FactModels));
        FactModels fm = (FactModels)ass.getContent();
        Assert.assertEquals((long)1L, (long)fm.models.size());
        FactMetaModel mm = (FactMetaModel)fm.models.get(0);
        Assert.assertEquals((long)1L, (long)mm.getFields().size());
        Assert.assertEquals((Object)"Foo", (Object)mm.getName());
        FieldMetaModel fmm = (FieldMetaModel)mm.getFields().get(0);
        Assert.assertEquals((Object)"name", (Object)fmm.name);
        mm.getFields().add(new FieldMetaModel("age", "int"));
        ch.storeAssetContent(ass, asset);
        Assert.assertTrue((asset.getContent().indexOf("age: int") > -1 ? 1 : 0) != 0);
        asset.updateContent("rubbish here");
        asset.checkin("");
        ch.retrieveAssetContent(ass, asset);
        Assert.assertTrue((boolean)(ass.getContent() instanceof RuleContentText));
        ch.storeAssetContent(ass, asset);
        Assert.assertEquals((Object)"rubbish here", (Object)asset.getContent());
    }
}

