/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKAgentConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKBaseConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKSessionConfig;
import org.drools.guvnor.server.contenthandler.drools.ServiceConfigPersistence;
import org.drools.guvnor.server.contenthandler.drools.ServiceWarBuilderAndDownloadHandler;
import org.drools.guvnor.server.files.MockHTTPRequest;
import org.drools.guvnor.server.files.MockHTTPResponse;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.util.codec.Base64;
import org.junit.Assert;
import org.junit.Test;

public class ServiceWarBuilderAndDownloadHandlerIntegrationTest
extends GuvnorIntegrationTest {
    private static final Collection<AssetReference> resources = new ArrayList<AssetReference>(){
        {
            this.add(new AssetReference("myPkg", "a", "drl", "http://localhost/c/source", "uuid1"));
            this.add(new AssetReference("myPkg", "aa", "drl", "http://localhost/cc/source", "uuid2"));
            this.add(new AssetReference("myPkg", "ab", "changeset", "http://localhost/cd/source", "uuid3"));
        }
    };
    private static final Collection<AssetReference> models = new ArrayList<AssetReference>(){
        {
            this.add(new AssetReference("myPkg", "a.jar", "model", "http://localhost/a.jar", "uudi44"));
        }
    };
    private static final ServiceConfig REST_SERVICE_CONFIG = new ServiceConfig(){
        {
            ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
            kbase1.addModels(models);
            kbase1.addResources(resources);
            ServiceKSessionConfig ksession1 = new ServiceKSessionConfig("ksession1");
            ServiceKAgentConfig kagent = new ServiceKAgentConfig("kagent1");
            kagent.setNewInstance(false);
            kbase1.addKsession(ksession1);
            kbase1.addKagent(kagent);
            this.addKBase(kbase1);
            this.setPollingFrequency(70);
        }
    };
    @Inject
    private ServiceWarBuilderAndDownloadHandler serviceHandler;

    @Test
    public void testGet() throws IOException, ServletException {
        ModuleItem pkg = this.rulesRepository.createModule("testGetServiceConfigServlet", "");
        final AssetItem ass = pkg.addAsset("myAsset", "");
        ass.updateFormat("serviceConfig");
        ass.updateContent(ServiceConfigPersistence.getInstance().marshal(REST_SERVICE_CONFIG));
        ass.checkin("hey ho, let's go!");
        Assert.assertNotNull((Object)this.serviceHandler);
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", "BASIC " + new String(Base64.encodeBase64((byte[])"admin:admin".getBytes())));
            }
        };
        HashMap<String, String> parameters = new HashMap<String, String>(){
            {
                this.put("uuid", ass.getUUID());
            }
        };
        String uri = "http://loser/api/packages/testGetServiceConfigServlet/myAsset.serviceConfig";
        MockHTTPRequest req = new MockHTTPRequest("http://loser/api/packages/testGetServiceConfigServlet/myAsset.serviceConfig", (Map<String, String>)headers, (Map<String, String>)parameters);
        MockHTTPResponse res = new MockHTTPResponse();
        this.serviceHandler.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((Object)"application/x-download", (Object)res.getContentType());
        Assert.assertEquals((Object)true, (Object)res.containsHeader("Content-Disposition"));
    }
}

