/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.server.files.ActionsAPI;
import org.drools.guvnor.server.files.ActionsAPIServlet;
import org.drools.guvnor.server.files.MockHTTPRequest;
import org.drools.guvnor.server.files.MockHTTPResponse;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.util.codec.Base64;
import org.junit.Assert;
import org.junit.Test;

public class ActionAPIServletIntegrationTest
extends GuvnorIntegrationTest {
    private final String compilationPath = "http://foo/action/compile";
    private final String snapshotPath = "http://foo/action/snapshot";
    @Inject
    private ActionsAPIServlet actionsAPIServlet;

    public ActionAPIServletIntegrationTest() {
        this.autoLoginAsAdmin = false;
    }

    @Test
    public void testCompilation() throws Exception {
        final String dynamicPackage = "test-action" + UUID.randomUUID();
        this.rulesRepository.createModule(dynamicPackage, "test-action package for testing");
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", "BASIC " + new String(new Base64().encode("admin:admin".getBytes())));
            }
        };
        HashMap<String, String> parameters = new HashMap<String, String>(){
            {
                this.put(ActionsAPI.Parameters.PackageName.toString(), dynamicPackage);
            }
        };
        MockHTTPRequest req = new MockHTTPRequest("http://foo/action/compile", (Map<String, String>)headers, (Map<String, String>)parameters);
        MockHTTPResponse res = new MockHTTPResponse();
        this.actionsAPIServlet.doPost((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((long)200L, (long)res.status);
    }

    @Test
    public void testSnapshotCreation() throws Exception {
        final String dynamicPackage = "test-snap" + UUID.randomUUID();
        this.rulesRepository.createModule(dynamicPackage, "test-snapshot package for testing");
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", "BASIC " + new String(new Base64().encode("admin:admin".getBytes())));
            }
        };
        HashMap<String, String> parameters = new HashMap<String, String>(){
            {
                this.put(ActionsAPI.Parameters.PackageName.toString(), dynamicPackage);
                this.put(ActionsAPI.Parameters.SnapshotName.toString(), "test-action-snap1");
            }
        };
        ByteArrayInputStream in = new ByteArrayInputStream("some content".getBytes());
        MockHTTPRequest req = new MockHTTPRequest("http://foo/action/snapshot", (Map<String, String>)headers, (Map<String, String>)parameters, in);
        MockHTTPResponse res = new MockHTTPResponse();
        this.actionsAPIServlet.doPost((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((long)200L, (long)res.status);
    }
}

