/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.server.files.MockHTTPRequest;
import org.drools.guvnor.server.files.MockHTTPResponse;
import org.drools.guvnor.server.files.RestAPIServlet;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;
import org.drools.util.codec.Base64;
import org.junit.Assert;
import org.junit.Test;

public class RestAPIServletIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private RestAPIServlet restAPIServlet;

    public RestAPIServletIntegrationTest() {
        this.autoLoginAsAdmin = false;
    }

    @Test
    public void testGetRestServletNoLogin() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testGetRestServletNoLogin", "");
        AssetItem ass = pkg.addAsset("asset1", "");
        ass.updateFormat("drl");
        ass.updateContent("some content");
        ass.checkin("hey ho");
        Assert.assertNotNull((Object)this.restAPIServlet.getAPI());
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Irrelevant", "garbage");
            }
        };
        String uri = "http://loser/api/packages/testGetRestServletNoLogin/asset1.drl";
        MockHTTPRequest req = new MockHTTPRequest(uri, (Map<String, String>)headers);
        MockHTTPResponse res = new MockHTTPResponse();
        this.restAPIServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((long)401L, (long)res.errorCode);
        Assert.assertTrue((boolean)res.headers.containsKey("WWW-Authenticate"));
    }

    @Test
    public void testGetRestServletBadLogin() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testGetRestServletBadLogin", "");
        AssetItem ass = pkg.addAsset("asset1", "");
        ass.updateFormat("drl");
        ass.updateContent("some content");
        ass.checkin("hey ho");
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", new String(Base64.encodeBase64((byte[])"admin:invalidPwd".getBytes())));
            }
        };
        String uri = "http://loser/api/packages/testGetRestServletBadLogin/asset1.drl";
        MockHTTPRequest req = new MockHTTPRequest(uri, (Map<String, String>)headers);
        MockHTTPResponse res = new MockHTTPResponse();
        this.restAPIServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((long)401L, (long)res.errorCode);
        Assert.assertTrue((boolean)res.headers.containsKey("WWW-Authenticate"));
    }

    @Test
    public void testGetRestServlet() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testGetRestServlet", "");
        AssetItem ass = pkg.addAsset("asset1", "");
        ass.updateFormat("drl");
        ass.updateContent("some content");
        ass.checkin("hey ho");
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", "BASIC " + new String(Base64.encodeBase64((byte[])"admin:admin".getBytes())));
            }
        };
        String uri = "http://loser/api/packages/testGetRestServlet/asset1.drl";
        MockHTTPRequest req = new MockHTTPRequest(uri, (Map<String, String>)headers);
        MockHTTPResponse res = new MockHTTPResponse();
        this.restAPIServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((long)0L, (long)res.errorCode);
        String data = res.extractContent();
        Assert.assertEquals((Object)"some content", (Object)data);
        Assert.assertEquals((Object)"application/x-download", (Object)res.getContentType());
        Assert.assertEquals((Object)true, (Object)res.containsHeader("Content-Disposition"));
        req = new MockHTTPRequest(uri, (Map<String, String>)headers);
        req.queryString = "version=all";
        res = new MockHTTPResponse();
        this.restAPIServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((long)0L, (long)res.errorCode);
        data = res.extractContent();
        Assert.assertFalse((boolean)"some content".equals(data));
        Assert.assertNotNull((Object)data);
    }

    @Test
    public void testPost() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testPostRestServlet", "");
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", "BASIC " + new String(Base64.encodeBase64((byte[])"admin:admin".getBytes())));
            }
        };
        ByteArrayInputStream in = new ByteArrayInputStream("some new content".getBytes());
        MockHTTPRequest req = new MockHTTPRequest("http://foo/api/packages/testPostRestServlet/asset1.drl", (Map<String, String>)headers, in);
        MockHTTPResponse res = new MockHTTPResponse();
        this.restAPIServlet.doPost((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((Object)"OK", (Object)res.extractContent());
        AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"drl"});
        AssetItem ass = it.next();
        Assert.assertEquals((Object)"asset1", (Object)ass.getName());
        Assert.assertEquals((Object)"drl", (Object)ass.getFormat());
        Assert.assertFalse((boolean)ass.isBinary());
        Assert.assertEquals((Object)"some new content", (Object)ass.getContent());
        in = new ByteArrayInputStream("more content".getBytes());
        req = new MockHTTPRequest("http://foo/api/packages/testPostRestServlet/asset2.xls", (Map<String, String>)headers, in);
        res = new MockHTTPResponse();
        this.restAPIServlet.doPost((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((Object)"OK", (Object)res.extractContent());
        pkg.getNode().refresh(false);
        AssetItem ass2 = pkg.loadAsset("asset2");
        Assert.assertEquals((Object)"xls", (Object)ass2.getFormat());
        Assert.assertTrue((boolean)ass2.isBinary());
        String out = new String(ass2.getBinaryContentAsBytes());
        Assert.assertEquals((Object)"more content", (Object)out);
    }

    @Test
    public void testPut() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testPutRestServlet", "");
        AssetItem ass = pkg.addAsset("asset1", "abc");
        ass.updateFormat("drl");
        ass.checkin("");
        long ver = ass.getVersionNumber();
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", "BASIC " + new String(Base64.encodeBase64((byte[])"admin:admin".getBytes())));
                this.put("Checkin-Comment", "hey ho");
            }
        };
        ByteArrayInputStream in = new ByteArrayInputStream("some new content".getBytes());
        MockHTTPRequest req = new MockHTTPRequest("http://foo/api/packages/testPutRestServlet/asset1.drl", (Map<String, String>)headers, in);
        MockHTTPResponse res = new MockHTTPResponse();
        this.restAPIServlet.doPut((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((Object)"OK", (Object)res.extractContent());
        ass = pkg.loadAsset("asset1");
        pkg.getNode().refresh(false);
        Assert.assertEquals((Object)"some new content", (Object)ass.getContent());
        Assert.assertEquals((long)(ver + 1L), (long)ass.getVersionNumber());
        Assert.assertEquals((Object)"hey ho", (Object)ass.getCheckinComment());
    }

    @Test
    public void testDelete() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testDeleteRestServlet", "");
        AssetItem ass = pkg.addAsset("asset1", "abc");
        ass.updateFormat("drl");
        ass.checkin("");
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", "BASIC " + new String(Base64.encodeBase64((byte[])"admin:admin".getBytes())));
            }
        };
        ByteArrayInputStream in = new ByteArrayInputStream("some new content".getBytes());
        MockHTTPRequest req = new MockHTTPRequest("http://foo/api/packages/testDeleteRestServlet/asset1.drl", (Map<String, String>)headers, in);
        MockHTTPResponse res = new MockHTTPResponse();
        this.restAPIServlet.doDelete((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((Object)"OK", (Object)res.extractContent());
        pkg = this.rulesRepository.loadModule("testDeleteRestServlet");
        Assert.assertFalse((boolean)pkg.listAssetsByFormat(new String[]{"drl"}).hasNext());
    }
}

