/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.InputStream;
import java.security.Principal;
import java.util.Date;
import java.util.Iterator;
import javax.inject.Inject;
import net.sf.webdav.ITransaction;
import org.apache.commons.io.IOUtils;
import org.drools.guvnor.server.files.WebDAVImpl;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.junit.Assert;
import org.junit.Test;

public class WebDAVImplIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    protected WebDAVImpl webDAV;

    @Test
    public void testPath() {
        String[] path = this.webDAV.getPath("http://goober/whee/webdav/packages/packagename/resource.drl", true);
        Assert.assertEquals((Object)"packages", (Object)path[0]);
        Assert.assertEquals((Object)"packagename", (Object)path[1]);
        Assert.assertEquals((Object)"resource.drl", (Object)path[2]);
        path = this.webDAV.getPath("foo/webdav", true);
        Assert.assertEquals((long)0L, (long)path.length);
        path = this.webDAV.getPath("/");
        Assert.assertEquals((long)0L, (long)path.length);
        path = this.webDAV.getPath("/packages/packagename/resource.drl");
        Assert.assertEquals((Object)"packages", (Object)path[0]);
        Assert.assertEquals((Object)"packagename", (Object)path[1]);
        Assert.assertEquals((Object)"resource.drl", (Object)path[2]);
    }

    @Test
    public void testPathContainsWebdav() {
        String[] path = this.webDAV.getPath("http://goober/whee/webdav/packages/ssswebdavss/resource.drl", true);
        Assert.assertEquals((Object)"packages", (Object)path[0]);
        Assert.assertEquals((Object)"ssswebdavss", (Object)path[1]);
        Assert.assertEquals((Object)"resource.drl", (Object)path[2]);
        path = this.webDAV.getPath("foo/webdav", true);
        Assert.assertEquals((long)0L, (long)path.length);
        path = this.webDAV.getPath("/");
        Assert.assertEquals((long)0L, (long)path.length);
        path = this.webDAV.getPath("/packages/ssswebdavss/resource.drl");
        Assert.assertEquals((Object)"packages", (Object)path[0]);
        Assert.assertEquals((Object)"ssswebdavss", (Object)path[1]);
        Assert.assertEquals((Object)"resource.drl", (Object)path[2]);
        path = this.webDAV.getPath("http://goober/whee/webdav/packages/webdav/resource.drl", true);
        Assert.assertEquals((Object)"packages", (Object)path[0]);
        Assert.assertEquals((Object)"webdav", (Object)path[1]);
        Assert.assertEquals((Object)"resource.drl", (Object)path[2]);
        path = this.webDAV.getPath("/packages/webdav/resource.drl");
        Assert.assertEquals((Object)"packages", (Object)path[0]);
        Assert.assertEquals((Object)"webdav", (Object)path[1]);
        Assert.assertEquals((Object)"resource.drl", (Object)path[2]);
    }

    @Test
    public void testBadCopy() throws Exception {
        try {
            this.webDAV.objectExists("/foo/webdav/packages/foobar/Something.drl copy 42");
            Assert.fail((String)"should not be allowed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testChildrenNames() throws Exception {
        String[] children = this.webDAV.getChildrenNames((ITransaction)new TransactionMock(), "/packages");
        Assert.assertTrue((children.length > 0 ? 1 : 0) != 0);
        int packageCount = children.length;
        ModuleItem pkg = this.rulesRepository.createModule("testWebDavChildNames1", "");
        this.rulesRepository.createModule("testWebDavChildNames2", "");
        this.rulesRepository.save();
        children = this.webDAV.getChildrenNames((ITransaction)new TransactionMock(), "/packages");
        Assert.assertEquals((long)(packageCount + 2), (long)children.length);
        this.assertContains("testWebDavChildNames1", children);
        this.assertContains("testWebDavChildNames2", children);
        AssetItem asset = pkg.addAsset("asset1", "something");
        asset.updateFormat("drl");
        asset.checkin("");
        asset = pkg.addAsset("asset2", "something");
        asset.updateFormat("dsl");
        asset.checkin("");
        children = this.webDAV.getChildrenNames((ITransaction)new TransactionMock(), "/packages/testWebDavChildNames1");
        Assert.assertEquals((long)2L, (long)children.length);
        Assert.assertEquals((Object)"asset1.drl", (Object)children[0]);
        Assert.assertEquals((Object)"asset2.dsl", (Object)children[1]);
        children = this.webDAV.getChildrenNames((ITransaction)new TransactionMock(), "/packages/testWebDavChildNames1/asset1.drl");
        Assert.assertNull((Object)children);
    }

    @Test
    public void testCreateFolder() throws Exception {
        String[] children = this.webDAV.getChildrenNames((ITransaction)new TransactionMock(), "/packages");
        int packageCount = children.length;
        this.webDAV.createFolder((ITransaction)new TransactionMock(), "/packages/testCreateWebDavFolder");
        children = this.webDAV.getChildrenNames((ITransaction)new TransactionMock(), "/packages");
        Assert.assertEquals((long)(packageCount + 1), (long)children.length);
        this.assertContains("testCreateWebDavFolder", children);
        ModuleItem pkg = this.rulesRepository.loadModule("testCreateWebDavFolder");
        Assert.assertNotNull((Object)pkg);
        pkg.addAsset("someAsset", "");
        try {
            this.webDAV.createFolder((ITransaction)new TransactionMock(), "/somethingElse");
            Assert.fail((String)"this should not work !");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testDates() throws Exception {
        String uri = "/packages";
        Assert.assertNotNull((Object)this.webDAV.getCreationDate(uri));
        Assert.assertNotNull((Object)this.webDAV.getLastModified(uri));
    }

    @Test
    public void testCreateResourceAndCreatedDate() throws Exception {
        this.webDAV.createFolder((ITransaction)new TransactionMock(), "/packages/testCreateResourceAndCreatedDate");
        Thread.sleep(100L);
        this.webDAV.createResource((ITransaction)new TransactionMock(), "/packages/testCreateResourceAndCreatedDate/asset.drl");
        String[] resources = this.webDAV.getChildrenNames((ITransaction)new TransactionMock(), "/packages/testCreateResourceAndCreatedDate");
        Assert.assertEquals((long)1L, (long)resources.length);
        Assert.assertEquals((Object)"asset.drl", (Object)resources[0]);
        this.webDAV.createResource((ITransaction)new TransactionMock(), "/packages/testCreateResourceAndCreatedDate/._asset.drl");
        this.webDAV.createResource((ITransaction)new TransactionMock(), "/packages/.DS_Store");
        ModuleItem pkg = this.rulesRepository.loadModule("testCreateResourceAndCreatedDate");
        Assert.assertFalse((boolean)pkg.containsAsset("._asset"));
        Assert.assertTrue((boolean)pkg.containsAsset("asset"));
        Iterator it = pkg.getAssets();
        AssetItem ass = (AssetItem)it.next();
        Assert.assertEquals((Object)"asset", (Object)ass.getName());
        Assert.assertEquals((Object)"drl", (Object)ass.getFormat());
        Date create = this.webDAV.getCreationDate("/packages/testCreateResourceAndCreatedDate");
        Assert.assertNotNull((Object)create);
        Assert.assertTrue((boolean)create.after(new Date("10-Jul-1974")));
        Date assetCreate = this.webDAV.getCreationDate("/packages/testCreateResourceAndCreatedDate/asset.drl");
        Assert.assertTrue((boolean)assetCreate.after(create));
        Date lm = this.webDAV.getLastModified("/packages/testCreateResourceAndCreatedDate");
        Assert.assertNotNull((Object)lm);
        Assert.assertTrue((boolean)lm.after(new Date("10-Jul-1974")));
        Date alm = this.webDAV.getLastModified("/packages/testCreateResourceAndCreatedDate/asset.drl");
        Assert.assertTrue((boolean)alm.after(lm));
        try {
            this.webDAV.createResource((ITransaction)new TransactionMock(), "/hummer.drl");
            Assert.fail((String)"Shouldn't be able to do this");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testResourceContent() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testWebDAVContent", "");
        AssetItem asset = pkg.addAsset("asset", "something");
        asset.updateFormat("drl");
        asset.updateContent("Some content");
        asset.checkin("");
        InputStream data = this.webDAV.getResourceContent((ITransaction)new TransactionMock(), "/packages/testWebDAVContent/asset.drl");
        Assert.assertEquals((Object)"Some content", (Object)IOUtils.toString((InputStream)data));
        asset = pkg.addAsset("asset2", "something");
        asset.updateFormat("xls");
        asset.updateBinaryContentAttachment(IOUtils.toInputStream((String)"This is binary"));
        asset.checkin("");
        data = this.webDAV.getResourceContent((ITransaction)new TransactionMock(), "/packages/testWebDAVContent/asset2.xls");
        Assert.assertEquals((Object)"This is binary", (Object)IOUtils.toString((InputStream)data));
        AssetItem asset_ = pkg.addAsset("somethingelse", "");
        asset_.updateFormat("drl");
        asset_.checkin("");
        data = this.webDAV.getResourceContent((ITransaction)new TransactionMock(), "/packages/testWebDAVContent/somethingelse.drl");
        Assert.assertEquals((Object)"", (Object)IOUtils.toString((InputStream)data));
    }

    @Test
    public void testIsFolder() throws Exception {
        Assert.assertTrue((boolean)this.webDAV.isFolder("/packages"));
        Assert.assertTrue((boolean)this.webDAV.isFolder("/packages/"));
        Assert.assertFalse((boolean)this.webDAV.isFolder("/packages/somePackage"));
        this.webDAV.createFolder((ITransaction)new TransactionMock(), "/packages/testDAVIsFolder");
        Assert.assertTrue((boolean)this.webDAV.isFolder("/packages/testDAVIsFolder"));
        Assert.assertFalse((boolean)this.webDAV.isFolder("/packages/somePackage/SomeFile.drl"));
    }

    @Test
    public void testIsResource() throws Exception {
        Assert.assertFalse((boolean)this.webDAV.isResource("/packages"));
        Assert.assertFalse((boolean)this.webDAV.isResource("/packages/somePackage"));
        Assert.assertFalse((boolean)this.webDAV.isResource("/packages/somePackage/SomeFile.drl"));
        this.webDAV.createFolder((ITransaction)new TransactionMock(), "/packages/testDAVIsResource");
        this.webDAV.createResource((ITransaction)new TransactionMock(), "/packages/testDAVIsResource/SomeFile.drl");
        Assert.assertTrue((boolean)this.webDAV.isResource("/packages/testDAVIsResource/SomeFile.drl"));
    }

    @Test
    public void testResourceLength() throws Exception {
        Assert.assertEquals((long)0L, (long)this.webDAV.getResourceLength((ITransaction)new TransactionMock(), "/webdav/packages"));
        this.webDAV.createFolder((ITransaction)new TransactionMock(), "/packages/testResourceLengthDAV");
        this.webDAV.createResource((ITransaction)new TransactionMock(), "/packages/testResourceLengthDAV/testResourceLength");
        Assert.assertEquals((long)0L, (long)this.webDAV.getResourceLength((ITransaction)new TransactionMock(), "/packages/testResourceLengthDAV/testResourceLength"));
        this.webDAV.setResourceContent((ITransaction)new TransactionMock(), "/packages/testResourceLengthDAV/testResourceLength", IOUtils.toInputStream((String)"some input"), null, null);
        Assert.assertEquals((long)"some input".getBytes().length, (long)this.webDAV.getResourceLength((ITransaction)new TransactionMock(), "/packages/testResourceLengthDAV/testResourceLength"));
    }

    @Test
    public void testObjectExists() throws Exception {
        Assert.assertTrue((boolean)this.webDAV.objectExists("/packages"));
        this.webDAV.createFolder((ITransaction)new TransactionMock(), "/packages/testDavObjectExists");
        Assert.assertTrue((boolean)this.webDAV.objectExists("/packages/testDavObjectExists"));
        Assert.assertFalse((boolean)this.webDAV.objectExists("/packages/testDavObjectExistsXXXX"));
        Assert.assertFalse((boolean)this.webDAV.objectExists("/packages/testDavObjectExists/foobar.drl"));
        Assert.assertFalse((boolean)this.webDAV.objectExists("/packages/testDavObjectExistsXXXX/foobar.drl"));
    }

    @Test
    public void testRemoveObject() throws Exception {
        Assert.assertFalse((boolean)this.webDAV.objectExists("/packages/testDavRemoveObjectFolder"));
        this.webDAV.createFolder((ITransaction)new TransactionMock(), "/packages/testDavRemoveObjectFolder");
        Assert.assertTrue((boolean)this.webDAV.objectExists("/packages/testDavRemoveObjectFolder"));
        this.webDAV.removeObject((ITransaction)new TransactionMock(), "/packages/testDavRemoveObjectFolder");
        Assert.assertFalse((boolean)this.webDAV.objectExists("/packages/testDavRemoveObjectFolder"));
        this.webDAV.createFolder((ITransaction)new TransactionMock(), "/packages/testDavRemoveObjectAsset");
        this.webDAV.createResource((ITransaction)new TransactionMock(), "/packages/testDavRemoveObjectAsset/asset.drl");
        AssetItem as = this.rulesRepository.loadModule("testDavRemoveObjectAsset").loadAsset("asset");
        long origVer = as.getVersionNumber();
        Assert.assertTrue((boolean)this.webDAV.objectExists("/packages/testDavRemoveObjectAsset/asset.drl"));
        this.webDAV.removeObject((ITransaction)new TransactionMock(), "/packages/testDavRemoveObjectAsset/asset.drl");
        Assert.assertFalse((boolean)this.webDAV.objectExists("/packages/testDavRemoveObjectAsset/asset.drl"));
        Assert.assertTrue((boolean)this.webDAV.objectExists("/packages/testDavRemoveObjectAsset"));
        this.webDAV.createResource((ITransaction)new TransactionMock(), "/packages/testDavRemoveObjectAsset/asset.drl");
        Assert.assertTrue((boolean)this.webDAV.objectExists("/packages/testDavRemoveObjectAsset/asset.drl"));
        as = this.rulesRepository.loadModule("testDavRemoveObjectAsset").loadAsset("asset");
        Assert.assertTrue((as.getVersionNumber() > origVer ? 1 : 0) != 0);
        this.webDAV.createFolder((ITransaction)new TransactionMock(), "/packages/testDavRemoveObjectFolder");
        Assert.assertTrue((boolean)this.webDAV.objectExists("/packages/testDavRemoveObjectFolder"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetContent() throws Exception {
        String CONTENT1 = "some input";
        String EXPECTED_CONTENT1 = "some input\n";
        String CONTENT2 = "some more input";
        String EXPECTED_CONTENT2 = "some more input\n";
        try {
            this.webDAV.createFolder((ITransaction)new TransactionMock(), "/packages/testSetDavContent");
        }
        finally {
            if (this.webDAV != null) {
                this.webDAV.commit((ITransaction)new TransactionMock());
            }
        }
        try {
            this.webDAV.createResource((ITransaction)new TransactionMock(), "/packages/testSetDavContent/Something.drl");
        }
        finally {
            if (this.webDAV != null) {
                this.webDAV.commit((ITransaction)new TransactionMock());
            }
        }
        try {
            this.webDAV.setResourceContent((ITransaction)new TransactionMock(), "/packages/testSetDavContent/Something.drl", IOUtils.toInputStream((String)"some input"), null, null);
        }
        finally {
            if (this.webDAV != null) {
                this.webDAV.commit((ITransaction)new TransactionMock());
            }
        }
        try {
            this.webDAV.getResourceContent((ITransaction)new TransactionMock(), "/packages/testSetDavContent/Something.drl");
        }
        finally {
            if (this.webDAV != null) {
                this.webDAV.commit((ITransaction)new TransactionMock());
            }
        }
        try {
            AssetItem as = this.rulesRepository.loadModule("testSetDavContent").loadAsset("Something");
            Assert.assertTrue((boolean)as.isBinary());
            String result = IOUtils.toString((InputStream)this.webDAV.getResourceContent((ITransaction)new TransactionMock(), "/packages/testSetDavContent/Something.drl"));
            Assert.assertEquals((Object)"some input\n", (Object)result);
            ModuleItem pkg = this.rulesRepository.loadModule("testSetDavContent");
            AssetItem asset = pkg.loadAsset("Something");
            Assert.assertEquals((Object)"drl", (Object)asset.getFormat());
            Assert.assertEquals((Object)"some input\n", (Object)asset.getContent());
            Assert.assertEquals((Object)"some input\n", (Object)IOUtils.toString((InputStream)asset.getBinaryContentAttachment()));
            this.webDAV.setResourceContent((ITransaction)new TransactionMock(), "/packages/testSetDavContent/Something.drl", IOUtils.toInputStream((String)"some more input"), null, null);
            result = IOUtils.toString((InputStream)this.webDAV.getResourceContent((ITransaction)new TransactionMock(), "/packages/testSetDavContent/Something.drl"));
            Assert.assertEquals((Object)"some more input\n", (Object)result);
        }
        finally {
            if (this.webDAV != null) {
                this.webDAV.commit((ITransaction)new TransactionMock());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNewAsset() throws Exception {
        try {
            this.webDAV.createFolder((ITransaction)new TransactionMock(), "/packages/testDavNewAsset");
        }
        finally {
            if (this.webDAV != null) {
                this.webDAV.commit((ITransaction)new TransactionMock());
            }
        }
        try {
            Assert.assertFalse((boolean)this.webDAV.objectExists("/packages/testDavNewAsset/Blah.drl"));
        }
        finally {
            if (this.webDAV != null) {
                this.webDAV.commit((ITransaction)new TransactionMock());
            }
        }
        try {
            this.webDAV.isFolder("/packages/testDavNewAsset");
            this.webDAV.isFolder("/packages/testDavNewAsset/Blah.drl");
            Assert.assertFalse((boolean)this.webDAV.objectExists("/packages/testDavNewAsset/Blah.drl"));
            this.webDAV.createResource((ITransaction)new TransactionMock(), "/packages/testDavNewAsset/Blah.drl");
            this.webDAV.setResourceContent((ITransaction)new TransactionMock(), "/packages/testDavNewAsset/Blah.drl", IOUtils.toInputStream((String)"blah blah"), null, null);
            this.webDAV.getResourceLength((ITransaction)new TransactionMock(), "/packages/testDavNewAsset/Blah.drl");
        }
        finally {
            if (this.webDAV != null) {
                this.webDAV.commit((ITransaction)new TransactionMock());
            }
        }
        try {
            Assert.assertTrue((boolean)this.webDAV.objectExists("/packages/testDavNewAsset/Blah.drl"));
        }
        finally {
            if (this.webDAV != null) {
                this.webDAV.commit((ITransaction)new TransactionMock());
            }
        }
    }

    @Test
    public void testSnapshot() throws Exception {
        String CONTENT = "some input";
        String EXPECTED_CONTENT = "some input\n";
        this.webDAV.createFolder((ITransaction)new TransactionMock(), "/packages/testDavSnapshot");
        this.webDAV.createResource((ITransaction)new TransactionMock(), "/packages/testDavSnapshot/Something.drl");
        this.webDAV.setResourceContent((ITransaction)new TransactionMock(), "/packages/testDavSnapshot/Something.drl", IOUtils.toInputStream((String)"some input"), null, null);
        this.rulesRepository.createModuleSnapshot("testDavSnapshot", "SNAP1");
        this.rulesRepository.createModuleSnapshot("testDavSnapshot", "SNAP2");
        String[] packages = this.webDAV.getChildrenNames((ITransaction)new TransactionMock(), "/snapshots");
        Assert.assertTrue((packages.length > 0 ? 1 : 0) != 0);
        this.assertContains("testDavSnapshot", packages);
        String[] snaps = this.webDAV.getChildrenNames((ITransaction)new TransactionMock(), "/snapshots/testDavSnapshot");
        Assert.assertEquals((long)2L, (long)snaps.length);
        Assert.assertEquals((Object)"SNAP1", (Object)snaps[0]);
        Assert.assertEquals((Object)"SNAP2", (Object)snaps[1]);
        String[] list = this.webDAV.getChildrenNames((ITransaction)new TransactionMock(), "/snapshots/testDavSnapshot/SNAP1");
        Assert.assertEquals((long)1L, (long)list.length);
        Assert.assertEquals((Object)"Something.drl", (Object)list[0]);
        list = this.webDAV.getChildrenNames((ITransaction)new TransactionMock(), "/snapshots/testDavSnapshot/SNAP2");
        Assert.assertEquals((long)1L, (long)list.length);
        Assert.assertEquals((Object)"Something.drl", (Object)list[0]);
        Assert.assertNotNull((Object)this.webDAV.getCreationDate("/snapshots"));
        Assert.assertNotNull((Object)this.webDAV.getCreationDate("/snapshots/testDavSnapshot"));
        Assert.assertNotNull((Object)this.webDAV.getCreationDate("/snapshots/testDavSnapshot/SNAP1"));
        Assert.assertNotNull((Object)this.webDAV.getCreationDate("/snapshots/testDavSnapshot/SNAP1/Something.drl"));
        Assert.assertNotNull((Object)this.webDAV.getLastModified("/snapshots"));
        Assert.assertNotNull((Object)this.webDAV.getLastModified("/snapshots/testDavSnapshot"));
        Assert.assertNotNull((Object)this.webDAV.getLastModified("/snapshots/testDavSnapshot/SNAP1"));
        Assert.assertNotNull((Object)this.webDAV.getLastModified("/snapshots/testDavSnapshot/SNAP1/Something.drl"));
        this.createFolderTry(this.webDAV, "/snapshots/randomAss");
        this.createFolderTry(this.webDAV, "/snapshots/testDavSnapshot/SNAPX");
        this.createFolderTry(this.webDAV, "/snapshots/testDavSnapshot/SNAP1/Something.drl");
        this.createFolderTry(this.webDAV, "/snapshots/testDavSnapshot/SNAP1/Another.drl");
        this.createResourceTry(this.webDAV, "/snapshots/randomAss");
        this.createResourceTry(this.webDAV, "/snapshots/testDavSnapshot/SNAPX");
        this.createResourceTry(this.webDAV, "/snapshots/testDavSnapshot/SNAP1/Something.drl");
        this.createResourceTry(this.webDAV, "/snapshots/testDavSnapshot/SNAP1/Another.drl");
        InputStream in = this.webDAV.getResourceContent((ITransaction)new TransactionMock(), "/snapshots/testDavSnapshot/SNAP1/Something.drl");
        Assert.assertEquals((Object)"some input\n", (Object)IOUtils.toString((InputStream)in));
        Assert.assertEquals((long)0L, (long)this.webDAV.getResourceLength((ITransaction)new TransactionMock(), "/snapshots/testDavSnapshot/SNAP1"));
        Assert.assertEquals((long)"some input\n".getBytes().length, (long)this.webDAV.getResourceLength((ITransaction)new TransactionMock(), "/snapshots/testDavSnapshot/SNAP1/Something.drl"));
        Assert.assertTrue((boolean)this.webDAV.isFolder("/snapshots"));
        Assert.assertTrue((boolean)this.webDAV.isFolder("/snapshots/testDavSnapshot"));
        Assert.assertTrue((boolean)this.webDAV.isFolder("/snapshots/testDavSnapshot/SNAP2"));
        Assert.assertFalse((boolean)this.webDAV.isFolder("/snapshots/testDavSnapshot/SNAP2/Something.drl"));
        Assert.assertFalse((boolean)this.webDAV.isResource("/snapshots"));
        Assert.assertFalse((boolean)this.webDAV.isResource("/snapshots/testDavSnapshot"));
        Assert.assertFalse((boolean)this.webDAV.isResource("/snapshots/testDavSnapshot/SNAP2"));
        Assert.assertTrue((boolean)this.webDAV.isResource("/snapshots/testDavSnapshot/SNAP2/Something.drl"));
        Assert.assertFalse((boolean)this.webDAV.isResource("/snapshots/testDavSnapshot/SNAP2/DoesNotExist.drl"));
        Assert.assertTrue((boolean)this.webDAV.objectExists("/snapshots"));
        Assert.assertFalse((boolean)this.webDAV.objectExists("/snapshots/testDavSnapshotXX"));
        Assert.assertTrue((boolean)this.webDAV.objectExists("/snapshots/testDavSnapshot"));
        Assert.assertTrue((boolean)this.webDAV.objectExists("/snapshots/testDavSnapshot/SNAP1"));
        Assert.assertFalse((boolean)this.webDAV.objectExists("/snapshots/testDavSnapshot/SNAPX"));
        Assert.assertFalse((boolean)this.webDAV.objectExists("/snapshots/testDavSnapshot/SNAP1/Foo.drl"));
        Assert.assertTrue((boolean)this.webDAV.objectExists("/snapshots/testDavSnapshot/SNAP1/Something.drl"));
        Assert.assertNull((Object)this.webDAV.getChildrenNames((ITransaction)new TransactionMock(), "/snapshots/testDavSnapshot/SNAP1/Something.drl"));
        try {
            this.webDAV.removeObject((ITransaction)new TransactionMock(), "/snapshots/testDavSnapshot/SNAP1/Something.drl");
            Assert.fail((String)"Should not delete files from snapshots");
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            this.webDAV.setResourceContent((ITransaction)new TransactionMock(), "/snapshots/testDavSnapshot/SNAP1/Something.drl", null, null, null);
            Assert.fail((String)"should not be allowed to update content in snapshots.");
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        Assert.assertFalse((boolean)this.webDAV.objectExists("/snapshots/defaultPackage/new file"));
        try {
            this.webDAV.createResource((ITransaction)new TransactionMock(), "/snapshots/defaultPackage/new file");
            Assert.fail((String)"can't touch this");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    private void createResourceTry(WebDAVImpl webDAV, String path) {
        try {
            webDAV.createResource((ITransaction)new TransactionMock(), path);
            Assert.fail((String)"Should not be allowed");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    private void createFolderTry(WebDAVImpl webDAV, String path) {
        try {
            webDAV.createFolder((ITransaction)new TransactionMock(), path);
            Assert.fail((String)"should not be allowed");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    private void assertContains(String string, String[] children) {
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].equals(string)) continue;
            return;
        }
        Assert.fail((String)("Array did not contain " + string));
    }

    static class TransactionMock
    implements ITransaction {
        TransactionMock() {
        }

        public Principal getPrincipal() {
            return null;
        }
    }
}

