/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.jaxrs;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.Response;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.RequestOptions;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.drools.guvnor.server.jaxrs.Translator;
import org.drools.guvnor.server.jaxrs.jaxb.Asset;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.utils.IOUtils;
import org.drools.util.codec.Base64;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AssetPackageResourceIntegrationTest
extends GuvnorIntegrationTest {
    private static int totalAssets = 9;
    private Abdera abdera = new Abdera();

    public AssetPackageResourceIntegrationTest() {
        this.autoLoginAsAdmin = false;
    }

    @Test
    @InSequence(value=-1)
    public void startServers() throws Exception {
        CategoryItem cat = this.rulesRepository.loadCategory("/");
        cat.addCategory("AssetPackageResourceTestCategory", "yeah");
        cat.addCategory("AssetPackageResourceTestCategory2", "yeah");
        this.rulesRepository.createState("Dev");
        ModuleItem pkg = this.rulesRepository.createModule("restPackage1", "this is package restPackage1");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer1", (ModuleItem)pkg);
        AssetItem func = pkg.addAsset("func", "");
        func.updateFormat("function");
        func.updateContent("function void foo() { System.out.println(version 1); }");
        func.checkin("version 1");
        AssetItem dsl = pkg.addAsset("myDSL", "");
        dsl.updateFormat("dsl");
        dsl.updateContent("[then]call a func=foo();\n[when]foo=FooBarBaz1()");
        dsl.checkin("version 1");
        AssetItem rule = pkg.addAsset("rule1", "");
        rule.updateFormat("drl");
        rule.updateContent("rule 'foo' when Goo1() then end");
        rule.checkin("version 1");
        AssetItem rule4 = pkg.addAsset("rule4", "");
        rule4.updateFormat("drl");
        rule4.updateContent("rule 'foo 2' when Goo1() then end");
        rule4.checkin("version 1");
        AssetItem rule2 = pkg.addAsset("rule2", "");
        rule2.updateFormat("dslr");
        rule2.updateContent("when \n foo \n then \n call a func");
        rule2.checkin("version 1");
        AssetItem rule3 = pkg.addAsset("model1", "desc for model1", "AssetPackageResourceTestCategory", "model.drl");
        rule3.updateFormat("model.drl");
        rule3.updateContent("declare Album1\n genre1: String \n end");
        rule3.checkin("version 1");
        AssetItem rule5 = pkg.addAsset("model5", "desc for model5", "AssetPackageResourceTestCategory", "model.drl");
        rule5.updateFormat("model.drl");
        rule5.updateContent("declare Album5\n genre5: String \n end");
        rule5.checkin("version 1");
        AssetItem rule6 = pkg.addAsset("model6", "desc for model6", "AssetPackageResourceTestCategory", "model.drl");
        rule6.updateFormat("model.drl");
        rule6.updateContent("declare Album6\n genre6: String \n end");
        rule6.checkin("version 1");
        rule3.updateFormat("model.drl");
        rule3.updateContent("declare Album1\n genre1: String \n end");
        rule3.checkin("version 1");
        pkg.checkin("version2");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\n global com.billasurf.Person customer2", (ModuleItem)pkg);
        func.updateContent("function void foo() { System.out.println(version 2); }");
        func.checkin("version 2");
        dsl.updateContent("[then]call a func=foo();\n[when]foo=FooBarBaz2()");
        dsl.checkin("version 2");
        rule.updateContent("rule 'foo' when Goo2() then end");
        rule.checkin("version 2");
        rule2.updateContent("when \n foo \n then \n call a func");
        rule2.checkin("version 2");
        rule3.updateContent("declare Album2\n genre2: String \n end");
        rule3.checkin("version 2");
        pkg.checkin("version3");
        Iterator assets = pkg.getAssets();
        int assetsCount = 0;
        while (assets.hasNext()) {
            ++assetsCount;
            assets.next();
        }
        Assert.assertEquals((long)totalAssets, (long)assetsCount);
    }

    @Test
    @RunAsClient
    public void testGetAssetsAsAtom(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        RequestOptions options = client.getDefaultRequestOptions();
        options.setAccept("application/atom+xml");
        ClientResponse resp = client.get(new URL(baseURL, "rest/packages/restPackage1/assets").toExternalForm(), options);
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)("Couldn't retrieve assets-> " + resp.getStatus() + ": " + resp.getStatusText()));
        }
        Document document = resp.getDocument();
        Assert.assertEquals((long)totalAssets, (long)((Feed)document.getRoot()).getEntries().size());
    }

    @Test
    @RunAsClient
    public void testGetAssetsAsJaxB(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/xml", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    public void testGetAssetsAsJson(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/json", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    public void testGetDRLAssetsAsAtom(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        RequestOptions options = client.getDefaultRequestOptions();
        options.setAccept("application/atom+xml");
        ClientResponse resp = client.get(new URL(baseURL, "rest/packages/restPackage1/assets?format=drl").toExternalForm(), options);
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)("Couldn't retrieve DRL assets-> " + resp.getStatus() + ": " + resp.getStatusText()));
        }
        Document document = resp.getDocument();
        Assert.assertEquals((long)2L, (long)((Feed)document.getRoot()).getEntries().size());
        ArrayList<String> assetNames = new ArrayList<String>();
        for (Entry entry : ((Feed)document.getRoot()).getEntries()) {
            assetNames.add(entry.getTitle());
        }
        Assert.assertTrue((boolean)assetNames.contains("rule1"));
        Assert.assertTrue((boolean)assetNames.contains("rule4"));
    }

    @Test
    @RunAsClient
    public void testGetDRLAssetsAsJSON(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        RequestOptions options = client.getDefaultRequestOptions();
        options.setAccept("application/json");
        ClientResponse resp = client.get(new URL(baseURL, "rest/packages/restPackage1/assets?format=drl").toExternalForm(), options);
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)("Couldn't retrieve DRL assets-> " + resp.getStatus() + ": " + resp.getStatusText()));
        }
        BufferedReader reader = new BufferedReader(resp.getReader());
        reader.close();
    }

    @Test
    @RunAsClient
    public void testGetDRLAndDSLAssetsAsAtom(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        RequestOptions options = client.getDefaultRequestOptions();
        options.setAccept("application/atom+xml");
        ClientResponse resp = client.get(new URL(baseURL, "rest/packages/restPackage1/assets?format=drl&format=dsl").toExternalForm(), options);
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)("Couldn't retrieve DRL and DSL assets-> " + resp.getStatus() + ": " + resp.getStatusText()));
        }
        Document document = resp.getDocument();
        Assert.assertEquals((long)3L, (long)((Feed)document.getRoot()).getEntries().size());
        ArrayList<String> assetNames = new ArrayList<String>();
        for (Entry entry : ((Feed)document.getRoot()).getEntries()) {
            assetNames.add(entry.getTitle());
        }
        Assert.assertTrue((boolean)assetNames.contains("rule1"));
        Assert.assertTrue((boolean)assetNames.contains("rule4"));
        Assert.assertTrue((boolean)assetNames.contains("myDSL"));
    }

    @Test
    @RunAsClient
    public void testGetDRLAndDSLAssetsAsJSON(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        RequestOptions options = client.getDefaultRequestOptions();
        options.setAccept("application/json");
        ClientResponse resp = client.get(new URL(baseURL, "rest/packages/restPackage1/assets?format=drl&format=dsl").toExternalForm(), options);
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)("Couldn't retrieve DRL and DSL assets-> " + resp.getStatus() + ": " + resp.getStatusText()));
        }
        BufferedReader reader = new BufferedReader(resp.getReader());
        reader.close();
    }

    @Test
    @RunAsClient
    public void testGetAssetAsAtom(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/model1");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        InputStream in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        Document doc = this.abdera.getParser().parse(in);
        Entry entry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/model1"), (Object)entry.getBaseUri().getPath());
        Assert.assertEquals((Object)"model1", (Object)entry.getTitle());
        Assert.assertNotNull((Object)entry.getPublished());
        Assert.assertNotNull((Object)entry.getAuthor().getName());
        Assert.assertEquals((Object)"desc for model1", (Object)entry.getSummary());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/model1/binary"), (Object)entry.getContentSrc().getPath());
        ExtensibleElement metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        ExtensibleElement archivedExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.ARCHIVED);
        Assert.assertEquals((Object)"false", (Object)archivedExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement stateExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.STATE);
        Assert.assertEquals((Object)"Draft", (Object)stateExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement formatExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.FORMAT);
        Assert.assertEquals((Object)"model.drl", (Object)formatExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement uuidExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.UUID);
        Assert.assertNotNull((Object)uuidExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement categoryExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.CATEGORIES);
        Assert.assertEquals((Object)"AssetPackageResourceTestCategory", (Object)categoryExtension.getSimpleExtension(Translator.VALUE));
    }

    @Test
    @RunAsClient
    public void testUpdateAssetFromAtom(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL + "rest/packages/restPackage1/assets/model5");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        InputStream in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        Document doc = this.abdera.getParser().parse(in);
        Entry entry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/model5"), (Object)entry.getBaseUri().getPath());
        Assert.assertEquals((Object)"model5", (Object)entry.getTitle());
        Assert.assertNotNull((Object)entry.getPublished());
        Assert.assertNotNull((Object)entry.getAuthor().getName());
        Assert.assertEquals((Object)"desc for model5", (Object)entry.getSummary());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/model5/binary"), (Object)entry.getContentSrc().getPath());
        ExtensibleElement metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        ExtensibleElement archivedExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.ARCHIVED);
        Assert.assertEquals((Object)"false", (Object)archivedExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement stateExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.STATE);
        Assert.assertEquals((Object)"Draft", (Object)stateExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement formatExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.FORMAT);
        Assert.assertEquals((Object)"model.drl", (Object)formatExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement uuidExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.UUID);
        Assert.assertNotNull((Object)uuidExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement categoryExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.CATEGORIES);
        Assert.assertEquals((Object)"AssetPackageResourceTestCategory", (Object)categoryExtension.getSimpleExtension(Translator.VALUE));
        connection.disconnect();
        categoryExtension.addSimpleExtension(Translator.VALUE, "AssetPackageResourceTestCategory2");
        stateExtension.getExtension(Translator.VALUE).setText("Dev");
        formatExtension.getExtension(Translator.VALUE).setText("anotherformat");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/atom+xml");
        connection.setDoOutput(true);
        entry.writeTo(connection.getOutputStream());
        Assert.assertEquals((long)204L, (long)connection.getResponseCode());
        connection.disconnect();
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        doc = this.abdera.getParser().parse(in);
        entry = (Entry)doc.getRoot();
        metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        archivedExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.ARCHIVED);
        Assert.assertEquals((Object)"false", (Object)archivedExtension.getSimpleExtension(Translator.VALUE));
        stateExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.STATE);
        Assert.assertEquals((Object)"Dev", (Object)stateExtension.getSimpleExtension(Translator.VALUE));
        formatExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.FORMAT);
        Assert.assertEquals((Object)"anotherformat", (Object)formatExtension.getSimpleExtension(Translator.VALUE));
        categoryExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.CATEGORIES);
        List categoryValues = categoryExtension.getExtensions(Translator.VALUE);
        Assert.assertTrue((categoryValues.size() == 2 ? 1 : 0) != 0);
        boolean foundCategory1 = false;
        boolean foundCategory2 = false;
        for (Element cat : categoryValues) {
            String catgoryValue = cat.getText();
            if ("AssetPackageResourceTestCategory".equals(catgoryValue)) {
                foundCategory1 = true;
            }
            if (!"AssetPackageResourceTestCategory2".equals(catgoryValue)) continue;
            foundCategory2 = true;
        }
        Assert.assertTrue((boolean)foundCategory1);
        Assert.assertTrue((boolean)foundCategory2);
        url = new URL(baseURL, "rest/packages/restPackage1/assets/model5/source");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "text/plain");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"text/plain", (Object)connection.getContentType());
        String result = IOUtils.toString((InputStream)connection.getInputStream());
        Assert.assertTrue((boolean)result.contains("declare Album5"));
        Assert.assertTrue((boolean)result.contains("genre5: String"));
    }

    @Test
    @RunAsClient
    public void testUpdateAssetFromAtomWithStateNotExist(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL + "rest/packages/restPackage1/assets/model6");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        InputStream in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        Document doc = this.abdera.getParser().parse(in);
        Entry entry = (Entry)doc.getRoot();
        ExtensibleElement metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        ExtensibleElement stateExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.STATE);
        stateExtension.getExtension(Translator.VALUE).setText("NonExistState");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-type", "application/atom+xml");
        connection.setDoOutput(true);
        entry.writeTo(connection.getOutputStream());
        Assert.assertEquals((long)500L, (long)connection.getResponseCode());
        connection.disconnect();
    }

    @Test
    @RunAsClient
    public void testGetAssetAsJaxB(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/model1");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/xml", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    public void testGetAssetAsJson(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/model1");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/json", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    public void testGetAssetSource(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/model1/source");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "text/plain");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"text/plain", (Object)connection.getContentType());
        String result = IOUtils.toString((InputStream)connection.getInputStream());
        Assert.assertTrue((boolean)result.contains("declare Album2"));
        Assert.assertTrue((boolean)result.contains("genre2: String"));
    }

    @Test
    @RunAsClient
    public void testGetAssetBinary(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/model1/binary");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/octet-stream");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/octet-stream", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    public void testCreateAssetFromAtom(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        RequestOptions options = client.getDefaultRequestOptions();
        options.setAccept("application/atom+xml");
        ClientResponse resp = client.get(new URL(baseURL, "rest/packages/restPackage1/assets/model1-New").toExternalForm());
        Assert.assertEquals((long)404L, (long)resp.getStatus());
        client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        options = client.getDefaultRequestOptions();
        options.setAccept("application/atom+xml");
        resp = client.get(new URL(baseURL, "rest/packages/restPackage1/assets/model1").toExternalForm());
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)("Couldn't retrieve 'model1' asset-> " + resp.getStatus() + ": " + resp.getStatusText()));
        }
        Document doc = resp.getDocument();
        Entry entry = (Entry)doc.getRoot();
        ExtensibleElement metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        ExtensibleElement categoryExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.CATEGORIES);
        Assert.assertEquals((Object)"AssetPackageResourceTestCategory", (Object)categoryExtension.getSimpleExtension(Translator.VALUE));
        entry.setTitle(entry.getTitle() + "-New");
        client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        options = client.getDefaultRequestOptions();
        options.setContentType("application/atom+xml");
        resp = client.post(new URL(baseURL, "rest/packages/restPackage1/assets").toExternalForm(), (Base)entry, options);
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)("Couldn't store 'model1-New' asset-> " + resp.getStatus() + ": " + resp.getStatusText()));
        }
        client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        options = client.getDefaultRequestOptions();
        options.setAccept("application/atom+xml");
        resp = client.get(new URL(baseURL, "rest/packages/restPackage1/assets/model1-New").toExternalForm());
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)("Couldn't retrieve 'model1-New' asset-> " + resp.getStatus() + ": " + resp.getStatusText()));
        }
        doc = resp.getDocument();
        entry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)entry.getTitle(), (Object)"model1-New");
        ExtensibleElement metadataExtension2 = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        ExtensibleElement categoryExtension2 = (ExtensibleElement)metadataExtension2.getExtension(Translator.CATEGORIES);
        Assert.assertEquals((Object)"AssetPackageResourceTestCategory", (Object)categoryExtension2.getSimpleExtension(Translator.VALUE));
    }

    @Test
    @RunAsClient
    @Ignore
    public void testUpdateAssetFromJaxB(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/model1");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Asset.class});
        Unmarshaller un = context.createUnmarshaller();
        Asset a = (Asset)un.unmarshal((Reader)br);
        a.setDescription("An updated description.");
        a.setPublished(new Date(System.currentTimeMillis()));
        connection.disconnect();
        HttpURLConnection conn2 = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        Marshaller ma = context.createMarshaller();
        conn2.setRequestMethod("PUT");
        conn2.setRequestProperty("Content-Type", "application/xml");
        conn2.setRequestProperty("Content-Length", Integer.toString(a.toString().getBytes().length));
        conn2.setUseCaches(false);
        conn2.setDoInput(true);
        conn2.setDoOutput(true);
        ma.marshal((Object)a, conn2.getOutputStream());
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        conn2.disconnect();
    }

    @Test
    @RunAsClient
    @Ignore
    public void testUpdateAssetFromJson(@ArquillianResource URL baseURL) throws Exception {
    }

    @Test
    @RunAsClient
    public void testAssetNotExists(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/restNotExistingAsset");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
    }
}

