/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.jaxrs;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.protocol.Response;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.drools.guvnor.server.jaxrs.Translator;
import org.drools.guvnor.server.jaxrs.jaxb.Package;
import org.drools.guvnor.server.jaxrs.jaxb.PackageMetadata;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.utils.IOUtils;
import org.drools.util.codec.Base64;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class BasicPackageResourceIntegrationTest
extends GuvnorIntegrationTest {
    private Abdera abdera = new Abdera();

    public BasicPackageResourceIntegrationTest() {
        this.autoLoginAsAdmin = false;
    }

    @Test
    @InSequence(value=-1)
    public void startServers() throws Exception {
        this.loginAs("admin");
        ModuleItem pkg = this.rulesRepository.createModule("restPackage1", "this is package restPackage1");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Cheese\n global org.drools.Person customer1", (ModuleItem)pkg);
        AssetItem func = pkg.addAsset("func", "");
        func.updateFormat("function");
        func.updateContent("function void foo() { System.out.println(\"version 1\"); }");
        func.checkin("version 1");
        AssetItem dsl = pkg.addAsset("myDSL", "");
        dsl.updateFormat("dsl");
        dsl.updateContent("[then]call a func=foo();\n[when]foo=FooBarBaz1()");
        dsl.checkin("version 1");
        AssetItem rule = pkg.addAsset("rule1", "");
        rule.updateFormat("drl");
        rule.updateContent("rule 'foo' when Goo1() then end");
        rule.checkin("version 1");
        AssetItem rule2 = pkg.addAsset("rule2", "");
        rule2.updateFormat("dslr");
        rule2.updateContent("when \n foo \n then \n call a func");
        rule2.checkin("version 1");
        AssetItem rule3 = pkg.addAsset("model1", "");
        rule3.updateFormat("model.drl");
        rule3.updateContent("declare Album1\n genre1: String \n end");
        rule3.checkin("version 1");
        AssetItem rule4 = pkg.addAsset("rule4", "");
        rule4.updateFormat("drl");
        rule4.updateContent("rule 'nheron' when Cheese() then end");
        rule4.checkin("version 1");
        pkg.checkin("version2");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Cheese\n global org.drools.Person customer2", (ModuleItem)pkg);
        func.updateContent("function void foo() { System.out.println(\"version 2\"); }");
        func.checkin("version 2");
        dsl.updateContent("[then]call a func=foo();\n[when]foo=Cheese()");
        dsl.checkin("version 2");
        rule.updateContent("rule 'foo' when Cheese() then end");
        rule.checkin("version 2");
        rule2.updateContent("when \n foo \n then \n call a func");
        rule2.checkin("version 2");
        rule3.updateContent("declare Album2\n genre2: String \n end");
        rule3.checkin("version 2");
        pkg.checkin("version3");
        ModuleItem pkg2 = this.rulesRepository.createModule("restPackage2", "this is package restPackage2");
        pkg2.checkout();
        this.repositoryPackageService.buildPackage(pkg2.getUUID(), true);
        pkg2.checkin("version2");
        pkg2.checkout();
        this.repositoryPackageService.buildPackage(pkg2.getUUID(), true);
        pkg2.checkin("version3");
        ModuleItem pkg3 = this.rulesRepository.createModule("restPackageCompilationFailure", "this is package restPackageCompilationFailure");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.NonExistingClass", (ModuleItem)pkg3);
        AssetItem brokenRule = pkg3.addAsset("ruleCompilationFailure", "");
        brokenRule.updateFormat("drl");
        brokenRule.updateContent("rule 'compilationFailure' when NonExistingClass() then end");
        brokenRule.checkin("version 1");
        pkg3.checkin("version2");
        this.logoutAs("admin");
    }

    @Test
    @RunAsClient
    public void testBasicAuthenticationInvalidPassword(@ArquillianResource URL baseURL) throws MalformedURLException, IOException {
        URL url = new URL(baseURL, "rest/packages");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        byte[] authEncBytes = Base64.encodeBase64((byte[])"admin:invalidPassword".getBytes());
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.connect();
        Assert.assertEquals((long)401L, (long)connection.getResponseCode());
    }

    @Test
    @RunAsClient
    public void testBasicAuthentication(@ArquillianResource URL baseURL) throws MalformedURLException, IOException {
        URL url = new URL(baseURL, "rest/packages");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        byte[] authEncBytes = Base64.encodeBase64((byte[])"admin:admin".getBytes());
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    public void testGetPackagesForJSON(@ArquillianResource URL baseURL) throws MalformedURLException, IOException {
        URL url = new URL(baseURL, "rest/packages");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/json", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    public void testGetPackagesForXML(@ArquillianResource URL baseURL) throws MalformedURLException, IOException {
        URL url = new URL(baseURL, "rest/packages");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/xml", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    public void testGetPackagesForAtom(@ArquillianResource URL baseURL) throws MalformedURLException, IOException {
        URL url = new URL(baseURL, "rest/packages");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        InputStream in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        Document doc = this.abdera.getParser().parse(in);
        Feed feed = (Feed)doc.getRoot();
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages"), (Object)feed.getBaseUri().getPath());
        Assert.assertEquals((Object)"Packages", (Object)feed.getTitle());
        List entries = feed.getEntries();
        Assert.assertEquals((long)4L, (long)entries.size());
        Iterator it = entries.iterator();
        boolean foundPackageEntry = false;
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            if (!"restPackage1".equals(entry.getTitle())) continue;
            foundPackageEntry = true;
            List links = entry.getLinks();
            Assert.assertEquals((long)1L, (long)links.size());
            Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1"), (Object)((Link)links.get(0)).getHref().getPath());
        }
        Assert.assertTrue((boolean)foundPackageEntry);
    }

    @Test
    @RunAsClient
    public void testGetPackageForJSON(@ArquillianResource URL baseURL) throws MalformedURLException, IOException {
        URL url = new URL(baseURL, "rest/packages/restPackage1");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/json", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    public void testGetPackageForXML(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/xml", (Object)connection.getContentType());
        Package p = this.unmarshalPackageXML(connection.getInputStream());
        Assert.assertEquals((Object)"restPackage1", (Object)p.getTitle());
        Assert.assertEquals((Object)"this is package restPackage1", (Object)p.getDescription());
        Assert.assertNotNull((Object)p.getAuthor());
        Assert.assertNotNull((Object)p.getPublished());
        Assert.assertEquals((Object)new URL(baseURL, "rest/packages/restPackage1/source").toExternalForm(), (Object)p.getSourceLink().toString());
        Assert.assertEquals((Object)new URL(baseURL, "rest/packages/restPackage1/binary").toExternalForm(), (Object)p.getBinaryLink().toString());
        PackageMetadata pm = p.getMetadata();
        Assert.assertFalse((boolean)pm.isArchived());
        Assert.assertNotNull((Object)pm.getCreated());
        Assert.assertNotNull((Object)pm.getUuid());
        Assert.assertEquals((Object)"version3", (Object)pm.getCheckinComment());
        Assert.assertEquals((long)3L, (long)pm.getVersionNumber());
        Set assetsURI = p.getAssets();
        Assert.assertEquals((long)7L, (long)assetsURI.size());
        Assert.assertTrue((boolean)assetsURI.contains(new URL(baseURL, "rest/packages/restPackage1/assets/drools").toURI()));
        Assert.assertTrue((boolean)assetsURI.contains(new URL(baseURL, "rest/packages/restPackage1/assets/func").toURI()));
        Assert.assertTrue((boolean)assetsURI.contains(new URL(baseURL, "rest/packages/restPackage1/assets/myDSL").toURI()));
        Assert.assertTrue((boolean)assetsURI.contains(new URL(baseURL, "rest/packages/restPackage1/assets/rule1").toURI()));
        Assert.assertTrue((boolean)assetsURI.contains(new URL(baseURL, "rest/packages/restPackage1/assets/rule2").toURI()));
        Assert.assertTrue((boolean)assetsURI.contains(new URL(baseURL, "rest/packages/restPackage1/assets/rule4").toURI()));
        Assert.assertTrue((boolean)assetsURI.contains(new URL(baseURL, "rest/packages/restPackage1/assets/model1").toURI()));
    }

    @Test
    @RunAsClient
    public void testGetPackageForAtom(@ArquillianResource URL baseURL) throws MalformedURLException, IOException {
        URL url = new URL(baseURL, "rest/packages/restPackage1");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        InputStream in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        Document doc = this.abdera.getParser().parse(in);
        Entry entry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1"), (Object)entry.getBaseUri().getPath());
        Assert.assertEquals((Object)"restPackage1", (Object)entry.getTitle());
        Assert.assertNotNull((Object)entry.getPublished());
        Assert.assertNotNull((Object)entry.getAuthor().getName());
        Assert.assertEquals((Object)"this is package restPackage1", (Object)entry.getSummary());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/binary"), (Object)entry.getContentSrc().getPath());
        List links = entry.getLinks();
        Assert.assertEquals((long)7L, (long)links.size());
        HashMap<String, Link> linksMap = new HashMap<String, Link>();
        for (Link link : links) {
            linksMap.put(link.getTitle(), link);
        }
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/drools"), (Object)((Link)linksMap.get("drools")).getHref().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/func"), (Object)((Link)linksMap.get("func")).getHref().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/myDSL"), (Object)((Link)linksMap.get("myDSL")).getHref().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/rule1"), (Object)((Link)linksMap.get("rule1")).getHref().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/rule2"), (Object)((Link)linksMap.get("rule2")).getHref().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/rule4"), (Object)((Link)linksMap.get("rule4")).getHref().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/model1"), (Object)((Link)linksMap.get("model1")).getHref().getPath());
        ExtensibleElement metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        ExtensibleElement archivedExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.ARCHIVED);
        Assert.assertEquals((Object)"false", (Object)archivedExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement uuidExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.UUID);
        Assert.assertNotNull((Object)uuidExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement checkinCommentExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.CHECKIN_COMMENT);
        Assert.assertEquals((Object)"version3", (Object)checkinCommentExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement versionNumberExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.VERSION_NUMBER);
        Assert.assertEquals((Object)"3", (Object)versionNumberExtension.getSimpleExtension(Translator.VALUE));
    }

    @Test
    @RunAsClient
    public void testCreatePackageFromJAXB(@ArquillianResource URL baseURL) throws Exception {
        Package p = this.createTestPackage("TestCreatePackageFromJAXB");
        p.setDescription("desc for testCreatePackageFromJAXB");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{p.getClass()});
        Marshaller marshaller = context.createMarshaller();
        StringWriter sw = new StringWriter();
        marshaller.marshal((Object)p, (Writer)sw);
        String xml = sw.toString();
        URL url = new URL(baseURL, "rest/packages");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/xml");
        connection.setRequestProperty("Content-Type", "application/xml");
        connection.setRequestProperty("Content-Length", Integer.toString(xml.getBytes().length));
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
        wr.writeBytes(xml);
        wr.flush();
        wr.close();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/xml", (Object)connection.getContentType());
        Package result = this.unmarshalPackageXML(connection.getInputStream());
        Assert.assertEquals((Object)"TestCreatePackageFromJAXB", (Object)result.getTitle());
        Assert.assertEquals((Object)"desc for testCreatePackageFromJAXB", (Object)result.getDescription());
        Assert.assertNotNull((Object)result.getPublished());
        Assert.assertEquals((Object)new URL(baseURL, "rest/packages/TestCreatePackageFromJAXB/source").toExternalForm(), (Object)result.getSourceLink().toString());
        Assert.assertEquals((Object)new URL(baseURL, "rest/packages/TestCreatePackageFromJAXB/binary").toExternalForm(), (Object)result.getBinaryLink().toString());
        PackageMetadata pm = result.getMetadata();
        Assert.assertFalse((boolean)pm.isArchived());
        Assert.assertNotNull((Object)pm.getCreated());
        Assert.assertNotNull((Object)pm.getUuid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @RunAsClient
    public void testCreatePackageFromDRLAsEntry(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.setDoOutput(true);
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.getClass().getResourceAsStream("simple_rules.drl");
            out = connection.getOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @RunAsClient
    public void testCreatePackageFromDRLAsJson(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestProperty("Accept", "application/json");
        connection.setDoOutput(true);
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.getClass().getResourceAsStream("simple_rules2.drl");
            out = connection.getOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/json", (Object)connection.getContentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @RunAsClient
    public void testCreatePackageFromDRLAsJaxB(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestProperty("Accept", "application/xml");
        connection.setDoOutput(true);
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.getClass().getResourceAsStream("simple_rules3.drl");
            out = connection.getOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/xml", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    public void testCreateAndUpdateAndDeletePackageFromAtom(@ArquillianResource URL baseURL) throws Exception {
        Abdera abdera = new Abdera();
        AbderaClient client = new AbderaClient(abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        Entry entry = abdera.newEntry();
        entry.setTitle("testCreatePackageFromAtom");
        entry.setSummary("desc for testCreatePackageFromAtom");
        ExtensibleElement extension = (ExtensibleElement)entry.addExtension(Translator.METADATA);
        ExtensibleElement childExtension = (ExtensibleElement)extension.addExtension(Translator.CHECKIN_COMMENT);
        childExtension.addSimpleExtension(Translator.VALUE, "checkin comment:initial desc for testCreatePackageFromAtom");
        ClientResponse resp = client.post(new URL(baseURL, "rest/packages").toExternalForm(), (Base)entry);
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        Document doc = resp.getDocument();
        Entry returnedEntry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/testCreatePackageFromAtom"), (Object)returnedEntry.getBaseUri().getPath());
        Assert.assertEquals((Object)"testCreatePackageFromAtom", (Object)returnedEntry.getTitle());
        Assert.assertEquals((Object)"desc for testCreatePackageFromAtom", (Object)returnedEntry.getSummary());
        ExtensibleElement metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        ExtensibleElement checkinCommentExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.CHECKIN_COMMENT);
        Assert.assertEquals((Object)"checkin comment:initial desc for testCreatePackageFromAtom", (Object)checkinCommentExtension.getSimpleExtension(Translator.VALUE));
        Entry e = abdera.newEntry();
        e.setTitle("testCreatePackageFromAtom");
        Link l = Abdera.getNewFactory().newLink();
        l.setHref(new URL(baseURL, "rest/packages/testCreatePackageFromAtom").toExternalForm());
        l.setRel("self");
        e.addLink(l);
        e.setSummary("updated desc for testCreatePackageFromAtom");
        e.addAuthor("Test McTesty");
        extension = (ExtensibleElement)e.addExtension(Translator.METADATA);
        childExtension = (ExtensibleElement)extension.addExtension(Translator.CHECKIN_COMMENT);
        childExtension.addSimpleExtension(Translator.VALUE, "checkin comment:updated desc for testCreatePackageFromAtom");
        resp = client.put(new URL(baseURL, "rest/packages/testCreatePackageFromAtom").toExternalForm(), (Base)e);
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        Assert.assertEquals((long)204L, (long)resp.getStatus());
        URL url1 = new URL(baseURL, "rest/packages/testCreatePackageFromAtom");
        HttpURLConnection conn1 = (HttpURLConnection)url1.openConnection();
        conn1.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        conn1.setRequestMethod("GET");
        conn1.setRequestProperty("Accept", "application/atom+xml");
        conn1.connect();
        Assert.assertEquals((long)200L, (long)conn1.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)conn1.getContentType());
        InputStream in = conn1.getInputStream();
        Assert.assertNotNull((Object)in);
        doc = abdera.getParser().parse(in);
        entry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/testCreatePackageFromAtom"), (Object)entry.getBaseUri().getPath());
        Assert.assertEquals((Object)"testCreatePackageFromAtom", (Object)entry.getTitle());
        Assert.assertNotNull((Object)entry.getPublished());
        Assert.assertNotNull((Object)entry.getAuthor().getName());
        Assert.assertEquals((Object)"updated desc for testCreatePackageFromAtom", (Object)entry.getSummary());
        metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        checkinCommentExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.CHECKIN_COMMENT);
        Assert.assertEquals((Object)"checkin comment:updated desc for testCreatePackageFromAtom", (Object)checkinCommentExtension.getSimpleExtension(Translator.VALUE));
        resp = client.delete(new URL(baseURL, "rest/packages/testCreatePackageFromAtom").toExternalForm());
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        URL url2 = new URL(baseURL, "rest/packages/testCreatePackageFromAtom");
        HttpURLConnection conn2 = (HttpURLConnection)url2.openConnection();
        conn2.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        conn2.setRequestMethod("GET");
        conn2.setRequestProperty("Accept", "application/atom+xml");
        conn2.connect();
        Assert.assertEquals((long)404L, (long)conn2.getResponseCode());
    }

    @Test
    @RunAsClient
    public void testRenamePackageFromAtom(@ArquillianResource URL baseURL) throws Exception {
        Abdera abdera = new Abdera();
        AbderaClient client = new AbderaClient(abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        Entry entry = abdera.newEntry();
        entry.setTitle("testRenamePackageFromAtom");
        entry.setSummary("desc for testRenamePackageFromAtom");
        ClientResponse resp = client.post(new URL(baseURL, "rest/packages").toExternalForm(), (Base)entry);
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        Document doc = resp.getDocument();
        Entry returnedEntry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/testRenamePackageFromAtom"), (Object)returnedEntry.getBaseUri().getPath());
        Assert.assertEquals((Object)"testRenamePackageFromAtom", (Object)returnedEntry.getTitle());
        Assert.assertEquals((Object)"desc for testRenamePackageFromAtom", (Object)returnedEntry.getSummary());
        Entry e = abdera.newEntry();
        e.setTitle("testRenamePackageFromAtomNew");
        Link l = Abdera.getNewFactory().newLink();
        l.setHref(new URL(baseURL, "rest/packages/testRenamePackageFromAtomNew").toExternalForm());
        l.setRel("self");
        e.addLink(l);
        e.setSummary("renamed package testRenamePackageFromAtom");
        e.addAuthor("Test McTesty");
        resp = client.put(new URL(baseURL, "rest/packages/testRenamePackageFromAtom").toExternalForm(), (Base)e);
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        Assert.assertEquals((long)204L, (long)resp.getStatus());
        URL url1 = new URL(baseURL, "rest/packages/testRenamePackageFromAtomNew");
        HttpURLConnection conn1 = (HttpURLConnection)url1.openConnection();
        conn1.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        conn1.setRequestMethod("GET");
        conn1.setRequestProperty("Accept", "application/atom+xml");
        conn1.connect();
        Assert.assertEquals((long)200L, (long)conn1.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)conn1.getContentType());
        InputStream in = conn1.getInputStream();
        Assert.assertNotNull((Object)in);
        doc = abdera.getParser().parse(in);
        entry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/testRenamePackageFromAtomNew"), (Object)entry.getBaseUri().getPath());
        Assert.assertEquals((Object)"testRenamePackageFromAtomNew", (Object)entry.getTitle());
        Assert.assertTrue((entry.getPublished() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"renamed package testRenamePackageFromAtom", (Object)entry.getSummary());
        URL url2 = new URL(baseURL, "rest/packages/testRenamePackageFromAtom");
        HttpURLConnection conn2 = (HttpURLConnection)url2.openConnection();
        conn2.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        conn2.setRequestMethod("GET");
        conn2.setRequestProperty("Accept", "application/atom+xml");
        conn2.connect();
        Assert.assertEquals((long)404L, (long)conn2.getResponseCode());
        resp = client.delete(new URL(baseURL, "rest/packages/testRenamePackageFromAtomNew").toExternalForm());
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        URL url3 = new URL(baseURL, "rest/packages/testRenamePackageFromAtomNew");
        HttpURLConnection conn3 = (HttpURLConnection)url3.openConnection();
        conn3.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        conn3.setRequestMethod("GET");
        conn3.setRequestProperty("Accept", "application/atom+xml");
        conn3.connect();
        Assert.assertEquals((long)404L, (long)conn3.getResponseCode());
    }

    @Test
    @RunAsClient
    public void testRenamePackageFromXML(@ArquillianResource URL baseURL) throws Exception {
        Package p = this.createTestPackage("testRenamePackageFromXML");
        p.setDescription("desc for testRenamePackageFromXML");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{p.getClass()});
        Marshaller marshaller = context.createMarshaller();
        StringWriter sw = new StringWriter();
        marshaller.marshal((Object)p, (Writer)sw);
        String xml = sw.toString();
        URL url = new URL(baseURL, "rest/packages");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/xml");
        connection.setRequestProperty("Content-Length", Integer.toString(xml.getBytes().length));
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty("Accept", "application/xml");
        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
        wr.writeBytes(xml);
        wr.flush();
        wr.close();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/xml", (Object)connection.getContentType());
        Package result = this.unmarshalPackageXML(connection.getInputStream());
        Assert.assertEquals((Object)"testRenamePackageFromXML", (Object)result.getTitle());
        Assert.assertEquals((Object)"desc for testRenamePackageFromXML", (Object)result.getDescription());
        Assert.assertNotNull((Object)result.getPublished());
        Assert.assertEquals((Object)new URL(baseURL, "rest/packages/testRenamePackageFromXML/source").toExternalForm(), (Object)result.getSourceLink().toString());
        Assert.assertEquals((Object)new URL(baseURL, "rest/packages/testRenamePackageFromXML/binary").toExternalForm(), (Object)result.getBinaryLink().toString());
        PackageMetadata pm = result.getMetadata();
        Assert.assertFalse((boolean)pm.isArchived());
        Assert.assertNotNull((Object)pm.getCreated());
        Assert.assertNotNull((Object)pm.getUuid());
        p.setDescription("renamed package testRenamePackageFromXML");
        p.setTitle("testRenamePackageFromXMLNew");
        JAXBContext context2 = JAXBContext.newInstance((Class[])new Class[]{p.getClass()});
        Marshaller marshaller2 = context2.createMarshaller();
        StringWriter sw2 = new StringWriter();
        marshaller2.marshal((Object)p, (Writer)sw2);
        String xml2 = sw2.toString();
        URL url2 = new URL(baseURL, "rest/packages/testRenamePackageFromXML");
        HttpURLConnection connection2 = (HttpURLConnection)url2.openConnection();
        connection2.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection2.setRequestMethod("PUT");
        connection2.setRequestProperty("Content-Type", "application/xml");
        connection2.setRequestProperty("Content-Length", Integer.toString(xml2.getBytes().length));
        connection2.setUseCaches(false);
        connection2.setDoOutput(true);
        OutputStreamWriter out = new OutputStreamWriter(connection2.getOutputStream());
        out.write(xml2);
        out.close();
        connection2.getInputStream();
        URL url3 = new URL(baseURL, "rest/packages/testRenamePackageFromXMLNew");
        HttpURLConnection conn3 = (HttpURLConnection)url3.openConnection();
        conn3.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        conn3.setRequestMethod("GET");
        conn3.setRequestProperty("Accept", "application/atom+xml");
        conn3.connect();
        Assert.assertEquals((long)200L, (long)conn3.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)conn3.getContentType());
        InputStream in = conn3.getInputStream();
        Assert.assertNotNull((Object)in);
        Document doc = this.abdera.getParser().parse(in);
        Entry entry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/testRenamePackageFromXMLNew"), (Object)entry.getBaseUri().getPath());
        Assert.assertEquals((Object)"testRenamePackageFromXMLNew", (Object)entry.getTitle());
        Assert.assertTrue((entry.getPublished() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"renamed package testRenamePackageFromXML", (Object)entry.getSummary());
        URL url4 = new URL(baseURL, "rest/packages/testRenamePackageFromXML");
        HttpURLConnection conn4 = (HttpURLConnection)url4.openConnection();
        conn4.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        conn4.setRequestMethod("GET");
        conn4.setRequestProperty("Accept", "application/atom+xml");
        conn4.connect();
        Assert.assertEquals((long)404L, (long)conn4.getResponseCode());
        Abdera abdera = new Abdera();
        AbderaClient client = new AbderaClient(abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        ClientResponse resp = client.delete(new URL(baseURL, "rest/packages/testRenamePackageFromXMLNew").toExternalForm());
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        URL url5 = new URL(baseURL, "rest/packages/testRenamePackageFromXMLNew");
        HttpURLConnection conn5 = (HttpURLConnection)url5.openConnection();
        conn5.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        conn5.setRequestMethod("GET");
        conn5.setRequestProperty("Accept", "application/atom+xml");
        conn5.connect();
        Assert.assertEquals((long)404L, (long)conn5.getResponseCode());
    }

    @Ignore
    @Test
    @RunAsClient
    public void testCreatePackageFromJson(@ArquillianResource URL baseURL) {
    }

    @Test
    @RunAsClient
    public void testCreatePackageSnapshot(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/snapshot/testsnapshot");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        Assert.assertEquals((long)204L, (long)connection.getResponseCode());
    }

    @Test
    @RunAsClient
    public void testPackageNotExists(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restNotExistingPackage");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
    }

    @Test
    @RunAsClient
    public void testGetPackageSource(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/source");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "*/*");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"text/plain", (Object)connection.getContentType());
        String result = IOUtils.toString((InputStream)connection.getInputStream());
        Assert.assertEquals((Object)"attachment; filename=restPackage1", (Object)connection.getHeaderField("Content-Disposition"));
        Assert.assertTrue((result.indexOf("package restPackage1") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("import org.drools.Cheese") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("global org.drools.Person customer2") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("function void foo() { System.out.println(\"version 2\"); }") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("declare Album2") >= 0 ? 1 : 0) != 0);
    }

    @Test
    @RunAsClient
    public void testGetPackageBinary(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackageCompilationFailure/binary");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/octet-stream");
        connection.connect();
        Assert.assertEquals((long)500L, (long)connection.getResponseCode());
        URL url2 = new URL(baseURL, "rest/packages/restPackage2/binary");
        HttpURLConnection connection2 = (HttpURLConnection)url2.openConnection();
        connection2.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection2.setRequestMethod("GET");
        connection2.setRequestProperty("Accept", "application/octet-stream");
        connection2.connect();
        Assert.assertEquals((long)200L, (long)connection2.getResponseCode());
        Assert.assertEquals((Object)"application/octet-stream", (Object)connection2.getContentType());
    }

    @Test
    @RunAsClient
    public void testUpdatePackageFromJAXB(@ArquillianResource URL baseURL) throws Exception {
        Package p = this.createTestPackage("testUpdatePackageFromJAXB");
        p.setDescription("desc for testUpdatePackageFromJAXB");
        p.getMetadata().setCheckinComment("checkincomment for testUpdatePackageFromJAXB");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{p.getClass()});
        Marshaller marshaller = context.createMarshaller();
        StringWriter sw = new StringWriter();
        marshaller.marshal((Object)p, (Writer)sw);
        String xml = sw.toString();
        URL url = new URL(baseURL, "rest/packages");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/xml");
        connection.setRequestProperty("Content-Length", Integer.toString(xml.getBytes().length));
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty("Accept", "application/xml");
        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
        wr.writeBytes(xml);
        wr.flush();
        wr.close();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/xml", (Object)connection.getContentType());
        Package result = this.unmarshalPackageXML(connection.getInputStream());
        Assert.assertEquals((Object)"testUpdatePackageFromJAXB", (Object)result.getTitle());
        Assert.assertEquals((Object)"desc for testUpdatePackageFromJAXB", (Object)result.getDescription());
        Assert.assertNotNull((Object)result.getPublished());
        Assert.assertEquals((Object)new URL(baseURL, "rest/packages/testUpdatePackageFromJAXB/source").toExternalForm(), (Object)result.getSourceLink().toString());
        Assert.assertEquals((Object)new URL(baseURL, "rest/packages/testUpdatePackageFromJAXB/binary").toExternalForm(), (Object)result.getBinaryLink().toString());
        PackageMetadata pm = result.getMetadata();
        Assert.assertFalse((boolean)pm.isArchived());
        Assert.assertNotNull((Object)pm.getCreated());
        Assert.assertNotNull((Object)pm.getUuid());
        Assert.assertEquals((Object)"checkincomment for testUpdatePackageFromJAXB", (Object)pm.getCheckinComment());
        Package p2 = this.createTestPackage("testUpdatePackageFromJAXB");
        p2.setDescription("update package testUpdatePackageFromJAXB");
        PackageMetadata meta = new PackageMetadata();
        meta.setCheckinComment("checkInComment: update package testUpdatePackageFromJAXB");
        p2.setMetadata(meta);
        JAXBContext context2 = JAXBContext.newInstance((Class[])new Class[]{p2.getClass()});
        Marshaller marshaller2 = context2.createMarshaller();
        StringWriter sw2 = new StringWriter();
        marshaller2.marshal((Object)p2, (Writer)sw2);
        String xml2 = sw2.toString();
        URL url2 = new URL(baseURL, "rest/packages/testUpdatePackageFromJAXB");
        HttpURLConnection connection2 = (HttpURLConnection)url2.openConnection();
        connection2.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection2.setRequestMethod("PUT");
        connection2.setRequestProperty("Content-Type", "application/xml");
        connection2.setRequestProperty("Content-Length", Integer.toString(xml2.getBytes().length));
        connection2.setUseCaches(false);
        connection2.setDoOutput(true);
        OutputStreamWriter out = new OutputStreamWriter(connection2.getOutputStream());
        out.write(xml2);
        out.close();
        connection2.getInputStream();
        URL url3 = new URL(baseURL, "rest/packages/testUpdatePackageFromJAXB");
        HttpURLConnection connection3 = (HttpURLConnection)url3.openConnection();
        connection3.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection3.setRequestMethod("GET");
        connection3.setRequestProperty("Accept", "application/xml");
        connection3.connect();
        Assert.assertEquals((long)200L, (long)connection3.getResponseCode());
        Assert.assertEquals((Object)"application/xml", (Object)connection3.getContentType());
        Package p3 = this.unmarshalPackageXML(connection3.getInputStream());
        Assert.assertEquals((Object)"testUpdatePackageFromJAXB", (Object)p3.getTitle());
        Assert.assertEquals((Object)"update package testUpdatePackageFromJAXB", (Object)p3.getDescription());
        Assert.assertNotNull((Object)p3.getPublished());
        Assert.assertEquals((Object)new URL(baseURL, "rest/packages/testUpdatePackageFromJAXB/source").toExternalForm(), (Object)p3.getSourceLink().toString());
        Assert.assertEquals((Object)new URL(baseURL, "rest/packages/testUpdatePackageFromJAXB/binary").toExternalForm(), (Object)p3.getBinaryLink().toString());
        PackageMetadata pm3 = p3.getMetadata();
        Assert.assertFalse((boolean)pm3.isArchived());
        Assert.assertNotNull((Object)pm3.getCreated());
        Assert.assertNotNull((Object)pm3.getUuid());
        Assert.assertEquals((Object)"checkInComment: update package testUpdatePackageFromJAXB", (Object)pm3.getCheckinComment());
    }

    @Ignore
    @Test
    @RunAsClient
    public void testUpdatePackageFromJson(@ArquillianResource URL baseURL) {
    }

    @Test
    @RunAsClient
    public void testGetPackageVersionsForAtom(@ArquillianResource URL baseURL) throws MalformedURLException, IOException {
        URL url = new URL(baseURL, "rest/packages/restPackage1/versions");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        InputStream in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        Document doc = this.abdera.getParser().parse(in);
        Feed feed = (Feed)doc.getRoot();
        Assert.assertEquals((Object)"Version history of restPackage1", (Object)feed.getTitle());
        List entries = feed.getEntries();
        Assert.assertEquals((long)3L, (long)entries.size());
        HashMap<String, Entry> entriesMap = new HashMap<String, Entry>();
        for (Entry entry : entries) {
            entriesMap.put(entry.getTitle(), entry);
        }
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/versions/1"), (Object)((Link)((Entry)entriesMap.get("1")).getLinks().get(0)).getHref().getPath());
        Assert.assertTrue((((Entry)entriesMap.get("1")).getUpdated() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/versions/2"), (Object)((Link)((Entry)entriesMap.get("2")).getLinks().get(0)).getHref().getPath());
        Assert.assertTrue((((Entry)entriesMap.get("2")).getUpdated() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/versions/3"), (Object)((Link)((Entry)entriesMap.get("3")).getLinks().get(0)).getHref().getPath());
        Assert.assertTrue((((Entry)entriesMap.get("3")).getUpdated() != null ? 1 : 0) != 0);
    }

    @Test
    @RunAsClient
    public void testGetHistoricalPackageForAtom(@ArquillianResource URL baseURL) throws MalformedURLException, IOException {
        URL url = new URL(baseURL, "rest/packages/restPackage1/versions/2");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        InputStream in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        Document doc = this.abdera.getParser().parse(in);
        Entry entry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/versions/2"), (Object)entry.getBaseUri().getPath());
        Assert.assertEquals((Object)"restPackage1", (Object)entry.getTitle());
        Assert.assertEquals((Object)"this is package restPackage1", (Object)entry.getSummary());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/versions/2/binary"), (Object)entry.getContentSrc().getPath());
        List links = entry.getLinks();
        Assert.assertEquals((long)7L, (long)links.size());
        HashMap<String, Link> linksMap = new HashMap<String, Link>();
        for (Link link : links) {
            linksMap.put(link.getTitle(), link);
        }
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/versions/2/assets/drools"), (Object)((Link)linksMap.get("drools")).getHref().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/versions/2/assets/func"), (Object)((Link)linksMap.get("func")).getHref().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/versions/2/assets/myDSL"), (Object)((Link)linksMap.get("myDSL")).getHref().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/versions/2/assets/rule1"), (Object)((Link)linksMap.get("rule1")).getHref().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/versions/2/assets/rule2"), (Object)((Link)linksMap.get("rule2")).getHref().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/versions/2/assets/model1"), (Object)((Link)linksMap.get("model1")).getHref().getPath());
        ExtensibleElement metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        ExtensibleElement archivedExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.ARCHIVED);
        Assert.assertEquals((Object)"false", (Object)archivedExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement uuidExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.UUID);
        Assert.assertNotNull((Object)uuidExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement checkinCommentExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.CHECKIN_COMMENT);
        Assert.assertEquals((Object)"version2", (Object)checkinCommentExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement versionNumberExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.VERSION_NUMBER);
        Assert.assertEquals((Object)"2", (Object)versionNumberExtension.getSimpleExtension(Translator.VALUE));
    }

    @Test
    @RunAsClient
    public void testGetHistoricalPackageSource(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/versions/2/source");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "*/*");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"text/plain", (Object)connection.getContentType());
        String result = IOUtils.toString((InputStream)connection.getInputStream());
        Assert.assertTrue((boolean)result.contains("package restPackage1"));
        Assert.assertTrue((boolean)result.contains("import org.drools.Cheese"));
        Assert.assertTrue((boolean)result.contains("global org.drools.Person customer1"));
        Assert.assertTrue((boolean)result.contains("function void foo() { System.out.println(\"version 1\"); }"));
        Assert.assertTrue((boolean)result.contains("declare Album1"));
    }

    @Test
    @RunAsClient
    public void testGetHistoricalPackageBinary(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage2/versions/2/binary");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/octet-stream");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/octet-stream", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    public void testUpdateAndGetAssetSource(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/rule4/source");
        HttpURLConnection connection1 = (HttpURLConnection)url.openConnection();
        connection1.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection1.setRequestMethod("GET");
        connection1.setRequestProperty("Accept", "text/plain");
        connection1.connect();
        Assert.assertEquals((long)200L, (long)connection1.getResponseCode());
        Assert.assertEquals((Object)"text/plain", (Object)connection1.getContentType());
        String newContent = "rule 'nheron' when Goo1() then end";
        URL url2 = new URL(baseURL, "rest/packages/restPackage1/assets/rule4/source");
        HttpURLConnection connection2 = (HttpURLConnection)url2.openConnection();
        connection2.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection2.setDoOutput(true);
        connection2.setRequestMethod("PUT");
        connection2.setRequestProperty("Accept", "application/xml");
        connection2.setRequestProperty("Content-Type", "text/plain");
        OutputStreamWriter out = new OutputStreamWriter(connection2.getOutputStream());
        out.write(newContent);
        out.close();
        connection2.getInputStream();
        Assert.assertEquals((long)204L, (long)connection2.getResponseCode());
        URL url3 = new URL(baseURL, "rest/packages/restPackage1/assets/rule4/source");
        HttpURLConnection connection3 = (HttpURLConnection)url3.openConnection();
        connection3.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection3.setRequestMethod("GET");
        connection3.setRequestProperty("Accept", "text/plain");
        connection3.connect();
        Assert.assertEquals((long)200L, (long)connection3.getResponseCode());
        Assert.assertEquals((Object)"text/plain", (Object)connection3.getContentType());
        String result = IOUtils.toString((InputStream)connection3.getInputStream());
        Assert.assertEquals((Object)result, (Object)newContent);
    }

    @Test
    @RunAsClient
    public void testCreateAndUpdateAndGetBinaryAsset(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/Error-image");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        byte[] authEncBytes = Base64.encodeBase64((byte[])"admin:admin".getBytes());
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.connect();
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
        url = new URL(baseURL, "rest/packages/restPackage1/assets");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.setRequestProperty("Slug", "Error-image.gif");
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.setDoOutput(true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[1000];
        int count = 0;
        InputStream is = this.getClass().getResourceAsStream("Error-image.gif");
        while ((count = is.read(data, 0, 1000)) != -1) {
            out.write(data, 0, count);
        }
        connection.getOutputStream().write(out.toByteArray());
        out.close();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        url = new URL(baseURL, "rest/packages/restPackage1/assets/Error-image");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        InputStream in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        Document doc = this.abdera.getParser().parse(in);
        Entry entry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)"Error-image", (Object)entry.getTitle());
        ExtensibleElement metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        ExtensibleElement formatExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.FORMAT);
        Assert.assertEquals((Object)"gif", (Object)formatExtension.getSimpleExtension(Translator.VALUE));
        Assert.assertTrue((entry.getPublished() != null ? 1 : 0) != 0);
        url = new URL(baseURL, "rest/packages/restPackage1/assets/Error-image/binary");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/octet-stream");
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/octet-stream", (Object)connection.getContentType());
        in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        url = new URL(baseURL, "rest/packages/restPackage1/assets/Error-image/binary");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Accept", "application/xml");
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        byte[] data2 = new byte[1000];
        int count2 = 0;
        InputStream is2 = this.getClass().getResourceAsStream("Error-image-new.gif");
        while ((count2 = is2.read(data2, 0, 1000)) != -1) {
            out2.write(data2, 0, count2);
        }
        connection.getOutputStream().write(out2.toByteArray());
        out2.close();
        Assert.assertEquals((long)204L, (long)connection.getResponseCode());
        url = new URL(baseURL, "rest/packages/restPackage1/assets/Error-image");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.connect();
        Assert.assertEquals((long)204L, (long)connection.getResponseCode());
        url = new URL(baseURL, "rest/packages/restPackage1/assets/Error-image");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.connect();
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
    }

    @Test
    @RunAsClient
    public void testGetSourceContentFromBinaryAsset(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/Error-image-new");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
        url = new URL(baseURL, "rest/packages/restPackage1/assets");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.setRequestProperty("Slug", "Error-image-new");
        connection.setDoOutput(true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[1000];
        int count = 0;
        InputStream is = this.getClass().getResourceAsStream("Error-image.gif");
        while ((count = is.read(data, 0, 1000)) != -1) {
            out.write(data, 0, count);
        }
        connection.getOutputStream().write(out.toByteArray());
        out.close();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        url = new URL(baseURL, "rest/packages/restPackage1/assets/Error-image-new/source");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "text/plain");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"text/plain", (Object)connection.getContentType());
        String result = IOUtils.toString((InputStream)connection.getInputStream());
        Assert.assertNotNull((Object)result);
        url = new URL(baseURL, "rest/packages/restPackage1/assets/Error-image-new");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("DELETE");
        connection.connect();
        Assert.assertEquals((long)204L, (long)connection.getResponseCode());
        url = new URL(baseURL, "rest/packages/restPackage1/assets/Error-image-new");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
    }

    @Test
    @RunAsClient
    public void testGetBinaryContentFromNonBinaryAsset(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/model1/binary");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/octet-stream");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/octet-stream", (Object)connection.getContentType());
        String result = IOUtils.toString((InputStream)connection.getInputStream());
        Assert.assertTrue((result.indexOf("declare Album2") > -1 ? 1 : 0) != 0);
    }

    @Test
    @RunAsClient
    public void testGetAssetVersionsForAtom(@ArquillianResource URL baseURL) throws MalformedURLException, IOException {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/model1/versions");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        InputStream in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        Document doc = this.abdera.getParser().parse(in);
        Feed feed = (Feed)doc.getRoot();
        Assert.assertEquals((Object)"Version history of model1", (Object)feed.getTitle());
        List entries = feed.getEntries();
        Assert.assertEquals((long)2L, (long)entries.size());
        HashMap<String, Entry> entriesMap = new HashMap<String, Entry>();
        for (Entry entry : entries) {
            entriesMap.put(entry.getTitle(), entry);
        }
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/model1/versions/1"), (Object)((Link)((Entry)entriesMap.get("1")).getLinks().get(0)).getHref().getPath());
        Assert.assertTrue((((Entry)entriesMap.get("1")).getUpdated() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/model1/versions/2"), (Object)((Link)((Entry)entriesMap.get("2")).getLinks().get(0)).getHref().getPath());
        Assert.assertTrue((((Entry)entriesMap.get("2")).getUpdated() != null ? 1 : 0) != 0);
    }

    @Test
    @RunAsClient
    @Ignore(value="Verify this test once we get Arquillian working")
    public void testGetAssetVersionsAfterUpdatingSource(@ArquillianResource URL baseURL) throws MalformedURLException, IOException {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/rule4/versions");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        InputStream in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        Document doc = this.abdera.getParser().parse(in);
        Feed feed = (Feed)doc.getRoot();
        Assert.assertEquals((Object)"Version history of model1", (Object)feed.getTitle());
        List entries = feed.getEntries();
        int versionNumbers = entries.size();
        connection.disconnect();
        URL url2 = new URL(baseURL, "rest/packages/restPackage1/assets/rule4/source");
        HttpURLConnection connection2 = (HttpURLConnection)url2.openConnection();
        connection2.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection2.setDoOutput(true);
        connection2.setRequestMethod("PUT");
        connection2.setRequestProperty("Content-Type", "application/xml");
        connection2.setRequestProperty("Accept", "application/xml");
        OutputStreamWriter out = new OutputStreamWriter(connection2.getOutputStream());
        String newContent = "rule 'nheron' when Goo1() then end";
        out.write(newContent);
        out.close();
        connection2.getInputStream();
        Assert.assertEquals((long)204L, (long)connection2.getResponseCode());
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        doc = this.abdera.getParser().parse(in);
        feed = (Feed)doc.getRoot();
        Assert.assertEquals((Object)"Version history of model1", (Object)feed.getTitle());
        entries = feed.getEntries();
        Assert.assertEquals((long)(versionNumbers + 1), (long)entries.size());
    }

    @Test
    @RunAsClient
    public void testGetHistoricalAssetForAtom(@ArquillianResource URL baseURL) throws MalformedURLException, IOException {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/model1/versions/1");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        InputStream in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        Document doc = this.abdera.getParser().parse(in);
        Entry entry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)"model1", (Object)entry.getTitle());
        Assert.assertTrue((entry.getPublished() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/model1/versions/1"), (Object)entry.getId().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/model1/versions/1/binary"), (Object)entry.getContentSrc().getPath());
        ExtensibleElement metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        ExtensibleElement formatExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.FORMAT);
        Assert.assertEquals((Object)"model.drl", (Object)formatExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement stateExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.STATE);
        Assert.assertEquals((Object)"Draft", (Object)stateExtension.getSimpleExtension(Translator.VALUE));
        ExtensibleElement archivedExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.ARCHIVED);
        Assert.assertEquals((Object)"false", (Object)archivedExtension.getSimpleExtension(Translator.VALUE));
        url = new URL(baseURL, "rest/packages/restPackage1/assets/model1/versions/2");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
        in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        doc = this.abdera.getParser().parse(in);
        entry = (Entry)doc.getRoot();
        Assert.assertEquals((Object)"model1", (Object)entry.getTitle());
        Assert.assertTrue((entry.getPublished() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/model1/versions/2"), (Object)entry.getId().getPath());
        Assert.assertEquals((Object)(baseURL.getPath() + "rest/packages/restPackage1/assets/model1/versions/2/binary"), (Object)entry.getContentSrc().getPath());
        metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA);
        formatExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.FORMAT);
        Assert.assertEquals((Object)"model.drl", (Object)formatExtension.getSimpleExtension(Translator.VALUE));
        stateExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.STATE);
        Assert.assertEquals((Object)"Draft", (Object)stateExtension.getSimpleExtension(Translator.VALUE));
        archivedExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.ARCHIVED);
        Assert.assertEquals((Object)"false", (Object)archivedExtension.getSimpleExtension(Translator.VALUE));
    }

    @Test
    @RunAsClient
    public void testGetHistoricalAssetSource(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/model1/versions/1/source");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "*/*");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"text/plain", (Object)connection.getContentType());
        String result = IOUtils.toString((InputStream)connection.getInputStream());
        Assert.assertTrue((boolean)result.contains("declare Album1"));
        Assert.assertTrue((boolean)result.contains("genre1: String"));
        url = new URL(baseURL, "rest/packages/restPackage1/assets/model1/versions/2/source");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "*/*");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"text/plain", (Object)connection.getContentType());
        result = IOUtils.toString((InputStream)connection.getInputStream());
        Assert.assertTrue((boolean)result.contains("declare Album2"));
        Assert.assertTrue((boolean)result.contains("genre2: String"));
    }

    @Test
    @RunAsClient
    public void testGetHistoricalAssetBinary(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/packages/restPackage1/assets/testGetHistoricalAssetBinary");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        byte[] authEncBytes = Base64.encodeBase64((byte[])"admin:admin".getBytes());
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.connect();
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
        url = new URL(baseURL, "rest/packages/restPackage1/assets");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.setRequestProperty("Slug", "testGetHistoricalAssetBinary.gif");
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.setDoOutput(true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[1000];
        int count = 0;
        InputStream is = this.getClass().getResourceAsStream("Error-image.gif");
        while ((count = is.read(data, 0, 1000)) != -1) {
            out.write(data, 0, count);
        }
        connection.getOutputStream().write(out.toByteArray());
        out.close();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        url = new URL(baseURL, "rest/packages/restPackage1/assets/testGetHistoricalAssetBinary/binary");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Accept", "application/xml");
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        byte[] data2 = new byte[1000];
        int count2 = 0;
        InputStream is2 = this.getClass().getResourceAsStream("Error-image-new.gif");
        while ((count2 = is2.read(data2, 0, 1000)) != -1) {
            out2.write(data2, 0, count2);
        }
        connection.getOutputStream().write(out2.toByteArray());
        out2.close();
        Assert.assertEquals((long)204L, (long)connection.getResponseCode());
        url = new URL(baseURL, "rest/packages/restPackage1/assets/testGetHistoricalAssetBinary/versions/1/binary");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/octet-stream");
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/octet-stream", (Object)connection.getContentType());
        InputStream in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        url = new URL(baseURL, "rest/packages/restPackage1/assets/testGetHistoricalAssetBinary/versions/2/binary");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/octet-stream");
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/octet-stream", (Object)connection.getContentType());
        in = connection.getInputStream();
        Assert.assertNotNull((Object)in);
        url = new URL(baseURL, "rest/packages/restPackage1/assets/testGetHistoricalAssetBinary");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.connect();
        Assert.assertEquals((long)204L, (long)connection.getResponseCode());
        url = new URL(baseURL, "rest/packages/restPackage1/assets/testGetHistoricalAssetBinary");
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.setRequestProperty("Authorization", "Basic " + new String(authEncBytes));
        connection.connect();
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
    }

    protected Package createTestPackage(String title) {
        Package p = new Package();
        PackageMetadata metadata = new PackageMetadata();
        metadata.setCreated(new Date(System.currentTimeMillis()));
        metadata.setUuid(UUID.randomUUID().toString());
        metadata.setCheckinComment("Check in comment for test package.");
        p.setMetadata(metadata);
        p.setAuthor("awaterma");
        p.setPublished(new Date(System.currentTimeMillis()));
        p.setTitle(title);
        p.setDescription("A simple test package with 0 assets.");
        return p;
    }

    private Package unmarshalPackageXML(InputStream is) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Package.class});
        Unmarshaller u = c.createUnmarshaller();
        return (Package)u.unmarshal(is);
    }
}

