/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import java.util.List;
import javax.inject.Inject;
import org.drools.guvnor.server.repository.MailboxService;
import org.drools.guvnor.server.repository.UserInbox;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.UserInfo;
import org.junit.Assert;
import org.junit.Test;

public class MailboxServiceIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private MailboxService mailboxService;

    @Test
    public void testMailbox() throws Exception {
        AssetItem asset = this.rulesRepository.loadDefaultModule().addAsset("testMailbox", "");
        UserInbox mailman = new UserInbox(this.rulesRepository, "mailman");
        Assert.assertEquals((long)0L, (long)mailman.loadIncoming().size());
        UserInbox ib = new UserInbox(this.rulesRepository, "mic");
        ib.save();
        ib.addToRecentEdited(asset.getUUID(), "hey");
        Assert.assertEquals((long)0L, (long)ib.loadIncoming().size());
        UserInbox ib2 = new UserInbox(this.rulesRepository, "mic2");
        ib2.save();
        ib2.addToRecentEdited(asset.getUUID(), "hey");
        Assert.assertEquals((long)0L, (long)ib2.loadIncoming().size());
        this.mailboxService.recordItemUpdated(asset);
        Thread.sleep(300L);
        List es = ib.loadIncoming();
        Assert.assertEquals((long)1L, (long)es.size());
        Assert.assertEquals((Object)asset.getUUID(), (Object)((UserInfo.InboxEntry)es.get((int)0)).assetUUID);
        es = ib2.loadIncoming();
        Assert.assertEquals((long)1L, (long)es.size());
        Assert.assertEquals((Object)asset.getUUID(), (Object)((UserInfo.InboxEntry)es.get((int)0)).assetUUID);
        Assert.assertEquals((long)0L, (long)mailman.loadIncoming().size());
        AssetItem ass2 = this.rulesRepository.loadDefaultModule().addAsset("testMailbox2", "XX");
        ib2.addToRecentEdited(ass2.getUUID(), "hey");
        mailman.addToIncoming(ass2.getUUID(), "whee", "mic");
        Assert.assertEquals((long)1L, (long)mailman.loadIncoming().size());
        Assert.assertEquals((long)1L, (long)ib2.loadIncoming().size());
        this.mailboxService.wakeUp();
        Thread.sleep(250L);
        Assert.assertEquals((long)2L, (long)ib2.loadIncoming().size());
        Assert.assertEquals((long)0L, (long)mailman.loadIncoming().size());
        Assert.assertEquals((long)1L, (long)ib.loadIncoming().size());
        this.mailboxService.wakeUp();
        Assert.assertEquals((long)2L, (long)ib2.loadIncoming().size());
        Assert.assertEquals((long)0L, (long)mailman.loadIncoming().size());
        Assert.assertEquals((long)1L, (long)ib.loadIncoming().size());
    }

    @Test
    public void testOneToMany() throws Exception {
        String sender = this.rulesRepository.getSession().getUserID();
        AssetItem asset = this.rulesRepository.loadDefaultModule().addAsset("testMailboxOneToMany", "");
        UserInbox ib1 = new UserInbox(this.rulesRepository, sender);
        UserInbox ib2 = new UserInbox(this.rulesRepository, "dave");
        UserInbox ib3 = new UserInbox(this.rulesRepository, "phil");
        ib1.clearAll();
        ib2.clearAll();
        ib3.clearAll();
        ib1.save();
        ib2.save();
        ib3.save();
        ib1.addToRecentEdited(asset.getUUID(), "hey");
        ib2.addToRecentEdited(asset.getUUID(), "hey");
        ib3.addToRecentEdited(asset.getUUID(), "hey");
        Assert.assertEquals((long)0L, (long)ib1.loadIncoming().size());
        Assert.assertEquals((long)0L, (long)ib2.loadIncoming().size());
        Assert.assertEquals((long)0L, (long)ib3.loadIncoming().size());
        this.mailboxService.recordItemUpdated(asset);
        Thread.sleep(250L);
        Assert.assertEquals((long)0L, (long)ib1.loadIncoming().size());
        Assert.assertEquals((long)1L, (long)ib2.loadIncoming().size());
        Assert.assertEquals((long)1L, (long)ib3.loadIncoming().size());
    }
}

