/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.util.List;
import javax.inject.Inject;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleBasedPermissionManager;
import org.drools.guvnor.server.security.RoleBasedPermissionResolver;
import org.drools.guvnor.server.security.RoleBasedPermissionStore;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.security.SecurityServiceImpl;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.jboss.seam.security.AuthorizationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SecurityServiceImplIntegrationTest
extends GuvnorIntegrationTest {
    private static final String USER_NAME = "securityServiceImplUser";
    @Inject
    private SecurityServiceImpl securityService;
    @Inject
    private RoleBasedPermissionStore roleBasedPermissionStore;
    @Inject
    private RoleBasedPermissionManager roleBasedPermissionManager;
    @Inject
    private RoleBasedPermissionResolver roleBasedPermissionResolver;

    public SecurityServiceImplIntegrationTest() {
        this.autoLoginAsAdmin = false;
    }

    @Before
    public void loginAsSpecificUser() {
        this.loginAs(USER_NAME);
    }

    @After
    public void logoutAsSpecificUser() {
        this.logoutAs(USER_NAME);
    }

    @Test
    public void testUser() throws Exception {
        Assert.assertNotNull((Object)this.securityService.getCurrentUser());
    }

    @Test
    public void testCapabilities() {
        List userCapabilities = this.securityService.getUserCapabilities();
        Assert.assertTrue((boolean)userCapabilities.contains(Capability.SHOW_ADMIN));
        Assert.assertTrue((boolean)userCapabilities.contains(Capability.SHOW_CREATE_NEW_ASSET));
        Assert.assertTrue((boolean)userCapabilities.contains(Capability.SHOW_CREATE_NEW_PACKAGE));
        Assert.assertTrue((boolean)userCapabilities.contains(Capability.SHOW_DEPLOYMENT));
        Assert.assertTrue((boolean)userCapabilities.contains(Capability.SHOW_DEPLOYMENT_NEW));
        Assert.assertTrue((boolean)userCapabilities.contains(Capability.SHOW_KNOWLEDGE_BASES_VIEW));
        Assert.assertTrue((boolean)userCapabilities.contains(Capability.SHOW_QA));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCapabilitiesWithContext() {
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), "packagename", null));
        this.roleBasedPermissionManager.create();
        try {
            List c = this.securityService.getUserCapabilities();
            Assert.assertTrue((boolean)c.contains(Capability.SHOW_KNOWLEDGE_BASES_VIEW));
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionManager.create();
            try {
                this.securityService.getUserCapabilities();
                Assert.fail((String)"should not be allowed as there are no permissions");
            }
            catch (AuthorizationException e) {
                Assert.assertNotNull((Object)e.getMessage());
            }
        }
        finally {
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
        }
        this.securityService.getUserCapabilities();
    }
}

