/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.BRMSSuggestionCompletionLoader;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.SuggestionCompletionLoader;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class BRMSSuggestionCompletionLoaderIntegrationTest
extends GuvnorIntegrationTest {
    @Test
    public void testLoader() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem item = repo.createModule("testLoader", "to test the loader");
        DroolsHeader.updateDroolsHeader((String)"import java.util.Date", (ModuleItem)item);
        repo.save();
        BRMSSuggestionCompletionLoader loader = new BRMSSuggestionCompletionLoader();
        String header = DroolsHeader.getDroolsHeader((ModuleItem)item);
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(item);
        Assert.assertNotNull((Object)engine);
    }

    @Test
    public void testLoaderWithComplexFields() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem item = repo.createModule("testLoaderWithComplexFields", "to test the loader");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.guvnor.server.util.Agent", (ModuleItem)item);
        repo.save();
        BRMSSuggestionCompletionLoader loader = new BRMSSuggestionCompletionLoader();
        String header = DroolsHeader.getDroolsHeader((ModuleItem)item);
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(item);
        Assert.assertNotNull((Object)engine);
        String[] modelFields = engine.getModelFields("Agent");
        System.out.println("modelFields: " + Arrays.asList(modelFields));
        Assert.assertNotNull((Object)modelFields);
        Assert.assertEquals((long)9L, (long)modelFields.length);
        modelFields = engine.getModelFields(FieldAccessorsAndMutators.BOTH, "Agent");
        Assert.assertNotNull((Object)modelFields);
        System.out.println("modelFields: " + Arrays.asList(modelFields));
        Assert.assertEquals((long)9L, (long)modelFields.length);
        modelFields = engine.getModelFields(FieldAccessorsAndMutators.ACCESSOR, "Agent");
        Assert.assertNotNull((Object)modelFields);
        System.out.println("modelFields: " + Arrays.asList(modelFields));
        Assert.assertEquals((long)9L, (long)modelFields.length);
        modelFields = engine.getModelFields(FieldAccessorsAndMutators.MUTATOR, "Agent");
        Assert.assertNotNull((Object)modelFields);
        System.out.println("modelFields: " + Arrays.asList(modelFields));
        Assert.assertEquals((long)8L, (long)modelFields.length);
    }

    @Test
    public void testStripUnNeededFields() {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        List result = loader.removeIrrelevantFields(Arrays.asList("foo", "toString", "class", "hashCode"));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"foo", result.get(0));
    }

    @Test
    public void testGetShortNameOfClass() {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        Assert.assertEquals((Object)"Object", (Object)loader.getShortNameOfClass(Object.class.getName()));
        Assert.assertEquals((Object)"Foo", (Object)loader.getShortNameOfClass("Foo"));
    }

    @Test
    @Ignore(value="Needs fixing")
    public void testFactTemplates() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem item = repo.createModule("testLoader2", "to test the loader for fact templates");
        DroolsHeader.updateDroolsHeader((String)"import java.util.Date\ntemplate Person\njava.lang.String name\nDate birthDate\nend", (ModuleItem)item);
        repo.save();
        BRMSSuggestionCompletionLoader loader = new BRMSSuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(item);
        Assert.assertNotNull((Object)engine);
        List<String> factTypes = Arrays.asList(engine.getFactTypes());
        Assert.assertEquals((long)(2 + loader.getExternalImportDescrs().size()), (long)factTypes.size());
        Assert.assertTrue((boolean)factTypes.contains("Date"));
        Assert.assertTrue((boolean)factTypes.contains("Person"));
        String[] fieldsForType = engine.getFieldCompletions("Person");
        Assert.assertEquals((long)2L, (long)fieldsForType.length);
        Assert.assertEquals((Object)"birthDate", (Object)fieldsForType[0]);
        Assert.assertEquals((Object)"name", (Object)fieldsForType[1]);
        String fieldType = engine.getFieldType("Person", "name");
        Assert.assertEquals((Object)"String", (Object)fieldType);
        fieldType = engine.getFieldType("Person", "birthDate");
        Assert.assertEquals((Object)"Date", (Object)fieldType);
    }

    @Test
    public void testDeclaredTypes() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem item = repo.createModule("testLoaderDeclaredTypes", "to test the loader for declared types");
        AssetItem asset = item.addAsset("MyModel", "");
        asset.updateFormat("model.drl");
        asset.updateContent("declare Car\n pieceOfRubbish: Boolean \n name: String \nend");
        asset.checkin("");
        repo.save();
        BRMSSuggestionCompletionLoader loader = new BRMSSuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(item);
        Assert.assertNotNull((Object)engine);
        String[] factTypes = engine.getFactTypes();
        Assert.assertEquals((long)(1 + loader.getExternalImportDescrs().size()), (long)factTypes.length);
        Assert.assertEquals((Object)"Car", (Object)factTypes[0]);
        List<String> fields = Arrays.asList(engine.getFieldCompletions("Car"));
        Assert.assertEquals((long)3L, (long)fields.size());
        Assert.assertTrue((boolean)fields.contains("this"));
        Assert.assertTrue((boolean)fields.contains("pieceOfRubbish"));
        Assert.assertTrue((boolean)fields.contains("name"));
        Assert.assertEquals((Object)"Car", (Object)engine.getFieldType("Car", "this"));
        Assert.assertEquals((Object)"Boolean", (Object)engine.getFieldType("Car", "pieceOfRubbish"));
        Assert.assertEquals((Object)"String", (Object)engine.getFieldType("Car", "name"));
    }

    @Test
    public void testLoadDSLs() throws Exception {
        String dsl = "[when]The agents rating is {rating}=doNothing()\n[then]Send a notification to manufacturing '{message}'=foo()";
        RulesRepository repo = this.rulesRepository;
        ModuleItem item = repo.createModule("testLoadDSLs", "to test the loader for DSLs");
        AssetItem asset = item.addAsset("mydsl", "");
        asset.updateFormat("dsl");
        asset.updateContent(dsl);
        asset.checkin("ok");
        item = repo.loadModule("testLoadDSLs");
        BRMSSuggestionCompletionLoader loader = new BRMSSuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine(item);
        Assert.assertFalse((boolean)eng.hasDataEnumLists());
        Assert.assertFalse((boolean)loader.hasErrors());
        Assert.assertEquals((long)1L, (long)eng.actionDSLSentences.length);
        Assert.assertEquals((long)1L, (long)eng.conditionDSLSentences.length);
        Assert.assertEquals((Object)"The agents rating is {rating}", (Object)eng.conditionDSLSentences[0].getDefinition());
        Assert.assertEquals((Object)"Send a notification to manufacturing '{message}'", (Object)eng.actionDSLSentences[0].getDefinition());
    }

    @Test
    public void testLoadEnumerations() throws Exception {
        String enumeration = "'Person.sex' : ['M', 'F']";
        RulesRepository repo = this.rulesRepository;
        ModuleItem item = repo.createModule("testLoadEnums", "to test the loader for enums");
        AssetItem asset = item.addAsset("myenum", "");
        asset.updateFormat("enumeration");
        asset.updateContent(enumeration);
        asset.checkin("ok");
        item = repo.loadModule("testLoadEnums");
        BRMSSuggestionCompletionLoader loader = new BRMSSuggestionCompletionLoader();
        SuggestionCompletionEngine sce = loader.getSuggestionEngine(item);
        Assert.assertFalse((boolean)loader.hasErrors());
        Assert.assertEquals((long)1L, (long)sce.getDataEnumListsSize());
        asset.updateContent("goober boy");
        asset.checkin("yeah");
        item = repo.loadModule("testLoadEnums");
        loader = new BRMSSuggestionCompletionLoader();
        sce = loader.getSuggestionEngine(item);
        Assert.assertTrue((boolean)loader.hasErrors());
    }

    @Test
    public void testErrors() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem item = repo.createModule("testErrorsInPackage", "to test error handling");
        BRMSSuggestionCompletionLoader loader = new BRMSSuggestionCompletionLoader();
        Assert.assertNotNull((Object)loader.getSuggestionEngine(item));
        Assert.assertFalse((boolean)loader.hasErrors());
        DroolsHeader.updateDroolsHeader((String)"gooble de gook", (ModuleItem)item);
        loader = new BRMSSuggestionCompletionLoader();
        loader.getSuggestionEngine(item);
        Assert.assertTrue((boolean)loader.hasErrors());
        DroolsHeader.updateDroolsHeader((String)"import foo.bar; \nglobal goo.Bar baz;", (ModuleItem)item);
        loader = new BRMSSuggestionCompletionLoader();
        loader.getSuggestionEngine(item);
        Assert.assertTrue((boolean)loader.hasErrors());
    }

    @Test
    public void testModelWithNoAttachment() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem item = repo.createModule("testmodelWithNoAttachment", "to test model loading");
        item.addAsset("testModel", "", null, "jar");
        repo.save();
        BRMSSuggestionCompletionLoader loader = new BRMSSuggestionCompletionLoader();
        Assert.assertNotNull((Object)loader.getSuggestionEngine(item));
        Assert.assertFalse((boolean)loader.hasErrors());
    }
}

