/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util.drools;

import java.io.IOException;
import java.io.InputStream;
import org.drools.guvnor.server.contenthandler.drools.DRLFileContentHandler;
import org.drools.guvnor.server.util.ClassicDRLImporter;
import org.junit.Assert;
import org.junit.Test;

public class ClassicDRLImporterTest {
    @Test
    public void testStandardDRL() throws Exception {
        ClassicDRLImporter imp = new ClassicDRLImporter(this.getDrl("sample_legacy.drl"));
        Assert.assertEquals((Object)"foo", (Object)imp.getPackageName());
        Assert.assertEquals((long)2L, (long)imp.getAssets().size());
        Assert.assertEquals((Object)"blah", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)0)).name);
        Assert.assertEquals((Object)"cha", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)1)).name);
        System.err.println(imp.getPackageHeader());
        Assert.assertTrue((imp.getPackageHeader().indexOf("import goo.wee") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((imp.getPackageHeader().indexOf("package") == -1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)imp.isDSLEnabled());
        this.assertEqualsIgnoreWhitespace("when Whee() then goo();", ((ClassicDRLImporter.Asset)imp.getAssets().get((int)0)).content);
        this.assertEqualsIgnoreWhitespace("when Sup() then ka();", ((ClassicDRLImporter.Asset)imp.getAssets().get((int)1)).content);
        Assert.assertTrue((((ClassicDRLImporter.Asset)imp.getAssets().get((int)0)).content.indexOf(" Whee()") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testStandardWithQuotes() throws Exception {
        ClassicDRLImporter imp = new ClassicDRLImporter(this.getDrl("sample_legacy_quotes.drl"));
        Assert.assertEquals((Object)"foo", (Object)imp.getPackageName());
        Assert.assertEquals((long)1L, (long)imp.getAssets().size());
        Assert.assertEquals((long)-1L, (long)((ClassicDRLImporter.Asset)imp.getAssets().get((int)0)).name.indexOf("'"));
    }

    @Test
    public void testWithFunction() throws Exception {
        ClassicDRLImporter imp = new ClassicDRLImporter(this.getDrl("sample_legacy_functions.drl"));
        Assert.assertFalse((boolean)imp.isDSLEnabled());
        Assert.assertEquals((long)7L, (long)imp.getAssets().size());
        Assert.assertEquals((Object)"function", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)0)).format);
        Assert.assertEquals((Object)"function", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)1)).format);
        Assert.assertEquals((Object)"goo1", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)0)).name);
        this.assertEqualsIgnoreWhitespace("function void goo1() { //do something ! { yeah } }", ((ClassicDRLImporter.Asset)imp.getAssets().get((int)0)).content);
        Assert.assertEquals((Object)"goo2", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)1)).name);
        this.assertEqualsIgnoreWhitespace("function String goo2(String la) { //yeah man ! return \"whee\"; }", ((ClassicDRLImporter.Asset)imp.getAssets().get((int)1)).content);
        Assert.assertEquals((Object)"goo3", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)2)).name);
        this.assertEqualsIgnoreWhitespace("function String goo3() { return \"HELLO\"; }", ((ClassicDRLImporter.Asset)imp.getAssets().get((int)2)).content);
        Assert.assertEquals((Object)"goo4", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)3)).name);
        this.assertEqualsIgnoreWhitespace("function String goo4() { if( true ) { return \"HELLO\"; } }", ((ClassicDRLImporter.Asset)imp.getAssets().get((int)3)).content);
        Assert.assertEquals((Object)"goo6", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)4)).name);
        this.assertEqualsIgnoreWhitespace("function String goo6() { return \"HELLO\"; /* } */ /* } } } */ }", ((ClassicDRLImporter.Asset)imp.getAssets().get((int)4)).content);
        Assert.assertEquals((Object)"drl", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)5)).format);
        Assert.assertEquals((Object)"drl", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)6)).format);
        Assert.assertNotNull((Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)6)).content);
    }

    @Test
    public void testWithDeclarations() throws Exception {
        String EXPECTED = "declare Type1 enddeclare Type2 extends Type1 field1 : String enddeclare Type3 enddeclare Type4 extends Type3 field1 : String end";
        ClassicDRLImporter imp = new ClassicDRLImporter(this.getDrl("sample_legacy_declarations.drl"));
        Assert.assertFalse((boolean)imp.isDSLEnabled());
        Assert.assertEquals((long)2L, (long)imp.getAssets().size());
        Assert.assertEquals((Object)"drl", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)0)).format);
        Assert.assertEquals((Object)"model.drl", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)1)).format);
        Assert.assertEquals((Object)"Rule", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)0)).name);
        this.assertEqualsIgnoreWhitespace("when Type1() then System.out.println(\"Type1\");", ((ClassicDRLImporter.Asset)imp.getAssets().get((int)0)).content);
        Assert.assertEquals((Object)"model", (Object)((ClassicDRLImporter.Asset)imp.getAssets().get((int)1)).name);
        this.assertEqualsIgnoreWhitespace("declare Type1 enddeclare Type2 extends Type1 field1 : String enddeclare Type3 enddeclare Type4 extends Type3 field1 : String end", ((ClassicDRLImporter.Asset)imp.getAssets().get((int)1)).content);
    }

    @Test
    public void testWithDSL() throws Exception {
        ClassicDRLImporter imp = new ClassicDRLImporter(this.getDrl("sample_legacy_with_dsl.drl"));
        Assert.assertTrue((boolean)imp.isDSLEnabled());
        Assert.assertEquals((long)2L, (long)imp.getAssets().size());
        System.out.println(imp.getPackageHeader());
        Assert.assertEquals((Object)"foo", (Object)imp.getPackageName());
        Assert.assertTrue((boolean)imp.getPackageHeader().contains("import goo.wee"));
        Assert.assertTrue((boolean)imp.getPackageHeader().contains("global ka.cha"));
        this.assertEqualsIgnoreWhitespace("when ka chow then bam", ((ClassicDRLImporter.Asset)imp.getAssets().get((int)0)).content);
        this.assertEqualsIgnoreWhitespace("when ka chiga then ka chow", ((ClassicDRLImporter.Asset)imp.getAssets().get((int)1)).content);
        ClassicDRLImporter.Asset as = (ClassicDRLImporter.Asset)imp.getAssets().get(0);
        Assert.assertEquals((Object)"dslr", (Object)as.format);
    }

    @Test
    public void testComplexExample() throws Exception {
        ClassicDRLImporter imp = new ClassicDRLImporter(this.getDrl("sample_complex.drl"));
        Assert.assertFalse((boolean)imp.isDSLEnabled());
        Assert.assertEquals((long)2L, (long)imp.getAssets().size());
        Assert.assertTrue((boolean)DRLFileContentHandler.isStandAloneRule((String)((ClassicDRLImporter.Asset)imp.getAssets().get((int)0)).content));
    }

    private InputStream getDrl(String file) throws IOException {
        return this.getClass().getResourceAsStream(file);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }

    @Test
    public void testMergeHeader() {
        String header = "import foo.bar\nimport wee.waa\n\nglobal goo.ber baz\n";
        String toMerge = "import ninja\nimport foo.bar\nimport slack.bladder\n\nimport wee.waa";
        String result = ClassicDRLImporter.mergeLines((String)header, (String)toMerge);
        Assert.assertEquals((Object)"import foo.bar\nimport wee.waa\n\nglobal goo.ber baz\n\nimport ninja\nimport slack.bladder", (Object)result);
        Assert.assertEquals((Object)"abc", (Object)ClassicDRLImporter.mergeLines((String)"abc", (String)""));
        Assert.assertEquals((Object)"qed", (Object)ClassicDRLImporter.mergeLines((String)"qed", null));
        Assert.assertEquals((Object)"xyz", (Object)ClassicDRLImporter.mergeLines((String)"", (String)"xyz"));
        Assert.assertEquals((Object)"xyz", (Object)ClassicDRLImporter.mergeLines(null, (String)"xyz"));
    }
}

