/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.guvnor.client.decisiontable.widget.DTCellValueUtilities;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellValueFactory;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractCellValueFactory;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.DynamicDataRow;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.Analysis;
import org.drools.ide.common.client.modeldriven.dt52.AnalysisCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.RowNumberCol52;

public class DecisionTableCellValueFactory
extends AbstractCellValueFactory<BaseColumn, DTCellValue52> {
    private final GuidedDecisionTable52 model;
    private final DTCellValueUtilities utilities;

    public DecisionTableCellValueFactory(GuidedDecisionTable52 model, SuggestionCompletionEngine sce) {
        super(sce);
        this.model = model;
        this.utilities = new DTCellValueUtilities(model, sce);
    }

    public List<DTCellValue52> makeRowData() {
        ArrayList<DTCellValue52> data = new ArrayList<DTCellValue52>();
        List columns = this.model.getExpandedColumns();
        for (int iCol = 0; iCol < columns.size() - 1; ++iCol) {
            BaseColumn column = (BaseColumn)columns.get(iCol);
            DTCellValue52 cell = this.makeModelCellValue(column);
            data.add(cell);
        }
        return data;
    }

    public DynamicDataRow makeUIRowData() {
        DynamicDataRow data = new DynamicDataRow();
        List columns = this.model.getExpandedColumns();
        for (BaseColumn column : columns) {
            DTCellValue52 dcv = this.makeModelCellValue(column);
            DTDataTypes52 dataType = this.utilities.getDataType(column);
            this.utilities.assertDTCellValue(dataType, dcv);
            CellValue cell = this.convertModelCellValue(column, dcv);
            data.add(cell);
        }
        return data;
    }

    public List<DTCellValue52> makeColumnData(BaseColumn column) {
        ArrayList<DTCellValue52> data = new ArrayList<DTCellValue52>();
        for (int iRow = 0; iRow < this.model.getData().size(); ++iRow) {
            DTCellValue52 cell = this.makeModelCellValue(column);
            data.add(cell);
        }
        return data;
    }

    public List<CellValue<? extends Comparable<?>>> convertColumnData(BaseColumn column, List<DTCellValue52> columnData) {
        ArrayList data = new ArrayList();
        for (int iRow = 0; iRow < this.model.getData().size(); ++iRow) {
            DTCellValue52 dcv = columnData.get(iRow);
            CellValue cell = this.convertModelCellValue(column, dcv);
            data.add(cell);
        }
        return data;
    }

    public DTCellValue52 makeModelCellValue(BaseColumn column) {
        AttributeCol52 ac;
        DTDataTypes52 dataType = this.utilities.getDataType(column);
        DTCellValue52 dcv = null;
        dcv = column instanceof LimitedEntryCol ? new DTCellValue52(Boolean.FALSE) : (column instanceof AttributeCol52 ? ((ac = (AttributeCol52)column).getAttribute().equals("dialect") ? new DTCellValue52("mvel") : new DTCellValue52(column.getDefaultValue())) : new DTCellValue52(column.getDefaultValue()));
        this.utilities.assertDTCellValue(dataType, dcv);
        return dcv;
    }

    public CellValue<? extends Comparable<?>> convertModelCellValue(BaseColumn column, DTCellValue52 dcv) {
        if (column instanceof AnalysisCol52) {
            return this.makeNewAnalysisCellValue();
        }
        DTDataTypes52 dataType = this.utilities.getDataType(column);
        this.utilities.assertDTCellValue(dataType, dcv);
        CellValue cell = null;
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dataType.ordinal()]) {
            case 1: {
                cell = this.makeNewBooleanCellValue(dcv.getBooleanValue());
                break;
            }
            case 2: {
                cell = this.makeNewDateCellValue(dcv.getDateValue());
                break;
            }
            case 3: {
                cell = this.makeNewNumericCellValue((BigDecimal)dcv.getNumericValue());
                break;
            }
            case 4: {
                cell = this.makeNewBigDecimalCellValue((BigDecimal)dcv.getNumericValue());
                break;
            }
            case 5: {
                cell = this.makeNewBigIntegerCellValue((BigInteger)dcv.getNumericValue());
                break;
            }
            case 6: {
                cell = this.makeNewByteCellValue((Byte)dcv.getNumericValue());
                break;
            }
            case 7: {
                cell = this.makeNewDoubleCellValue((Double)dcv.getNumericValue());
                break;
            }
            case 8: {
                cell = this.makeNewFloatCellValue((Float)dcv.getNumericValue());
                break;
            }
            case 9: {
                cell = this.makeNewIntegerCellValue((Integer)dcv.getNumericValue());
                break;
            }
            case 10: {
                AttributeCol52 at;
                if (column instanceof RowNumberCol52) {
                    cell = this.makeNewRowNumberCellValue((Long)dcv.getNumericValue());
                    break;
                }
                cell = this.makeNewLongCellValue((Long)dcv.getNumericValue());
                if (!(column instanceof AttributeCol52) || !(at = (AttributeCol52)column).getAttribute().equals("salience") || !at.isUseRowNumber()) break;
                cell = this.makeNewRowNumberCellValue((Long)dcv.getNumericValue());
                break;
            }
            case 11: {
                cell = this.makeNewShortCellValue((Short)dcv.getNumericValue());
                break;
            }
            default: {
                AttributeCol52 ac;
                cell = this.makeNewStringCellValue((Object)dcv.getStringValue());
                if (!(column instanceof AttributeCol52) || !(ac = (AttributeCol52)column).getAttribute().equals("dialect")) break;
                cell = this.makeNewDialectCellValue(dcv.getStringValue());
            }
        }
        if (dcv.isOtherwise()) {
            cell.addState(CellValue.CellState.OTHERWISE);
        }
        return cell;
    }

    public CellValue<Long> makeNewRowNumberCellValue(Long initialValue) {
        CellValue cv = this.makeNewLongCellValue(initialValue);
        if (initialValue != null) {
            cv.setValue((Object)initialValue);
        }
        return cv;
    }

    public CellValue<Analysis> makeNewAnalysisCellValue() {
        Analysis analysis = new Analysis();
        return new CellValue((Comparable)analysis);
    }

    public DTCellValue52 convertToModelCell(BaseColumn column, CellValue<?> cell) {
        DTDataTypes52 dt = this.utilities.getDataType(column);
        DTCellValue52 dtCell = null;
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dt.ordinal()]) {
            case 1: {
                dtCell = new DTCellValue52((Boolean)cell.getValue());
                break;
            }
            case 2: {
                dtCell = new DTCellValue52((Date)cell.getValue());
                break;
            }
            case 3: {
                dtCell = new DTCellValue52((BigDecimal)cell.getValue());
                break;
            }
            case 4: {
                dtCell = new DTCellValue52((BigDecimal)cell.getValue());
                break;
            }
            case 5: {
                dtCell = new DTCellValue52((BigInteger)cell.getValue());
                break;
            }
            case 6: {
                dtCell = new DTCellValue52((Byte)cell.getValue());
                break;
            }
            case 7: {
                dtCell = new DTCellValue52((Double)cell.getValue());
                break;
            }
            case 8: {
                dtCell = new DTCellValue52((Float)cell.getValue());
                break;
            }
            case 9: {
                dtCell = new DTCellValue52((Integer)cell.getValue());
                break;
            }
            case 10: {
                dtCell = new DTCellValue52((Long)cell.getValue());
                break;
            }
            case 11: {
                dtCell = new DTCellValue52((Short)cell.getValue());
                break;
            }
            default: {
                dtCell = new DTCellValue52((String)((Object)cell.getValue()));
            }
        }
        dtCell.setOtherwise(cell.isOtherwise());
        return dtCell;
    }
}

