/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor.drools;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.SetFactTypeFilter;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.WorkingSetConfigData;
import org.drools.ide.common.client.factconstraints.ConstraintConfiguration;
import org.drools.ide.common.client.factconstraints.customform.CustomFormConfiguration;
import org.drools.ide.common.client.factconstraints.helper.CustomFormsContainer;
import org.drools.ide.common.client.modeldriven.FactTypeFilter;

public class WorkingSetManager {
    private static WorkingSetManager INSTANCE = new WorkingSetManager();
    private Map<String, Set<Asset>> activeWorkingSets = new HashMap();
    private boolean autoVerifierEnabled = false;

    public static synchronized WorkingSetManager getInstance() {
        return INSTANCE;
    }

    public void applyWorkingSets(String packageName, String[] wsUUIDs, Command done) {
        AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
        assetService.loadRuleAssets(wsUUIDs, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void applyWorkingSets(String packageName, Set<Asset> wss, Command done) {
        if (wss == null || wss.isEmpty()) {
            SuggestionCompletionCache.getInstance().refreshPackage(packageName, done);
            this.activeWorkingSets.remove(packageName);
        } else {
            HashSet<String> validFacts = new HashSet<String>();
            for (Asset asset : wss) {
                WorkingSetConfigData wsConfig = (WorkingSetConfigData)asset.getContent();
                if (wsConfig.validFacts == null || wsConfig.validFacts.length <= 0) continue;
                validFacts.addAll(Arrays.asList(wsConfig.validFacts));
            }
            this.activeWorkingSets.put(packageName, wss);
            SuggestionCompletionCache.getInstance().applyFactFilter(packageName, (FactTypeFilter)new SetFactTypeFilter(validFacts), done);
        }
    }

    public Set<Asset> getActiveAssets(String packageName) {
        return (Set)this.activeWorkingSets.get(packageName);
    }

    public Set<String> getActiveAssetUUIDs(String packageName) {
        Set assets = (Set)this.activeWorkingSets.get(packageName);
        if (assets == null) {
            return null;
        }
        HashSet<String> uuids = new HashSet<String>(assets.size());
        for (Asset asset : assets) {
            uuids.add(asset.getUuid());
        }
        return uuids;
    }

    public Set<WorkingSetConfigData> getActiveWorkingSets(String packageName) {
        Set assets = (Set)this.activeWorkingSets.get(packageName);
        if (assets == null) {
            return null;
        }
        HashSet<WorkingSetConfigData> result = new HashSet<WorkingSetConfigData>();
        for (Asset ruleAsset : assets) {
            result.add((WorkingSetConfigData)ruleAsset.getContent());
        }
        return result;
    }

    public boolean isWorkingSetActive(String packageName, Asset workingSetAsset) {
        return this.isWorkingSetActive(packageName, workingSetAsset.getUuid());
    }

    public boolean isWorkingSetActive(String packageName, String ruleAssetUUID) {
        if (!this.activeWorkingSets.containsKey(packageName)) {
            return false;
        }
        Set wss = (Set)this.activeWorkingSets.get(packageName);
        for (Asset asset : wss) {
            if (!asset.getUuid().equals(ruleAssetUUID)) continue;
            return true;
        }
        return false;
    }

    public Set<ConstraintConfiguration> getFieldContraints(String packageName, String factType, String fieldName) {
        HashSet<ConstraintConfiguration> result = new HashSet<ConstraintConfiguration>();
        Set activeAssets = this.getActiveAssets(packageName);
        if (activeAssets != null) {
            for (Asset ruleAsset : activeAssets) {
                List constraints = ((WorkingSetConfigData)ruleAsset.getContent()).constraints;
                if (constraints == null) continue;
                for (ConstraintConfiguration constraint : constraints) {
                    if (!constraint.getFactType().equals(factType) || !constraint.getFieldName().equals(fieldName)) continue;
                    result.add(constraint);
                }
            }
        }
        return result;
    }

    public boolean isAutoVerifierEnabled() {
        return this.autoVerifierEnabled;
    }

    public void setAutoVerifierEnabled(boolean autoVerifierEnabled) {
        this.autoVerifierEnabled = autoVerifierEnabled;
    }

    public CustomFormConfiguration getCustomFormConfiguration(String packageName, String factType, String fieldName) {
        Set packageWorkingSets = this.getActiveWorkingSets(packageName);
        if (packageWorkingSets != null) {
            ArrayList configs = new ArrayList();
            for (WorkingSetConfigData workingSetConfigData : packageWorkingSets) {
                if (workingSetConfigData.customForms == null || workingSetConfigData.customForms.isEmpty()) continue;
                configs.addAll(workingSetConfigData.customForms);
            }
            CustomFormsContainer cfc = new CustomFormsContainer(configs);
            if (cfc.containsCustomFormFor(factType, fieldName)) {
                return cfc.getCustomForm(factType, fieldName);
            }
        }
        return null;
    }
}

