/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.dmg.pmml.pmml_4_1.descr.Characteristic;
import org.dmg.pmml.pmml_4_1.descr.Characteristics;
import org.dmg.pmml.pmml_4_1.descr.Extension;
import org.dmg.pmml.pmml_4_1.descr.FIELDUSAGETYPE;
import org.dmg.pmml.pmml_4_1.descr.INVALIDVALUETREATMENTMETHOD;
import org.dmg.pmml.pmml_4_1.descr.MiningField;
import org.dmg.pmml.pmml_4_1.descr.MiningSchema;
import org.dmg.pmml.pmml_4_1.descr.Output;
import org.dmg.pmml.pmml_4_1.descr.PMML;
import org.dmg.pmml.pmml_4_1.descr.Scorecard;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.server.builder.AssemblyErrorLogger;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.ide.common.client.modeldriven.scorecards.Attribute;
import org.drools.ide.common.client.modeldriven.scorecards.ScorecardModel;
import org.drools.ide.common.server.util.ScorecardsXMLPersistence;
import org.drools.repository.AssetItem;
import org.drools.scorecards.ScorecardCompiler;
import org.drools.scorecards.pmml.PMMLGenerator;
import org.drools.scorecards.pmml.ScorecardPMMLUtils;

public class ScorecardsContentHandler
extends ContentHandler
implements IRuleAsset {
    public void retrieveAssetContent(Asset asset, AssetItem item) throws SerializationException {
        ScorecardModel model = ScorecardsXMLPersistence.getInstance().unmarshall(item.getContent());
        asset.setContent((PortableObject)model);
    }

    public void storeAssetContent(Asset asset, AssetItem repoAsset) throws SerializationException {
        ScorecardModel model = (ScorecardModel)asset.getContent();
        repoAsset.updateContent(ScorecardsXMLPersistence.getInstance().marshal(model));
    }

    public void assembleDRL(BRMSPackageBuilder builder, AssetItem assetItem, StringBuilder stringBuilder) {
        ScorecardModel model = ScorecardsXMLPersistence.getInstance().unmarshall(assetItem.getContent());
        String drl = this.getDrlFromScorecardModel(model);
        stringBuilder.append(drl);
    }

    public void assembleDRL(BRMSPackageBuilder builder, Asset asset, StringBuilder stringBuilder) {
        ScorecardModel model = (ScorecardModel)asset.getContent();
        String drl = this.getDrlFromScorecardModel(model);
        stringBuilder.append(drl);
    }

    public String getRawDRL(AssetItem assetItem) {
        ScorecardModel model = ScorecardsXMLPersistence.getInstance().unmarshall(assetItem.getContent());
        return this.getDrlFromScorecardModel(model);
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, AssemblyErrorLogger logger) throws DroolsParserException, IOException {
        String drl = this.getRawDRL(asset);
        if (drl.equals("")) {
            return;
        }
        builder.addPackageFromDrl((Reader)new StringReader(drl));
    }

    protected String getDrlFromScorecardModel(ScorecardModel model) {
        PMML pmml = this.createPMMLDocument(model);
        return ScorecardCompiler.convertToDRL((PMML)pmml, (ScorecardCompiler.DrlType)ScorecardCompiler.DrlType.EXTERNAL_OBJECT_MODEL);
    }

    private PMML createPMMLDocument(ScorecardModel model) {
        Scorecard pmmlScorecard = ScorecardPMMLUtils.createScorecard();
        Output output = new Output();
        Characteristics characteristics = new Characteristics();
        MiningSchema miningSchema = new MiningSchema();
        Extension extension = new Extension();
        extension.setName("externalClass");
        extension.setValue(model.getFactName());
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
        extension = new Extension();
        extension.setName("importsFromDelimitedString");
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(model.getFactName());
        StringBuilder importBuilder = new StringBuilder();
        importBuilder.append(model.getFactName());
        for (org.drools.ide.common.client.modeldriven.scorecards.Characteristic characteristic : model.getCharacteristics()) {
            if (imports.contains(characteristic.getFact())) continue;
            imports.add(characteristic.getFact());
            importBuilder.append(",").append(characteristic.getFact());
        }
        imports.clear();
        extension.setValue(importBuilder.toString());
        extension = new Extension();
        extension.setName("final");
        extension.setValue(model.getFieldName());
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
        extension = new Extension();
        extension.setName("scorecardPackage");
        extension.setValue(model.getPackageName());
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
        String modelName = this.convertToJavaIdentifier(model.getName());
        pmmlScorecard.setModelName(modelName);
        pmmlScorecard.setInitialScore(Double.valueOf(model.getInitialScore()));
        pmmlScorecard.setUseReasonCodes(Boolean.valueOf(model.isUseReasonCodes()));
        if (model.isUseReasonCodes()) {
            pmmlScorecard.setBaselineScore(Double.valueOf(model.getBaselineScore()));
            pmmlScorecard.setReasonCodeAlgorithm(model.getReasonCodesAlgorithm());
        }
        for (org.drools.ide.common.client.modeldriven.scorecards.Characteristic characteristic : model.getCharacteristics()) {
            Characteristic _characteristic = new Characteristic();
            characteristics.getCharacteristics().add(_characteristic);
            extension = new Extension();
            extension.setName("externalClass");
            extension.setValue(characteristic.getFact());
            _characteristic.getExtensions().add(extension);
            extension = new Extension();
            extension.setName("dataType");
            if ("string".equalsIgnoreCase(characteristic.getDataType())) {
                extension.setValue("Text");
            } else if ("int".equalsIgnoreCase(characteristic.getDataType()) || "double".equalsIgnoreCase(characteristic.getDataType())) {
                extension.setValue("Number");
            } else if ("boolean".equalsIgnoreCase(characteristic.getDataType())) {
                extension.setValue("Boolean");
            }
            _characteristic.getExtensions().add(extension);
            if (model.isUseReasonCodes()) {
                _characteristic.setBaselineScore(Double.valueOf(characteristic.getBaselineScore()));
                _characteristic.setReasonCode(characteristic.getReasonCode());
            }
            _characteristic.setName(characteristic.getName());
            MiningField miningField = new MiningField();
            miningField.setName(characteristic.getField());
            miningField.setUsageType(FIELDUSAGETYPE.ACTIVE);
            miningField.setInvalidValueTreatment(INVALIDVALUETREATMENTMETHOD.RETURN_INVALID);
            miningSchema.getMiningFields().add(miningField);
            extension = new Extension();
            extension.setName("externalClass");
            extension.setValue(characteristic.getFact());
            miningField.getExtensions().add(extension);
            Object[] numericOperators = new String[]{"=", ">", "<", ">=", "<="};
            for (Attribute attribute : characteristic.getAttributes()) {
                org.dmg.pmml.pmml_4_1.descr.Attribute _attribute = new org.dmg.pmml.pmml_4_1.descr.Attribute();
                _characteristic.getAttributes().add(_attribute);
                extension = new Extension();
                extension.setName("field");
                extension.setValue(characteristic.getField());
                _attribute.getExtensions().add(extension);
                if (model.isUseReasonCodes()) {
                    _attribute.setReasonCode(attribute.getReasonCode());
                }
                _attribute.setPartialScore(Double.valueOf(attribute.getPartialScore()));
                String operator = attribute.getOperator();
                String dataType = characteristic.getDataType();
                String predicateResolver = "boolean".equalsIgnoreCase(dataType) ? operator.toUpperCase() : ("String".equalsIgnoreCase(dataType) ? (operator.contains("=") ? operator + attribute.getValue() : attribute.getValue() + ",") : (ArrayUtils.contains((Object[])numericOperators, (Object)operator) ? operator + " " + attribute.getValue() : attribute.getValue().replace(",", "-")));
                extension = new Extension();
                extension.setName("predicateResolver");
                extension.setValue(predicateResolver);
                _attribute.getExtensions().add(extension);
            }
        }
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(miningSchema);
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(output);
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(characteristics);
        return new PMMLGenerator().generateDocument(pmmlScorecard);
    }

    private String convertToJavaIdentifier(String modelName) {
        StringBuilder sb = new StringBuilder();
        if (!Character.isJavaIdentifierStart(modelName.charAt(0))) {
            sb.append("_");
        }
        for (char c : modelName.toCharArray()) {
            if (!Character.isJavaIdentifierPart(c)) {
                sb.append("_");
                continue;
            }
            sb.append(c);
        }
        modelName = sb.toString();
        return modelName;
    }
}

