/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.converters.decisiontable.builders;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.guvnor.client.rpc.ConversionResult;
import org.drools.guvnor.server.converters.decisiontable.builders.GuidedDecisionTableRHSBuilder;
import org.drools.guvnor.server.converters.decisiontable.builders.GuidedDecisionTableSourceBuilder;
import org.drools.guvnor.server.converters.decisiontable.builders.HasColumnHeadings;
import org.drools.guvnor.server.converters.decisiontable.builders.IndexedParametersValueBuilder;
import org.drools.guvnor.server.converters.decisiontable.builders.LiteralValueBuilder;
import org.drools.guvnor.server.converters.decisiontable.builders.ParameterUtilities;
import org.drools.guvnor.server.converters.decisiontable.builders.ParameterizedValueBuilder;
import org.drools.guvnor.server.converters.decisiontable.builders.SingleParameterValueBuilder;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.template.model.SnippetBuilder;
import org.drools.template.parser.DecisionTableParseException;

public class GuidedDecisionTableRHSBuilder
implements HasColumnHeadings,
GuidedDecisionTableSourceBuilder {
    private final int headerRow;
    private final int headerCol;
    private final String variable;
    private final Map<Integer, String> columnHeaders = new HashMap();
    private final Map<Integer, ParameterizedValueBuilder> valueBuilders = new HashMap();
    private final ParameterUtilities parameterUtilities;
    private ConversionResult conversionResult;

    public GuidedDecisionTableRHSBuilder(int row, int column, String boundVariable, ParameterUtilities parameterUtilities, ConversionResult conversionResult) {
        this.headerRow = row;
        this.headerCol = column;
        this.variable = boundVariable == null ? "" : boundVariable.trim();
        this.parameterUtilities = parameterUtilities;
        this.conversionResult = conversionResult;
    }

    public void populateDecisionTable(GuidedDecisionTable52 dtable) {
        TreeSet sortedIndexes = new TreeSet(this.valueBuilders.keySet());
        for (Integer index : sortedIndexes) {
            ParameterizedValueBuilder vb = (ParameterizedValueBuilder)this.valueBuilders.get(index);
            this.addColumn(dtable, vb, index.intValue());
        }
    }

    private void addColumn(GuidedDecisionTable52 dtable, ParameterizedValueBuilder vb, int index) {
        if (vb instanceof LiteralValueBuilder) {
            this.addLiteralColumn(dtable, (LiteralValueBuilder)vb, index);
        } else {
            this.addBRLFragmentColumn(dtable, vb, index);
        }
    }

    private void addLiteralColumn(GuidedDecisionTable52 dtable, LiteralValueBuilder vb, int index) {
        BRLActionColumn column = new BRLActionColumn();
        FreeFormLine ffl = new FreeFormLine();
        ffl.text = vb.getTemplate();
        column.getDefinition().add(ffl);
        BRLActionVariableColumn parameterColumn = new BRLActionVariableColumn("", "Boolean");
        column.getChildColumns().add(parameterColumn);
        column.setHeader((String)this.columnHeaders.get(index));
        dtable.getActionCols().add(column);
        List columnData = vb.getColumnData();
        int iColIndex = dtable.getExpandedColumns().indexOf(column.getChildColumns().get(0));
        for (int iRow = 0; iRow < columnData.size(); ++iRow) {
            List rowData = (List)dtable.getData().get(iRow);
            rowData.addAll(iColIndex, (Collection)columnData.get(iRow));
        }
    }

    private void addBRLFragmentColumn(GuidedDecisionTable52 dtable, ParameterizedValueBuilder vb, int index) {
        BRLActionColumn column = new BRLActionColumn();
        FreeFormLine ffl = new FreeFormLine();
        ffl.text = vb.getTemplate();
        column.getDefinition().add(ffl);
        for (String parameter : vb.getParameters()) {
            BRLActionVariableColumn parameterColumn = new BRLActionVariableColumn(parameter, "Object");
            column.getChildColumns().add(parameterColumn);
        }
        column.setHeader((String)this.columnHeaders.get(index));
        dtable.getActionCols().add(column);
        List columnData = vb.getColumnData();
        int iColIndex = dtable.getExpandedColumns().indexOf(column.getChildColumns().get(0));
        for (int iRow = 0; iRow < columnData.size(); ++iRow) {
            List rowData = (List)dtable.getData().get(iRow);
            rowData.addAll(iColIndex, (Collection)columnData.get(iRow));
        }
    }

    public void addTemplate(int row, int column, String template) {
        if (this.valueBuilders.containsKey(column)) {
            String message = "Internal error: Can't have a code snippet added twice to one spreadsheet column.";
            this.conversionResult.addMessage("Internal error: Can't have a code snippet added twice to one spreadsheet column.", ConversionResult.ConversionMessageType.ERROR);
            return;
        }
        template = template.trim();
        if (this.isBoundVar()) {
            template = this.variable + "." + template;
        }
        if (!template.endsWith(";")) {
            template = template + ";";
        }
        try {
            this.valueBuilders.put(column, this.getValueBuilder(template));
        }
        catch (DecisionTableParseException pe) {
            this.conversionResult.addMessage(pe.getMessage(), ConversionResult.ConversionMessageType.WARNING);
        }
    }

    private boolean isBoundVar() {
        return !"".equals(this.variable);
    }

    public void setColumnHeader(int column, String value) {
        this.columnHeaders.put(column, value.trim());
    }

    private ParameterizedValueBuilder getValueBuilder(String template) {
        SnippetBuilder.SnippetType type = SnippetBuilder.getType((String)template);
        switch (1.$SwitchMap$org$drools$template$model$SnippetBuilder$SnippetType[type.ordinal()]) {
            case 1: {
                return new IndexedParametersValueBuilder(template, this.parameterUtilities);
            }
            case 2: {
                return new SingleParameterValueBuilder(template, this.parameterUtilities);
            }
            case 3: {
                return new LiteralValueBuilder(template);
            }
        }
        throw new DecisionTableParseException("SnippetBuilder.SnippetType '" + type.toString() + "' is not supported. The column will not be added.");
    }

    public void addCellValue(int row, int column, String value) {
        ParameterizedValueBuilder vb = (ParameterizedValueBuilder)this.valueBuilders.get(column);
        if (vb == null) {
            String message = "No code snippet for ACTION, above cell " + RuleSheetParserUtil.rc2name((int)(this.headerRow + 2), (int)this.headerCol);
            this.conversionResult.addMessage(message, ConversionResult.ConversionMessageType.ERROR);
            return;
        }
        vb.addCellValue(row, column, value);
    }

    public String getResult() {
        throw new UnsupportedOperationException("GuidedDecisionTableRHSBuilder does not return DRL.");
    }

    public ActionType.Code getActionTypeCode() {
        return ActionType.Code.ACTION;
    }

    public void clearValues() {
        throw new UnsupportedOperationException();
    }

    public boolean hasValues() {
        throw new UnsupportedOperationException();
    }
}

