/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.verification;

import org.drools.builder.ResourceType;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.server.builder.AssetValidationIterator;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.verification.VerifierReportCreator;
import org.drools.guvnor.server.verification.VerifierRunner;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.drools.io.ResourceFactory;
import org.drools.repository.ModuleItem;
import org.drools.verifier.Verifier;
import org.drools.verifier.builder.ScopesAgendaFilter;
import org.drools.verifier.data.VerifierReport;

public class TemporalBRLAssetVerifier
extends VerifierRunner {
    private final Asset ruleAsset;
    private final Verifier verifier;

    public TemporalBRLAssetVerifier(Verifier verifier, Asset ruleAsset, ModuleItem packageItem) {
        super(verifier, packageItem);
        if (!ruleAsset.getFormat().equals("brl")) {
            throw new IllegalStateException("Unexpected format " + ruleAsset.getFormat() + "! Only " + "brl" + " expected!");
        }
        this.verifier = verifier;
        this.ruleAsset = ruleAsset;
    }

    protected ScopesAgendaFilter getScopesAgendaFilter() {
        if (this.isAssetDecisionTable(this.ruleAsset)) {
            return new ScopesAgendaFilter(true, "decision-table");
        }
        return new ScopesAgendaFilter(true, "single-rule");
    }

    private boolean isAssetDecisionTable(Asset ruleAsset) {
        return "gdst".equals(ruleAsset.getFormat()) || "xls".equals(ruleAsset.getFormat());
    }

    protected AssetValidationIterator listAssetsByFormat(String format) {
        throw new IllegalStateException("This method should never be invoked!");
    }

    public AnalysisReport verify() {
        this.addHeaderToVerifier();
        this.addRuleAssetToVerifier();
        this.fireAnalysis();
        VerifierReport report = this.verifier.getResult();
        return VerifierReportCreator.doReport((VerifierReport)report);
    }

    private void addRuleAssetToVerifier() {
        ContentHandler handler = ContentManager.getHandler((String)this.ruleAsset.getFormat());
        if (!(handler instanceof IRuleAsset)) {
            throw new IllegalStateException("IRuleAsset Expected");
        }
        RuleModel model = (RuleModel)this.ruleAsset.getContent();
        String brl = BRXMLPersistence.getInstance().marshal(model);
        this.verifier.addResourcesToVerify(ResourceFactory.newByteArrayResource((byte[])brl.getBytes()), ResourceType.BRL);
    }
}

