/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.rpc.AnalysisFactUsage;
import org.drools.guvnor.client.rpc.AnalysisFieldUsage;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.rpc.AnalysisReportLine;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.PatternComponent;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;

/*
 * Exception performing whole class analysis ignored.
 */
public class VerifierReportCreator {
    public static AnalysisReport doReport(VerifierReport report) {
        AnalysisReport result = new AnalysisReport();
        result.errors = VerifierReportCreator.doLines((Collection)report.getBySeverity(Severity.ERROR));
        result.warnings = VerifierReportCreator.doLines((Collection)report.getBySeverity(Severity.WARNING));
        result.notes = VerifierReportCreator.doLines((Collection)report.getBySeverity(Severity.NOTE));
        result.factUsages = VerifierReportCreator.doFactUsage((VerifierData)report.getVerifierData());
        return result;
    }

    private static AnalysisFactUsage[] doFactUsage(VerifierData verifierData) {
        HashMap interned = new HashMap();
        ArrayList<AnalysisFactUsage> factUsage = new ArrayList<AnalysisFactUsage>();
        Collection objectTypes = verifierData.getAll(VerifierComponentType.OBJECT_TYPE);
        for (ObjectType c : objectTypes) {
            AnalysisFactUsage fact = new AnalysisFactUsage();
            fact.name = c.getName();
            ArrayList<AnalysisFieldUsage> fieldUsage = new ArrayList<AnalysisFieldUsage>();
            Set flds = c.getFields();
            for (Field f : flds) {
                AnalysisFieldUsage fu = new AnalysisFieldUsage();
                fu.name = f.getName();
                Collection cr = verifierData.getRulesByFieldPath(f.getPath());
                ArrayList<String> ruleNames = new ArrayList<String>();
                for (VerifierRule verifierRule : cr) {
                    ruleNames.add(VerifierReportCreator.intern((String)verifierRule.getName(), interned));
                }
                fu.rules = ruleNames.toArray(new String[ruleNames.size()]);
                fieldUsage.add(fu);
            }
            fact.fields = fieldUsage.toArray(new AnalysisFieldUsage[fieldUsage.size()]);
            factUsage.add(fact);
        }
        return factUsage.toArray(new AnalysisFactUsage[factUsage.size()]);
    }

    private static String intern(String ruleName, Map<String, String> interned) {
        if (interned.containsKey(ruleName)) {
            return interned.get(ruleName);
        }
        interned.put(ruleName, ruleName);
        return ruleName;
    }

    private static AnalysisReportLine[] doLines(Collection<VerifierMessageBase> messages) {
        ArrayList<AnalysisReportLine> lines = new ArrayList<AnalysisReportLine>();
        for (VerifierMessageBase message : messages) {
            AnalysisReportLine line = new AnalysisReportLine();
            line.description = message.getMessage();
            if (message.getFaulty() != null) {
                line.reason = message.getFaulty().toString();
                if (message.getFaulty() instanceof PatternComponent) {
                    line.patternOrderNumber = ((PatternComponent)message.getFaulty()).getPatternOrderNumber();
                }
            }
            line.impactedRules = message.getImpactedRules();
            line.causes = VerifierReportCreator.doCauses((Collection)message.getCauses());
            lines.add(line);
        }
        return lines.toArray(new AnalysisReportLine[lines.size()]);
    }

    private static org.drools.guvnor.client.rpc.Cause[] doCauses(Collection<Cause> causes) {
        ArrayList<org.drools.guvnor.client.rpc.Cause> results = new ArrayList<org.drools.guvnor.client.rpc.Cause>();
        for (Cause cause : causes) {
            org.drools.guvnor.client.rpc.Cause result = new org.drools.guvnor.client.rpc.Cause(cause.toString(), VerifierReportCreator.doCauses((Collection)cause.getCauses()));
            results.add(result);
        }
        return results.toArray(new org.drools.guvnor.client.rpc.Cause[results.size()]);
    }
}

