/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra.election;

import java.util.Date;
import java.util.Set;

public class LeaderInfo {
    private String groupName;
    private String leader;
    private Date localTimestamp;
    private Set<String> members;

    public LeaderInfo(String groupName, String leader, Date timestamp, Set<String> members) {
        this.groupName = groupName;
        this.leader = leader;
        this.localTimestamp = timestamp;
        this.members = members;
    }

    public boolean hasEmptyLeader() {
        return this.leader == null;
    }

    public boolean hasValidLeader() {
        return this.leader != null && this.members.contains(this.leader);
    }

    public boolean isValidLeader(String pod) {
        if (pod == null) {
            return false;
        }
        return this.hasValidLeader() && pod.equals(this.leader);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getLeader() {
        return this.leader;
    }

    public Date getLocalTimestamp() {
        return this.localTimestamp;
    }

    public Set<String> getMembers() {
        return this.members;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LeaderInfo{");
        sb.append("groupName='").append(this.groupName).append('\'');
        sb.append(", leader='").append(this.leader).append('\'');
        sb.append(", localTimestamp=").append(this.localTimestamp);
        sb.append(", members=").append(this.members);
        sb.append('}');
        return sb.toString();
    }
}

