/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra.consumer;

import java.time.LocalDateTime;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.consumer.DroolsConsumerHandler;
import org.kie.hacep.core.infra.DefaultSessionSnapShooter;
import org.kie.hacep.core.infra.SnapshotInfos;
import org.kie.hacep.core.infra.consumer.DefaultKafkaConsumer;
import org.kie.hacep.core.infra.election.State;
import org.kie.hacep.core.infra.utils.SnapshotOnDemandUtils;
import org.kie.hacep.util.ConsumerUtilsCore;
import org.kie.remote.impl.producer.Producer;
import org.kie.remote.message.ControlMessage;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultKafkaConsumerTest {
    @Mock
    protected Producer mockProducer;
    @Mock
    protected DroolsConsumerHandler handlerMock;
    @Mock
    protected KafkaConsumer primaryConsumerMock;
    @Mock
    protected KafkaConsumer secondaryConsumerMock;
    @Mock
    protected ConsumerUtilsCore consumerUtilsCoreMock;
    @Mock
    protected DefaultSessionSnapShooter defaultSessionSnapShooterMock;
    @Mock
    protected SnapshotOnDemandUtils snapshotOnDemandUtilsMock;
    private DefaultKafkaConsumer spy;

    @Before
    public void initTest() {
        final EnvConfig envConfigTest = EnvConfig.getDefaultEnvConfig();
        ControlMessage lastControlMessage = new ControlMessage();
        lastControlMessage.setId("1");
        lastControlMessage.setOffset(1L);
        Mockito.when((Object)this.consumerUtilsCoreMock.getLastEvent(envConfigTest.getControlTopicName(), Integer.valueOf(envConfigTest.getPollTimeout()))).thenReturn((Object)lastControlMessage);
        Mockito.when((Object)this.defaultSessionSnapShooterMock.getLastSnapshotTime()).thenReturn((Object)LocalDateTime.now());
        Mockito.when((Object)this.handlerMock.initializeKieSessionFromSnapshotOnDemand((EnvConfig)Matchers.any(EnvConfig.class), (SnapshotInfos)Matchers.any(SnapshotInfos.class))).thenReturn((Object)Boolean.TRUE);
        this.spy = (DefaultKafkaConsumer)Mockito.spy((Object)new DefaultKafkaConsumer(){
            {
                this.envConfig = envConfigTest;
                this.producer = DefaultKafkaConsumerTest.this.mockProducer;
                this.consumerUtilsCore = DefaultKafkaConsumerTest.this.consumerUtilsCoreMock;
                this.snapShooter = DefaultKafkaConsumerTest.this.defaultSessionSnapShooterMock;
                this.snapshotOnDemandUtils = DefaultKafkaConsumerTest.this.snapshotOnDemandUtilsMock;
                this.consumerHandler = DefaultKafkaConsumerTest.this.handlerMock;
                this.initKafkaConsumer();
                this.updateKafkaSecondaryConsumer();
            }

            public void initKafkaConsumer() {
                this.kafkaConsumer = DefaultKafkaConsumerTest.this.primaryConsumerMock;
            }

            public void updateKafkaSecondaryConsumer() {
                this.kafkaSecondaryConsumer = DefaultKafkaConsumerTest.this.secondaryConsumerMock;
            }
        });
    }

    @Test
    public void updateStatusBecomingLeaderAtStartupTest() {
        this.spy.updateStatus(State.BECOMING_LEADER);
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy)).updateStatus(State.BECOMING_LEADER);
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.never())).updateOnRunningConsumer((State)Matchers.any(State.class));
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.never())).askAndProcessSnapshotOnDemand((SnapshotInfos)Matchers.any(SnapshotInfos.class));
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.never())).enableConsumeAndStartLoop((State)Matchers.any(State.class));
    }

    @Test
    public void updateStatusLeaderAtStartupTest() {
        this.spy.updateStatus(State.LEADER);
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy)).updateStatus(State.LEADER);
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.never())).updateOnRunningConsumer((State)Matchers.any(State.class));
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.never())).askAndProcessSnapshotOnDemand((SnapshotInfos)Matchers.any(SnapshotInfos.class));
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.times((int)1))).enableConsumeAndStartLoop((State)Mockito.eq((Object)State.LEADER));
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.times((int)1))).setLastProcessedKey();
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.times((int)1))).assignAndStartConsume();
    }

    @Test
    public void updateStatusReplicaAtStartupTest() {
        this.spy.updateStatus(State.REPLICA);
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy)).updateStatus(State.REPLICA);
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.never())).updateOnRunningConsumer((State)Matchers.any(State.class));
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.times((int)1))).askAndProcessSnapshotOnDemand((SnapshotInfos)Matchers.any(SnapshotInfos.class));
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.times((int)1))).enableConsumeAndStartLoop((State)Mockito.eq((Object)State.REPLICA));
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.times((int)1))).setLastProcessedKey();
        ((DefaultKafkaConsumer)Mockito.verify((Object)this.spy, (VerificationMode)Mockito.times((int)1))).assignAndStartConsume();
    }
}

