/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra.utils;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.kie.hacep.Config;
import org.kie.hacep.core.InfraFactory;
import org.kie.hacep.util.ConsumerUtilsCore;
import org.kie.remote.message.ControlMessage;
import org.kie.remote.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerUtilsCoreImpl
implements ConsumerUtilsCore {
    private Logger logger = LoggerFactory.getLogger(ConsumerUtilsCoreImpl.class);

    public ControlMessage getLastEvent(String topic, Integer pollTimeout) {
        return this.getLastEvent(topic, Config.getConsumerConfig((String)"LastEventConsumer"), pollTimeout);
    }

    public ControlMessage getLastEvent(String topic, Properties properties, Integer pollTimeout) {
        ControlMessage lastMessage = new ControlMessage();
        try (KafkaConsumer consumer = InfraFactory.getConsumer(topic, properties);){
            ConsumerRecords records = consumer.poll(Duration.of(pollTimeout.intValue(), ChronoUnit.MILLIS));
            for (ConsumerRecord record : records) {
                lastMessage = (ControlMessage)SerializationUtil.deserialize((byte[])((byte[])record.value()));
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        return lastMessage;
    }
}

