/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.kie.hacep.Config;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.KafkaFullTopicsTests;
import org.kie.hacep.core.Bootstrap;
import org.kie.hacep.core.InfraFactory;
import org.kie.hacep.core.infra.election.State;
import org.kie.hacep.sample.kjar.StockTickEvent;
import org.kie.remote.CommonConfig;
import org.kie.remote.RemoteStreamingKieSession;
import org.kie.remote.impl.RemoteStreamingKieSessionImpl;
import org.kie.remote.impl.producer.Producer;
import org.kie.remote.util.KafkaRemoteUtil;

public class RemoteStreamingKieSessionImplTest
extends KafkaFullTopicsTests {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getFactCountTest() throws Exception {
        Properties props = CommonConfig.getTestProperties();
        Bootstrap.startEngine((EnvConfig)this.envConfig);
        Bootstrap.getConsumerController().getCallback().updateStatus(State.LEADER);
        this.kafkaServerTest.insertBatchStockTicketEvent(7, this.topicsConfig, RemoteStreamingKieSession.class, KafkaRemoteUtil.getListener((Properties)props, (boolean)false));
        try (RemoteStreamingKieSessionImpl client = new RemoteStreamingKieSessionImpl(Config.getProducerConfig((String)"FactCountConsumerTest"), this.topicsConfig, KafkaRemoteUtil.getListener((Properties)props, (boolean)false), InfraFactory.getProducer((boolean)false));){
            CompletableFuture factCountFuture = client.getFactCount();
            Long factCount = (Long)factCountFuture.get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((factCount == 7L ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getListKieSessionObjectsTest() throws Exception {
        Properties props = CommonConfig.getTestProperties();
        Bootstrap.startEngine((EnvConfig)this.envConfig);
        Bootstrap.getConsumerController().getCallback().updateStatus(State.LEADER);
        this.kafkaServerTest.insertBatchStockTicketEvent(1, this.topicsConfig, RemoteStreamingKieSession.class, KafkaRemoteUtil.getListener((Properties)props, (boolean)false));
        Producer prod = InfraFactory.getProducer((boolean)false);
        try (RemoteStreamingKieSessionImpl client = new RemoteStreamingKieSessionImpl(CommonConfig.getProducerConfig(), this.topicsConfig, KafkaRemoteUtil.getListener((Properties)props, (boolean)false), prod);){
            CompletableFuture listKieObjectsFuture = client.getObjects();
            Collection listKieObjects = (Collection)listKieObjectsFuture.get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((listKieObjects.size() == 1 ? 1 : 0) != 0);
            StockTickEvent event = (StockTickEvent)listKieObjects.iterator().next();
            Assert.assertTrue((boolean)event.getCompany().equals("RHT"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getListKieSessionObjectsWithClassTypeTest() throws Exception {
        Properties props = CommonConfig.getTestProperties();
        Bootstrap.startEngine((EnvConfig)this.envConfig);
        Bootstrap.getConsumerController().getCallback().updateStatus(State.LEADER);
        this.kafkaServerTest.insertBatchStockTicketEvent(1, this.topicsConfig, RemoteStreamingKieSession.class, KafkaRemoteUtil.getListener((Properties)props, (boolean)false));
        Producer prod = InfraFactory.getProducer((boolean)false);
        try (RemoteStreamingKieSessionImpl client = new RemoteStreamingKieSessionImpl(Config.getProducerConfig((String)"ListKieSessionObjectsWithClassTypeTest"), this.topicsConfig, KafkaRemoteUtil.getListener((Properties)props, (boolean)false), prod);){
            CompletableFuture listKieObjectsFuture = client.getObjects(StockTickEvent.class);
            Collection listKieObjects = (Collection)listKieObjectsFuture.get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((listKieObjects.size() == 1 ? 1 : 0) != 0);
            StockTickEvent event = (StockTickEvent)listKieObjects.iterator().next();
            Assert.assertTrue((boolean)event.getCompany().equals("RHT"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getListKieSessionObjectsWithNamedQueryTest() throws Exception {
        Properties props = CommonConfig.getTestProperties();
        Bootstrap.startEngine((EnvConfig)this.envConfig);
        Bootstrap.getConsumerController().getCallback().updateStatus(State.LEADER);
        this.kafkaServerTest.insertBatchStockTicketEvent(1, this.topicsConfig, RemoteStreamingKieSession.class, KafkaRemoteUtil.getListener((Properties)props, (boolean)false));
        Producer prod = InfraFactory.getProducer((boolean)false);
        try (RemoteStreamingKieSessionImpl client = new RemoteStreamingKieSessionImpl(Config.getProducerConfig((String)"ListKieSessionObjectsWithNamedQueryTest"), this.topicsConfig, KafkaRemoteUtil.getListener((Properties)props, (boolean)false), prod);){
            this.doQuery(client, "IBM", 0);
            Collection<?> listKieObjects = this.doQuery(client, "RHT", 1);
            StockTickEvent event = (StockTickEvent)listKieObjects.iterator().next();
            Assert.assertTrue((boolean)event.getCompany().equals("RHT"));
        }
    }

    private Collection<?> doQuery(RemoteStreamingKieSessionImpl client, String stockName, int expectedResult) throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture listKieObjectsFuture = client.getObjects("stockTickEventQuery", "stock", new Serializable[]{stockName});
        Collection listKieObjects = (Collection)listKieObjectsFuture.get(10L, TimeUnit.SECONDS);
        Assert.assertEquals((long)expectedResult, (long)listKieObjects.size());
        return listKieObjects;
    }
}

