/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra;

import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.core.InfraFactory;
import org.kie.hacep.core.infra.DefaultSessionSnapShooter;
import org.kie.hacep.core.infra.SessionSnapshooter;
import org.kie.hacep.core.infra.SnapshotInfos;
import org.kie.hacep.core.infra.utils.SnapshotOnDemandUtils;
import org.kie.hacep.core.infra.utils.SnapshotOnDemandUtilsImpl;
import org.kie.remote.impl.producer.Producer;

public class SnapshotOnDemandUtilsTest {
    private SnapshotOnDemandUtils snapshotOnDemandUtils;
    private EnvConfig config;

    @Before
    public void init() {
        this.snapshotOnDemandUtils = new SnapshotOnDemandUtilsImpl();
        this.config = EnvConfig.getDefaultEnvConfig();
        this.config.local(false);
        this.config.underTest(false);
    }

    @Test(expected=KafkaException.class)
    public void askAKafkaConsumerWithoutServerUpTest() {
        KafkaConsumer consumer = this.snapshotOnDemandUtils.getConfiguredSnapshotConsumer(this.config);
        Assert.assertNull((Object)consumer);
    }

    @Test(expected=KafkaException.class)
    public void askASnapshotWithoutServerUpTest() {
        DefaultSessionSnapShooter sessionSnapshooter = new DefaultSessionSnapShooter(this.config, this.snapshotOnDemandUtils);
        Producer producer = InfraFactory.getProducer((boolean)this.config.isLocal());
        SnapshotInfos infos = this.snapshotOnDemandUtils.askASnapshotOnDemand(this.config, (SessionSnapshooter)sessionSnapshooter, producer);
        Assert.assertNull((Object)infos);
    }
}

