/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra.election;

import io.fabric8.kubernetes.api.model.ConfigMap;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.kie.hacep.core.infra.election.ConfigMapLockUtils;
import org.kie.hacep.core.infra.election.LeaderInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapLockUtilsTest {
    static Logger logger = LoggerFactory.getLogger(ConfigMapLockUtilsTest.class);

    @Test
    public void methodsTest() {
        String groupName = "drools-group";
        String leader = "leader-x13X";
        Date timestamp = Calendar.getInstance().getTime();
        HashSet<String> members = new HashSet<String>(Arrays.asList("Qui", "Quo", "Qua"));
        LeaderInfo info = new LeaderInfo(groupName, leader, timestamp, members);
        logger.info("leaderInfo:{}", (Object)info.toString());
        Assert.assertFalse((boolean)info.hasEmptyLeader());
        Assert.assertFalse((boolean)info.isValidLeader(null));
        Assert.assertFalse((boolean)info.hasValidLeader());
        Assert.assertEquals((Object)groupName, (Object)info.getGroupName());
        Assert.assertEquals((Object)leader, (Object)info.getLeader());
        Assert.assertEquals((Object)timestamp, (Object)info.getLocalTimestamp());
        Assert.assertEquals(members, (Object)info.getMembers());
        ConfigMap configMap = ConfigMapLockUtils.createNewConfigMap((String)"my-map", (LeaderInfo)info);
        Assert.assertNotNull((Object)configMap);
        LeaderInfo leaderInfo = ConfigMapLockUtils.getLeaderInfo((ConfigMap)configMap, members, (String)groupName);
        logger.info("leaderInfo:{}", (Object)leaderInfo.toString());
        Assert.assertNotNull((Object)leaderInfo);
        ConfigMap newConfigMap = ConfigMapLockUtils.getConfigMapWithNewLeader((ConfigMap)configMap, (LeaderInfo)leaderInfo);
        Assert.assertNotNull((Object)newConfigMap);
    }
}

