/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep;

import java.nio.charset.Charset;
import java.time.Duration;
import org.apache.commons.codec.binary.Base64;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.hacep.KafkaUtilTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTest {
    private final String TEST_KAFKA_LOGGER_TOPIC = "testlogs";
    private final String TEST_TOPIC = "test";
    private KafkaUtilTest kafkaServerTest;
    private Logger kafkaLogger = LoggerFactory.getLogger((String)"org.hacep");

    @Before
    public void setUp() throws Exception {
        this.kafkaServerTest = new KafkaUtilTest();
        this.kafkaServerTest.startServer();
    }

    @After
    public void tearDown() {
        this.kafkaServerTest.shutdownServer();
    }

    @Test
    public void basicTest() {
        KafkaProducer producer = this.kafkaServerTest.getByteArrayProducer();
        KafkaConsumer consumer = this.kafkaServerTest.getByteArrayConsumer("test");
        ProducerRecord data = new ProducerRecord("test", (Object)"42", (Object)Base64.encodeBase64((byte[])"test-message".getBytes(Charset.forName("UTF-8"))));
        this.kafkaServerTest.sendSingleMsg(producer, data);
        ConsumerRecords records = consumer.poll(Duration.ofMillis(10000L));
        Assert.assertEquals((long)1L, (long)records.count());
        records.forEach(record -> {
            Assert.assertNotNull((Object)record);
            Assert.assertEquals((Object)"42", (Object)record.key());
            Assert.assertEquals((Object)"test-message", (Object)new String(Base64.decodeBase64((byte[])((byte[])record.value()))));
        });
    }

    @Test
    public void testKafkaLoggerWithStringTest() {
        KafkaConsumer consumerKafkaLogger = this.kafkaServerTest.getStringConsumer("testlogs");
        this.kafkaLogger.warn("test-message");
        ConsumerRecords records = consumerKafkaLogger.poll(Duration.ofMillis(10000L));
        Assert.assertEquals((long)1L, (long)records.count());
        records.forEach(record -> {
            Assert.assertEquals((Object)"testlogs", (Object)record.topic());
            Assert.assertEquals((Object)"test-message", (Object)record.value());
        });
    }
}

