/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.kie.hacep.core.infra.election.KubernetesLockConfiguration;
import org.kie.hacep.core.infra.election.LeaderElection;
import org.kie.hacep.core.infra.election.LeaderElectionImpl;
import org.kie.hacep.core.infra.election.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreKube {
    private static final Logger logger = LoggerFactory.getLogger(CoreKube.class);
    private KubernetesClient kubernetesClient = new DefaultKubernetesClient();
    private KubernetesLockConfiguration configuration;
    private LeaderElection leadership;

    public CoreKube(String namespace, State initialState) {
        this.configuration = this.createKubeConfiguration(namespace);
        this.leadership = new LeaderElectionImpl(this.kubernetesClient, this.configuration, initialState);
    }

    private KubernetesLockConfiguration createKubeConfiguration(String namespace) {
        String podName = System.getenv("POD_NAME");
        if (podName == null) {
            podName = System.getenv("HOSTNAME");
        }
        if (logger.isInfoEnabled()) {
            logger.info("PodName: {}", (Object)podName);
        }
        KubernetesLockConfiguration newConfiguration = new KubernetesLockConfiguration(namespace);
        newConfiguration.setPodName(podName);
        return newConfiguration;
    }

    public LeaderElection getLeaderElection() {
        return this.leadership;
    }
}

