/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra.election;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kie.hacep.core.infra.election.KubernetesLockConfiguration;

public class KubernetesLockConfigurationTest {
    @Test
    public void constructorTest() {
        KubernetesLockConfiguration configuration = new KubernetesLockConfiguration("default");
        Assert.assertNotNull((Object)configuration);
        Assert.assertTrue((boolean)configuration.getClusterLabels().isEmpty());
        Assert.assertEquals((Object)"default-leaders", (Object)configuration.getConfigMapName());
        Assert.assertNull((Object)configuration.getGroupName());
        configuration.setGroupName("Group test");
        Assert.assertEquals((Object)"Group test", (Object)configuration.getGroupName());
        Assert.assertNull((Object)configuration.getPodName());
        configuration.setPodName("Pod test");
        Assert.assertEquals((Object)"Pod test", (Object)configuration.getPodName());
        Assert.assertNull((Object)configuration.getKubernetesResourcesNamespace());
        configuration.setKubernetesResourcesNamespace("Resource name Test");
        Assert.assertEquals((Object)"Resource name Test", (Object)configuration.getKubernetesResourcesNamespace());
        Assert.assertTrue((boolean)configuration.getClusterLabels().isEmpty());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        configuration.setClusterLabels(map);
        Assert.assertFalse((boolean)configuration.getClusterLabels().isEmpty());
        Assert.assertTrue((20000L == configuration.getRenewDeadlineMillis() ? 1 : 0) != 0);
        configuration.setRenewDeadlineMillis(10000L);
        Assert.assertTrue((10000L == configuration.getRenewDeadlineMillis() ? 1 : 0) != 0);
        Assert.assertTrue((5000L == configuration.getRetryPeriodMillis() ? 1 : 0) != 0);
        configuration.setRetryPeriodMillis(3000L);
        Assert.assertTrue((3000L == configuration.getRetryPeriodMillis() ? 1 : 0) != 0);
        Assert.assertTrue((30000L == configuration.getLeaseDurationMillis() ? 1 : 0) != 0);
        configuration.setLeaseDurationMillis(20000L);
        Assert.assertTrue((20000L == configuration.getLeaseDurationMillis() ? 1 : 0) != 0);
        Assert.assertTrue((1.2 == configuration.getJitterFactor() ? 1 : 0) != 0);
        configuration.setJitterFactor(2.4);
        Assert.assertTrue((2.4 == configuration.getJitterFactor() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)configuration.toString());
    }
}

